/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta;

class CharCircBuffer {
    private final int[] buf_;
    private int next_ = 0;
    private int total_ = 0;
    private boolean enabled_ = true;

    CharCircBuffer(int n) {
        this.buf_ = new int[n];
    }

    void enable() {
        this.enabled_ = true;
    }

    void disable() {
        this.enabled_ = false;
    }

    void addInt(int i2) {
        this.addRaw(i2 + 65536);
    }

    void addChar(char ch) {
        this.addRaw(ch);
    }

    private void addRaw(int v) {
        if (this.enabled_) {
            this.buf_[this.next_] = v;
            this.next_ = (this.next_ + 1) % this.buf_.length;
            ++this.total_;
        }
    }

    void addString(String s) {
        char[] chars = s.toCharArray();
        int slen = chars.length;
        for (int i2 = 0; i2 < slen; ++i2) {
            this.addChar(chars[i2]);
        }
    }

    public String toString() {
        int first_;
        StringBuffer result = new StringBuffer(11 * this.buf_.length / 10);
        for (int i2 = first_ = this.total_ < this.buf_.length ? this.buf_.length - this.total_ : 0; i2 < this.buf_.length; ++i2) {
            int ii = (i2 + this.next_) % this.buf_.length;
            int v = this.buf_[ii];
            if (v < 65536) {
                result.append((char)v);
                continue;
            }
            result.append(Integer.toString(v - 65536));
        }
        return result.toString();
    }
}

