/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta;

import com.hp.hpl.sparta.Element;
import com.hp.hpl.sparta.EmptyEnumeration;
import com.hp.hpl.sparta.Node;
import com.hp.hpl.sparta.ParseException;
import com.hp.hpl.sparta.Sparta;
import com.hp.hpl.sparta.XPathVisitor;
import com.hp.hpl.sparta.xpath.Step;
import com.hp.hpl.sparta.xpath.XPath;
import com.hp.hpl.sparta.xpath.XPathException;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Document
extends Node {
    private static final boolean DEBUG = false;
    private static final Integer ONE = new Integer(1);
    static final Enumeration EMPTY = new EmptyEnumeration();
    private Element rootElement_ = null;
    private String systemId_;
    private Sparta.Cache indices_ = Sparta.newCache();
    private Vector observers_ = new Vector();
    private final Hashtable indexible_ = null;

    Document(String systemId) {
        this.systemId_ = systemId;
    }

    public Document() {
        this.systemId_ = "MEMORY";
    }

    @Override
    public Object clone() {
        Document copy = new Document(this.systemId_);
        copy.rootElement_ = (Element)this.rootElement_.clone();
        return copy;
    }

    public String getSystemId() {
        return this.systemId_;
    }

    public void setSystemId(String systemId) {
        this.systemId_ = systemId;
        this.notifyObservers();
    }

    @Override
    public String toString() {
        return this.systemId_;
    }

    public Element getDocumentElement() {
        return this.rootElement_;
    }

    public void setDocumentElement(Element rootElement) {
        this.rootElement_ = rootElement;
        this.rootElement_.setOwnerDocument(this);
        this.notifyObservers();
    }

    private XPathVisitor visitor(String xpath, boolean expectStringValue) throws XPathException {
        if (xpath.charAt(0) != '/') {
            xpath = "/" + xpath;
        }
        return this.visitor(XPath.get(xpath), expectStringValue);
    }

    XPathVisitor visitor(XPath parseTree, boolean expectStringValue) throws XPathException {
        if (parseTree.isStringValue() != expectStringValue) {
            String msg = expectStringValue ? "evaluates to element not string" : "evaluates to string not element";
            throw new XPathException(parseTree, "\"" + parseTree + "\" evaluates to " + msg);
        }
        return new XPathVisitor(this, parseTree);
    }

    @Override
    public Enumeration xpathSelectElements(String xpath) throws ParseException {
        try {
            if (xpath.charAt(0) != '/') {
                xpath = "/" + xpath;
            }
            XPath parseTree = XPath.get(xpath);
            this.monitor(parseTree);
            return this.visitor(parseTree, false).getResultEnumeration();
        }
        catch (XPathException e) {
            throw new ParseException("XPath problem", e);
        }
    }

    void monitor(XPath parseTree) throws XPathException {
    }

    @Override
    public Enumeration xpathSelectStrings(String xpath) throws ParseException {
        try {
            return this.visitor(xpath, true).getResultEnumeration();
        }
        catch (XPathException e) {
            throw new ParseException("XPath problem", e);
        }
    }

    @Override
    public Element xpathSelectElement(String xpath) throws ParseException {
        try {
            if (xpath.charAt(0) != '/') {
                xpath = "/" + xpath;
            }
            XPath parseTree = XPath.get(xpath);
            this.monitor(parseTree);
            return this.visitor(parseTree, false).getFirstResultElement();
        }
        catch (XPathException e) {
            throw new ParseException("XPath problem", e);
        }
    }

    @Override
    public String xpathSelectString(String xpath) throws ParseException {
        try {
            return this.visitor(xpath, true).getFirstResultString();
        }
        catch (XPathException e) {
            throw new ParseException("XPath problem", e);
        }
    }

    public boolean xpathEnsure(String xpath) throws ParseException {
        try {
            if (this.xpathSelectElement(xpath) != null) {
                return false;
            }
            XPath parseTree = XPath.get(xpath);
            int stepCount = 0;
            Enumeration i2 = parseTree.getSteps();
            while (i2.hasMoreElements()) {
                i2.nextElement();
                ++stepCount;
            }
            i2 = parseTree.getSteps();
            Step firstStep = (Step)i2.nextElement();
            Step[] rootElemSteps = new Step[stepCount - 1];
            for (int j = 0; j < rootElemSteps.length; ++j) {
                rootElemSteps[j] = (Step)i2.nextElement();
            }
            if (this.rootElement_ == null) {
                Element newRoot = this.makeMatching(null, firstStep, xpath);
                this.setDocumentElement(newRoot);
            } else {
                Element expectedRoot = this.xpathSelectElement("/" + firstStep);
                if (expectedRoot == null) {
                    throw new ParseException("Existing root element <" + this.rootElement_.getTagName() + "...> does not match first step \"" + firstStep + "\" of \"" + xpath);
                }
            }
            if (rootElemSteps.length == 0) {
                return true;
            }
            return this.rootElement_.xpathEnsure(XPath.get(false, rootElemSteps).toString());
        }
        catch (XPathException e) {
            throw new ParseException(xpath, e);
        }
    }

    public boolean xpathHasIndex(String xpath) {
        return this.indices_.get(xpath) != null;
    }

    public Index xpathGetIndex(String xpath) throws ParseException {
        try {
            Index index = (Index)this.indices_.get(xpath);
            if (index == null) {
                XPath xp = XPath.get(xpath);
                index = new Index(xp);
                this.indices_.put(xpath, index);
            }
            return index;
        }
        catch (XPathException e) {
            throw new ParseException("XPath problem", e);
        }
    }

    public void addObserver(Observer observer) {
        this.observers_.addElement(observer);
    }

    public void deleteObserver(Observer observer) {
        this.observers_.removeElement(observer);
    }

    @Override
    public void toString(Writer writer) throws IOException {
        this.rootElement_.toString(writer);
    }

    @Override
    void notifyObservers() {
        Enumeration i2 = this.observers_.elements();
        while (i2.hasMoreElements()) {
            ((Observer)i2.nextElement()).update(this);
        }
    }

    @Override
    public void toXml(Writer writer) throws IOException {
        writer.write("<?xml version=\"1.0\" ?>\n");
        this.rootElement_.toXml(writer);
    }

    public boolean equals(Object thatO) {
        if (this == thatO) {
            return true;
        }
        if (!(thatO instanceof Document)) {
            return false;
        }
        Document that = (Document)thatO;
        return this.rootElement_.equals(that.rootElement_);
    }

    @Override
    protected int computeHashCode() {
        return this.rootElement_.hashCode();
    }

    public static interface Observer {
        public void update(Document var1);
    }

    public class Index
    implements Observer {
        private transient Sparta.Cache dict_ = null;
        private final XPath xpath_;
        private final String attrName_;

        Index(XPath xpath) throws XPathException {
            this.attrName_ = xpath.getIndexingAttrName();
            this.xpath_ = xpath;
            Document.this.addObserver(this);
        }

        public synchronized Enumeration get(String attrValue) throws ParseException {
            Vector elemList;
            if (this.dict_ == null) {
                this.regenerate();
            }
            return (elemList = (Vector)this.dict_.get(attrValue)) == null ? EMPTY : elemList.elements();
        }

        public synchronized int size() throws ParseException {
            if (this.dict_ == null) {
                this.regenerate();
            }
            return this.dict_.size();
        }

        @Override
        public synchronized void update(Document doc) {
            this.dict_ = null;
        }

        private void regenerate() throws ParseException {
            try {
                this.dict_ = Sparta.newCache();
                Enumeration i2 = Document.this.visitor(this.xpath_, false).getResultEnumeration();
                while (i2.hasMoreElements()) {
                    Element elem = (Element)i2.nextElement();
                    String attrValue = elem.getAttribute(this.attrName_);
                    Vector<Element> elemList = (Vector<Element>)this.dict_.get(attrValue);
                    if (elemList == null) {
                        elemList = new Vector<Element>(1);
                        this.dict_.put(attrValue, elemList);
                    }
                    elemList.addElement(elem);
                }
            }
            catch (XPathException e) {
                throw new ParseException("XPath problem", e);
            }
        }
    }
}

