/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta;

import com.hp.hpl.sparta.DOMException;
import com.hp.hpl.sparta.Document;
import com.hp.hpl.sparta.Node;
import com.hp.hpl.sparta.ParseException;
import com.hp.hpl.sparta.Sparta;
import com.hp.hpl.sparta.Text;
import com.hp.hpl.sparta.XPathVisitor;
import com.hp.hpl.sparta.xpath.Step;
import com.hp.hpl.sparta.xpath.XPath;
import com.hp.hpl.sparta.xpath.XPathException;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class Element
extends Node {
    private static final boolean DEBUG = false;
    private Node firstChild_ = null;
    private Node lastChild_ = null;
    private Hashtable attributes_ = null;
    private Vector attributeNames_ = null;
    private String tagName_ = null;

    public Element(String tagName) {
        this.tagName_ = Sparta.intern(tagName);
    }

    Element() {
    }

    @Override
    public Object clone() {
        return this.cloneElement(true);
    }

    public Element cloneShallow() {
        return this.cloneElement(false);
    }

    public Element cloneElement(boolean deep) {
        Element result = new Element(this.tagName_);
        if (this.attributeNames_ != null) {
            Enumeration i2 = this.attributeNames_.elements();
            while (i2.hasMoreElements()) {
                String name = (String)i2.nextElement();
                result.setAttribute(name, (String)this.attributes_.get(name));
            }
        }
        if (deep) {
            for (Node n = this.firstChild_; n != null; n = n.getNextSibling()) {
                result.appendChild((Node)n.clone());
            }
        }
        return result;
    }

    public String getTagName() {
        return this.tagName_;
    }

    public void setTagName(String tagName) {
        this.tagName_ = Sparta.intern(tagName);
        this.notifyObservers();
    }

    public Node getFirstChild() {
        return this.firstChild_;
    }

    public Node getLastChild() {
        return this.lastChild_;
    }

    public Enumeration getAttributeNames() {
        if (this.attributeNames_ == null) {
            return Document.EMPTY;
        }
        return this.attributeNames_.elements();
    }

    public String getAttribute(String name) {
        return this.attributes_ == null ? null : (String)this.attributes_.get(name);
    }

    public void setAttribute(String name, String value) {
        if (this.attributes_ == null) {
            this.attributes_ = new Hashtable();
            this.attributeNames_ = new Vector();
        }
        if (this.attributes_.get(name) == null) {
            this.attributeNames_.addElement(name);
        }
        this.attributes_.put(name, value);
        this.notifyObservers();
    }

    public void removeAttribute(String name) {
        if (this.attributes_ == null) {
            return;
        }
        this.attributes_.remove(name);
        this.attributeNames_.removeElement(name);
        this.notifyObservers();
    }

    void appendChildNoChecking(Node addedChild) {
        Element oldParent = addedChild.getParentNode();
        if (oldParent != null) {
            oldParent.removeChildNoChecking(addedChild);
        }
        addedChild.insertAtEndOfLinkedList(this.lastChild_);
        if (this.firstChild_ == null) {
            this.firstChild_ = addedChild;
        }
        addedChild.setParentNode(this);
        this.lastChild_ = addedChild;
        addedChild.setOwnerDocument(this.getOwnerDocument());
    }

    public void appendChild(Node addedChild) {
        if (!this.canHaveAsDescendent(addedChild)) {
            addedChild = (Element)addedChild.clone();
        }
        this.appendChildNoChecking(addedChild);
        this.notifyObservers();
    }

    boolean canHaveAsDescendent(Node node) {
        if (node == this) {
            return false;
        }
        Element parent = this.getParentNode();
        if (parent == null) {
            return true;
        }
        return parent.canHaveAsDescendent(node);
    }

    private boolean removeChildNoChecking(Node childToRemove) {
        int i2 = 0;
        for (Node child = this.firstChild_; child != null; child = child.getNextSibling()) {
            if (child.equals(childToRemove)) {
                if (this.firstChild_ == child) {
                    this.firstChild_ = child.getNextSibling();
                }
                if (this.lastChild_ == child) {
                    this.lastChild_ = child.getPreviousSibling();
                }
                child.removeFromLinkedList();
                child.setParentNode(null);
                child.setOwnerDocument(null);
                return true;
            }
            ++i2;
        }
        return false;
    }

    public void removeChild(Node childToRemove) throws DOMException {
        boolean found = this.removeChildNoChecking(childToRemove);
        if (!found) {
            throw new DOMException(8, "Cannot find " + childToRemove + " in " + this);
        }
        this.notifyObservers();
    }

    public void replaceChild(Element newChild, Node oldChild) throws DOMException {
        this.replaceChild_(newChild, oldChild);
        this.notifyObservers();
    }

    public void replaceChild(Text newChild, Node oldChild) throws DOMException {
        this.replaceChild_(newChild, oldChild);
        this.notifyObservers();
    }

    private void replaceChild_(Node newChild, Node oldChild) throws DOMException {
        int i2 = 0;
        for (Node child = this.firstChild_; child != null; child = child.getNextSibling()) {
            if (child == oldChild) {
                if (this.firstChild_ == oldChild) {
                    this.firstChild_ = newChild;
                }
                if (this.lastChild_ == oldChild) {
                    this.lastChild_ = newChild;
                }
                oldChild.replaceInLinkedList(newChild);
                newChild.setParentNode(this);
                oldChild.setParentNode(null);
                return;
            }
            ++i2;
        }
        throw new DOMException(8, "Cannot find " + oldChild + " in " + this);
    }

    @Override
    void toString(Writer writer) throws IOException {
        for (Node i2 = this.firstChild_; i2 != null; i2 = i2.getNextSibling()) {
            i2.toString(writer);
        }
    }

    @Override
    public void toXml(Writer writer) throws IOException {
        Object i2;
        writer.write("<" + this.tagName_);
        if (this.attributeNames_ != null) {
            i2 = this.attributeNames_.elements();
            while (i2.hasMoreElements()) {
                String name = (String)i2.nextElement();
                String value = (String)this.attributes_.get(name);
                writer.write(" " + name + "=\"");
                Element.htmlEncode(writer, value);
                writer.write("\"");
            }
        }
        if (this.firstChild_ == null) {
            writer.write("/>");
        } else {
            writer.write(">");
            for (i2 = this.firstChild_; i2 != null; i2 = ((Node)i2).getNextSibling()) {
                ((Node)i2).toXml(writer);
            }
            writer.write("</" + this.tagName_ + ">");
        }
    }

    private XPathVisitor visitor(String xpath, boolean expectStringValue) throws XPathException {
        XPath parseTree = XPath.get(xpath);
        if (parseTree.isStringValue() != expectStringValue) {
            String msg = expectStringValue ? "evaluates to element not string" : "evaluates to string not element";
            throw new XPathException(parseTree, "\"" + parseTree + "\" evaluates to " + msg);
        }
        return new XPathVisitor(this, parseTree);
    }

    @Override
    public Enumeration xpathSelectElements(String xpath) throws ParseException {
        try {
            return this.visitor(xpath, false).getResultEnumeration();
        }
        catch (XPathException e) {
            throw new ParseException("XPath problem", e);
        }
    }

    @Override
    public Enumeration xpathSelectStrings(String xpath) throws ParseException {
        try {
            return this.visitor(xpath, true).getResultEnumeration();
        }
        catch (XPathException e) {
            throw new ParseException("XPath problem", e);
        }
    }

    public boolean xpathEnsure(String xpath) throws ParseException {
        try {
            Element parent;
            if (this.xpathSelectElement(xpath) != null) {
                return false;
            }
            XPath parseTree = XPath.get(xpath);
            int stepCount = 0;
            Enumeration i2 = parseTree.getSteps();
            while (i2.hasMoreElements()) {
                i2.nextElement();
                ++stepCount;
            }
            Step[] parentSteps = new Step[stepCount - 1];
            Enumeration i3 = parseTree.getSteps();
            for (int j = 0; j < parentSteps.length; ++j) {
                parentSteps[j] = (Step)i3.nextElement();
            }
            Step lastStep = (Step)i3.nextElement();
            if (parentSteps.length == 0) {
                parent = this;
            } else {
                String parentXPath = XPath.get(parseTree.isAbsolute(), parentSteps).toString();
                this.xpathEnsure(parentXPath.toString());
                parent = this.xpathSelectElement(parentXPath);
            }
            Element newChild = this.makeMatching(parent, lastStep, xpath);
            parent.appendChildNoChecking(newChild);
            return true;
        }
        catch (XPathException e) {
            throw new ParseException(xpath, e);
        }
    }

    @Override
    public Element xpathSelectElement(String xpath) throws ParseException {
        try {
            return this.visitor(xpath, false).getFirstResultElement();
        }
        catch (XPathException e) {
            throw new ParseException("XPath problem", e);
        }
    }

    @Override
    public String xpathSelectString(String xpath) throws ParseException {
        try {
            return this.visitor(xpath, true).getFirstResultString();
        }
        catch (XPathException e) {
            throw new ParseException("XPath problem", e);
        }
    }

    public boolean equals(Object thatO) {
        int thatAttrCount;
        if (this == thatO) {
            return true;
        }
        if (!(thatO instanceof Element)) {
            return false;
        }
        Element that = (Element)thatO;
        if (!this.tagName_.equals(that.tagName_)) {
            return false;
        }
        int thisAttrCount = this.attributes_ == null ? 0 : this.attributes_.size();
        int n = thatAttrCount = that.attributes_ == null ? 0 : that.attributes_.size();
        if (thisAttrCount != thatAttrCount) {
            return false;
        }
        if (this.attributes_ != null) {
            Enumeration i2 = this.attributes_.keys();
            while (i2.hasMoreElements()) {
                String thatValue;
                String key = (String)i2.nextElement();
                String thisValue = (String)this.attributes_.get(key);
                if (thisValue.equals(thatValue = (String)that.attributes_.get(key))) continue;
                return false;
            }
        }
        Node thisChild = this.firstChild_;
        Node thatChild = that.firstChild_;
        while (thisChild != null) {
            if (!thisChild.equals(thatChild)) {
                return false;
            }
            thisChild = thisChild.getNextSibling();
            thatChild = thatChild.getNextSibling();
        }
        return true;
    }

    @Override
    protected int computeHashCode() {
        Object i2;
        int hash = this.tagName_.hashCode();
        if (this.attributes_ != null) {
            i2 = this.attributes_.keys();
            while (i2.hasMoreElements()) {
                String key = (String)i2.nextElement();
                hash = 31 * hash + key.hashCode();
                String value = (String)this.attributes_.get(key);
                hash = 31 * hash + value.hashCode();
            }
        }
        for (i2 = this.firstChild_; i2 != null; i2 = ((Node)i2).getNextSibling()) {
            hash = 31 * hash + ((Node)i2).hashCode();
        }
        return hash;
    }

    private void checkInvariant() {
    }
}

