/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta;

import com.hp.hpl.sparta.DOMException;
import com.hp.hpl.sparta.Document;
import com.hp.hpl.sparta.Element;
import com.hp.hpl.sparta.ParseException;
import com.hp.hpl.sparta.Text;
import com.hp.hpl.sparta.xpath.AttrEqualsExpr;
import com.hp.hpl.sparta.xpath.AttrExistsExpr;
import com.hp.hpl.sparta.xpath.AttrGreaterExpr;
import com.hp.hpl.sparta.xpath.AttrLessExpr;
import com.hp.hpl.sparta.xpath.AttrNotEqualsExpr;
import com.hp.hpl.sparta.xpath.BooleanExpr;
import com.hp.hpl.sparta.xpath.BooleanExprVisitor;
import com.hp.hpl.sparta.xpath.ElementTest;
import com.hp.hpl.sparta.xpath.NodeTest;
import com.hp.hpl.sparta.xpath.PositionEqualsExpr;
import com.hp.hpl.sparta.xpath.Step;
import com.hp.hpl.sparta.xpath.TextEqualsExpr;
import com.hp.hpl.sparta.xpath.TextExistsExpr;
import com.hp.hpl.sparta.xpath.TextNotEqualsExpr;
import com.hp.hpl.sparta.xpath.TrueExpr;
import com.hp.hpl.sparta.xpath.XPath;
import com.hp.hpl.sparta.xpath.XPathException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;

public abstract class Node {
    private Document doc_ = null;
    private Element parentNode_ = null;
    private Node previousSibling_ = null;
    private Node nextSibling_ = null;
    private Object annotation_ = null;
    private int hash_ = 0;

    void notifyObservers() {
        this.hash_ = 0;
        if (this.doc_ != null) {
            this.doc_.notifyObservers();
        }
    }

    void setOwnerDocument(Document doc) {
        this.doc_ = doc;
    }

    public Document getOwnerDocument() {
        return this.doc_;
    }

    public Element getParentNode() {
        return this.parentNode_;
    }

    public Node getPreviousSibling() {
        return this.previousSibling_;
    }

    public Node getNextSibling() {
        return this.nextSibling_;
    }

    public Object getAnnotation() {
        return this.annotation_;
    }

    public void setAnnotation(Object annotation) {
        this.annotation_ = annotation;
    }

    void setParentNode(Element parentNode) {
        this.parentNode_ = parentNode;
    }

    void insertAtEndOfLinkedList(Node lastChild) {
        this.previousSibling_ = lastChild;
        if (lastChild != null) {
            lastChild.nextSibling_ = this;
        }
    }

    void removeFromLinkedList() {
        if (this.previousSibling_ != null) {
            this.previousSibling_.nextSibling_ = this.nextSibling_;
        }
        if (this.nextSibling_ != null) {
            this.nextSibling_.previousSibling_ = this.previousSibling_;
        }
        this.nextSibling_ = null;
        this.previousSibling_ = null;
    }

    void replaceInLinkedList(Node replacement) {
        if (this.previousSibling_ != null) {
            this.previousSibling_.nextSibling_ = replacement;
        }
        if (this.nextSibling_ != null) {
            this.nextSibling_.previousSibling_ = replacement;
        }
        replacement.nextSibling_ = this.nextSibling_;
        replacement.previousSibling_ = this.previousSibling_;
        this.nextSibling_ = null;
        this.previousSibling_ = null;
    }

    public String toXml() throws IOException {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        OutputStreamWriter w = new OutputStreamWriter(o);
        this.toXml(w);
        ((Writer)w).flush();
        return new String(o.toByteArray());
    }

    public boolean xpathSetStrings(String xpath, String value) throws ParseException {
        boolean changed = false;
        try {
            int slash = xpath.lastIndexOf(47);
            if (!xpath.substring(slash + 1).equals("text()") && xpath.charAt(slash + 1) != '@') {
                throw new ParseException("Last step of Xpath expression \"" + xpath + "\" is not \"text()\" and does not start with a '@'. It starts with a '" + xpath.charAt(slash + 1) + "'");
            }
            String elemXPath = xpath.substring(0, slash);
            if (xpath.charAt(slash + 1) == '@') {
                String attrName = xpath.substring(slash + 2);
                if (attrName.length() == 0) {
                    throw new ParseException("Xpath expression \"" + xpath + "\" specifies zero-length attribute name\"");
                }
                Enumeration i2 = this.xpathSelectElements(elemXPath);
                while (i2.hasMoreElements()) {
                    Element element = (Element)i2.nextElement();
                    String oldValue = element.getAttribute(attrName);
                    if (value.equals(oldValue)) continue;
                    element.setAttribute(attrName, value);
                    changed = true;
                }
            } else {
                Enumeration i3 = this.xpathSelectElements(elemXPath);
                changed = i3.hasMoreElements();
                while (i3.hasMoreElements()) {
                    Element parentOfText = (Element)i3.nextElement();
                    Vector<Text> textNodes = new Vector<Text>();
                    for (Node j = parentOfText.getFirstChild(); j != null; j = j.getNextSibling()) {
                        if (!(j instanceof Text)) continue;
                        textNodes.addElement((Text)j);
                    }
                    if (textNodes.size() == 0) {
                        Text text = new Text(value);
                        if (text.getData().length() <= 0) continue;
                        parentOfText.appendChild(text);
                        changed = true;
                        continue;
                    }
                    Text first = (Text)textNodes.elementAt(0);
                    if (!first.getData().equals(value)) {
                        textNodes.removeElementAt(0);
                        first.setData(value);
                        changed = true;
                    }
                    for (int j = 0; j < textNodes.size(); ++j) {
                        Text text = (Text)textNodes.elementAt(j);
                        parentOfText.removeChild(text);
                        changed = true;
                    }
                }
            }
            return changed;
        }
        catch (DOMException e) {
            throw new Error("Assertion failed " + e);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParseException("Xpath expression \"" + xpath + "\" is not in the form \"xpathExpression/@attributeName\"");
        }
    }

    Element makeMatching(final Element parent, Step step, final String msgContext) throws ParseException, XPathException {
        NodeTest nodeTest = step.getNodeTest();
        if (!(nodeTest instanceof ElementTest)) {
            throw new ParseException("\"" + nodeTest + "\" in \"" + msgContext + "\" is not an element test");
        }
        ElementTest elemTest = (ElementTest)nodeTest;
        final String tagName = elemTest.getTagName();
        final Element newChild = new Element(tagName);
        BooleanExpr predicate = step.getPredicate();
        predicate.accept(new BooleanExprVisitor(){

            @Override
            public void visit(TrueExpr a) {
            }

            @Override
            public void visit(AttrExistsExpr a) throws XPathException {
                newChild.setAttribute(a.getAttrName(), "something");
            }

            @Override
            public void visit(AttrEqualsExpr a) throws XPathException {
                newChild.setAttribute(a.getAttrName(), a.getAttrValue());
            }

            @Override
            public void visit(AttrNotEqualsExpr a) throws XPathException {
                newChild.setAttribute(a.getAttrName(), "not " + a.getAttrValue());
            }

            @Override
            public void visit(AttrLessExpr a) throws XPathException {
                newChild.setAttribute(a.getAttrName(), Long.toString(Long.MIN_VALUE));
            }

            @Override
            public void visit(AttrGreaterExpr a) throws XPathException {
                newChild.setAttribute(a.getAttrName(), Long.toString(Long.MAX_VALUE));
            }

            @Override
            public void visit(TextExistsExpr a) throws XPathException {
                newChild.appendChild(new Text("something"));
            }

            @Override
            public void visit(TextEqualsExpr a) throws XPathException {
                newChild.appendChild(new Text(a.getValue()));
            }

            @Override
            public void visit(TextNotEqualsExpr a) throws XPathException {
                newChild.appendChild(new Text("not " + a.getValue()));
            }

            @Override
            public void visit(PositionEqualsExpr a) throws XPathException {
                int posn = a.getPosition();
                if (parent == null && posn != 1) {
                    throw new XPathException(XPath.get(msgContext), "Position of root node must be 1");
                }
                for (int lastPosition = 1; lastPosition < posn; ++lastPosition) {
                    parent.appendChild(new Element(tagName));
                }
            }
        });
        return newChild;
    }

    public abstract Enumeration xpathSelectElements(String var1) throws ParseException;

    public abstract Enumeration xpathSelectStrings(String var1) throws ParseException;

    public abstract Element xpathSelectElement(String var1) throws ParseException;

    public abstract String xpathSelectString(String var1) throws ParseException;

    public abstract Object clone();

    public String toString() {
        try {
            ByteArrayOutputStream o = new ByteArrayOutputStream();
            OutputStreamWriter w = new OutputStreamWriter(o);
            this.toString(w);
            ((Writer)w).flush();
            return new String(o.toByteArray());
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    abstract void toString(Writer var1) throws IOException;

    abstract void toXml(Writer var1) throws IOException;

    protected static void htmlEncode(Writer writer, String string) throws IOException {
        int n = string.length();
        int writeNext = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            String encoded;
            char ch = string.charAt(i2);
            if (ch >= '\u0080') {
                encoded = "&#" + ch + ";";
            } else {
                switch (ch) {
                    case '<': {
                        encoded = "&lt;";
                        break;
                    }
                    case '>': {
                        encoded = "&gt;";
                        break;
                    }
                    case '&': {
                        encoded = "&amp;";
                        break;
                    }
                    case '\"': {
                        encoded = "&quot;";
                        break;
                    }
                    case '\'': {
                        encoded = "&#39;";
                        break;
                    }
                    default: {
                        encoded = null;
                    }
                }
            }
            if (encoded == null) continue;
            writer.write(string, writeNext, i2 - writeNext);
            writer.write(encoded);
            writeNext = i2 + 1;
        }
        if (writeNext < n) {
            writer.write(string, writeNext, n - writeNext);
        }
    }

    protected abstract int computeHashCode();

    public int hashCode() {
        if (this.hash_ == 0) {
            this.hash_ = this.computeHashCode();
        }
        return this.hash_;
    }
}

