/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.sparta;

import com.hp.hpl.sparta.Document;
import com.hp.hpl.sparta.Element;
import com.hp.hpl.sparta.Node;
import com.hp.hpl.sparta.NodeListWithPosition;
import com.hp.hpl.sparta.Text;
import com.hp.hpl.sparta.xpath.AllElementTest;
import com.hp.hpl.sparta.xpath.AttrEqualsExpr;
import com.hp.hpl.sparta.xpath.AttrExistsExpr;
import com.hp.hpl.sparta.xpath.AttrGreaterExpr;
import com.hp.hpl.sparta.xpath.AttrLessExpr;
import com.hp.hpl.sparta.xpath.AttrNotEqualsExpr;
import com.hp.hpl.sparta.xpath.AttrTest;
import com.hp.hpl.sparta.xpath.BooleanExpr;
import com.hp.hpl.sparta.xpath.ElementTest;
import com.hp.hpl.sparta.xpath.ParentNodeTest;
import com.hp.hpl.sparta.xpath.PositionEqualsExpr;
import com.hp.hpl.sparta.xpath.Step;
import com.hp.hpl.sparta.xpath.TextEqualsExpr;
import com.hp.hpl.sparta.xpath.TextExistsExpr;
import com.hp.hpl.sparta.xpath.TextNotEqualsExpr;
import com.hp.hpl.sparta.xpath.TextTest;
import com.hp.hpl.sparta.xpath.ThisNodeTest;
import com.hp.hpl.sparta.xpath.TrueExpr;
import com.hp.hpl.sparta.xpath.Visitor;
import com.hp.hpl.sparta.xpath.XPath;
import com.hp.hpl.sparta.xpath.XPathException;
import java.util.Enumeration;
import java.util.Vector;

class XPathVisitor
implements Visitor {
    private static final Boolean TRUE = new Boolean(true);
    private static final Boolean FALSE = new Boolean(false);
    private final NodeListWithPosition nodelistRaw_ = new NodeListWithPosition();
    private Vector nodelistFiltered_ = new Vector();
    private Enumeration nodesetIterator_ = null;
    private Object node_ = null;
    private final BooleanStack exprStack_ = new BooleanStack();
    private Node contextNode_;
    private boolean multiLevel_;
    private XPath xpath_;

    private XPathVisitor(XPath xpath, Node context) throws XPathException {
        this.xpath_ = xpath;
        this.contextNode_ = context;
        this.nodelistFiltered_ = new Vector(1);
        this.nodelistFiltered_.addElement(this.contextNode_);
        Enumeration i2 = xpath.getSteps();
        while (i2.hasMoreElements()) {
            Step step = (Step)i2.nextElement();
            this.multiLevel_ = step.isMultiLevel();
            this.nodesetIterator_ = null;
            step.getNodeTest().accept(this);
            this.nodesetIterator_ = this.nodelistRaw_.iterator();
            this.nodelistFiltered_.removeAllElements();
            BooleanExpr predicate = step.getPredicate();
            while (this.nodesetIterator_.hasMoreElements()) {
                this.node_ = this.nodesetIterator_.nextElement();
                predicate.accept(this);
                Boolean expr = this.exprStack_.pop();
                if (!expr.booleanValue()) continue;
                this.nodelistFiltered_.addElement(this.node_);
            }
        }
    }

    public XPathVisitor(Element context, XPath xpath) throws XPathException {
        this(xpath, context);
        if (xpath.isAbsolute()) {
            throw new XPathException(xpath, "Cannot use element as context node for absolute xpath");
        }
    }

    public XPathVisitor(Document context, XPath xpath) throws XPathException {
        this(xpath, context);
    }

    @Override
    public void visit(ThisNodeTest a) {
        this.nodelistRaw_.removeAllElements();
        this.nodelistRaw_.add(this.contextNode_, 1);
    }

    @Override
    public void visit(ParentNodeTest a) throws XPathException {
        this.nodelistRaw_.removeAllElements();
        Element parent = this.contextNode_.getParentNode();
        if (parent == null) {
            throw new XPathException(this.xpath_, "Illegal attempt to apply \"..\" to node with no parent.");
        }
        this.nodelistRaw_.add(parent, 1);
    }

    @Override
    public void visit(AllElementTest a) {
        Vector oldNodeList = this.nodelistFiltered_;
        this.nodelistRaw_.removeAllElements();
        Enumeration i2 = oldNodeList.elements();
        while (i2.hasMoreElements()) {
            Object node = i2.nextElement();
            if (node instanceof Element) {
                this.accumulateElements((Element)node);
                continue;
            }
            if (!(node instanceof Document)) continue;
            this.accumulateElements((Document)node);
        }
    }

    private void accumulateElements(Document doc) {
        Element child = doc.getDocumentElement();
        this.nodelistRaw_.add(child, 1);
        if (this.multiLevel_) {
            this.accumulateElements(child);
        }
    }

    private void accumulateElements(Element element) {
        int position = 0;
        for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!(n instanceof Element)) continue;
            this.nodelistRaw_.add(n, ++position);
            if (!this.multiLevel_) continue;
            this.accumulateElements((Element)n);
        }
    }

    @Override
    public void visit(TextTest a) {
        Vector oldNodeList = this.nodelistFiltered_;
        this.nodelistRaw_.removeAllElements();
        Enumeration i2 = oldNodeList.elements();
        while (i2.hasMoreElements()) {
            Object node = i2.nextElement();
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!(n instanceof Text)) continue;
                this.nodelistRaw_.add(((Text)n).getData());
            }
        }
    }

    @Override
    public void visit(ElementTest test) {
        String tagName = test.getTagName();
        Vector oldNodeList = this.nodelistFiltered_;
        int n = oldNodeList.size();
        this.nodelistRaw_.removeAllElements();
        for (int i2 = 0; i2 < n; ++i2) {
            Object node = oldNodeList.elementAt(i2);
            if (node instanceof Element) {
                this.accumulateMatchingElements((Element)node, tagName);
                continue;
            }
            if (!(node instanceof Document)) continue;
            this.accumulateMatchingElements((Document)node, tagName);
        }
    }

    private void accumulateMatchingElements(Document document, String tagName) {
        Element child = document.getDocumentElement();
        if (child == null) {
            return;
        }
        if (child.getTagName() == tagName) {
            this.nodelistRaw_.add(child, 1);
        }
        if (this.multiLevel_) {
            this.accumulateMatchingElements(child, tagName);
        }
    }

    private void accumulateMatchingElements(Element element, String tagName) {
        int position = 0;
        for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!(n instanceof Element)) continue;
            Element child = (Element)n;
            if (child.getTagName() == tagName) {
                this.nodelistRaw_.add(child, ++position);
            }
            if (!this.multiLevel_) continue;
            this.accumulateMatchingElements(child, tagName);
        }
    }

    @Override
    public void visit(AttrTest test) {
        Vector oldNodeList = this.nodelistFiltered_;
        this.nodelistRaw_.removeAllElements();
        Enumeration i2 = oldNodeList.elements();
        while (i2.hasMoreElements()) {
            Element element;
            String attr;
            Node node = (Node)i2.nextElement();
            if (!(node instanceof Element) || (attr = (element = (Element)node).getAttribute(test.getAttrName())) == null) continue;
            this.nodelistRaw_.add(attr);
        }
    }

    @Override
    public void visit(TrueExpr a) {
        this.exprStack_.push(TRUE);
    }

    @Override
    public void visit(AttrExistsExpr a) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test attribute of document");
        }
        Element element = (Element)this.node_;
        String attrValue = element.getAttribute(a.getAttrName());
        boolean result = attrValue != null && attrValue.length() > 0;
        this.exprStack_.push(result ? TRUE : FALSE);
    }

    @Override
    public void visit(AttrEqualsExpr a) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test attribute of document");
        }
        Element element = (Element)this.node_;
        String attrValue = element.getAttribute(a.getAttrName());
        boolean result = a.getAttrValue().equals(attrValue);
        this.exprStack_.push(result ? TRUE : FALSE);
    }

    @Override
    public void visit(AttrNotEqualsExpr a) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test attribute of document");
        }
        Element element = (Element)this.node_;
        String attrValue = element.getAttribute(a.getAttrName());
        boolean result = !a.getAttrValue().equals(attrValue);
        this.exprStack_.push(result ? TRUE : FALSE);
    }

    @Override
    public void visit(AttrLessExpr a) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test attribute of document");
        }
        Element element = (Element)this.node_;
        long attrValue = Long.parseLong(element.getAttribute(a.getAttrName()));
        boolean result = (double)attrValue < a.getAttrValue();
        this.exprStack_.push(result ? TRUE : FALSE);
    }

    @Override
    public void visit(AttrGreaterExpr a) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test attribute of document");
        }
        Element element = (Element)this.node_;
        long attrValue = Long.parseLong(element.getAttribute(a.getAttrName()));
        boolean result = (double)attrValue > a.getAttrValue();
        this.exprStack_.push(result ? TRUE : FALSE);
    }

    @Override
    public void visit(TextExistsExpr a) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test attribute of document");
        }
        Element element = (Element)this.node_;
        for (Node i2 = element.getFirstChild(); i2 != null; i2 = i2.getNextSibling()) {
            if (!(i2 instanceof Text)) continue;
            this.exprStack_.push(TRUE);
            return;
        }
        this.exprStack_.push(FALSE);
    }

    @Override
    public void visit(TextEqualsExpr a) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test attribute of document");
        }
        Element element = (Element)this.node_;
        for (Node i2 = element.getFirstChild(); i2 != null; i2 = i2.getNextSibling()) {
            Text text;
            if (!(i2 instanceof Text) || !(text = (Text)i2).getData().equals(a.getValue())) continue;
            this.exprStack_.push(TRUE);
            return;
        }
        this.exprStack_.push(FALSE);
    }

    @Override
    public void visit(TextNotEqualsExpr a) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test attribute of document");
        }
        Element element = (Element)this.node_;
        for (Node i2 = element.getFirstChild(); i2 != null; i2 = i2.getNextSibling()) {
            Text text;
            if (!(i2 instanceof Text) || (text = (Text)i2).getData().equals(a.getValue())) continue;
            this.exprStack_.push(TRUE);
            return;
        }
        this.exprStack_.push(FALSE);
    }

    @Override
    public void visit(PositionEqualsExpr a) throws XPathException {
        if (!(this.node_ instanceof Element)) {
            throw new XPathException(this.xpath_, "Cannot test position of document");
        }
        Element element = (Element)this.node_;
        boolean result = this.nodelistRaw_.position(element) == a.getPosition();
        this.exprStack_.push(result ? TRUE : FALSE);
    }

    public Enumeration getResultEnumeration() {
        return this.nodelistFiltered_.elements();
    }

    public Element getFirstResultElement() {
        return this.nodelistFiltered_.size() == 0 ? null : (Element)this.nodelistFiltered_.elementAt(0);
    }

    public String getFirstResultString() {
        return this.nodelistFiltered_.size() == 0 ? null : this.nodelistFiltered_.elementAt(0).toString();
    }

    private static class BooleanStack {
        private Item top_ = null;

        private BooleanStack() {
        }

        void push(Boolean b) {
            this.top_ = new Item(b, this.top_);
        }

        Boolean pop() {
            Boolean result = this.top_.bool;
            this.top_ = this.top_.prev;
            return result;
        }

        private static class Item {
            final Boolean bool;
            final Item prev;

            Item(Boolean b, Item p2) {
                this.bool = b;
                this.prev = p2;
            }
        }
    }
}

