/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Font;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Utilities;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfSmartCopy;
import com.itextpdf.text.pdf.TrueTypeFont;
import java.text.MessageFormat;
import java.util.ArrayList;

public class FontSelector {
    private static final Logger LOGGER = LoggerFactory.getLogger(PdfSmartCopy.class);
    protected ArrayList<Font> fonts = new ArrayList();
    protected ArrayList<Font> unsupportedFonts = new ArrayList();
    protected Font currentFont = null;

    public void addFont(Font font) {
        if (!this.isSupported(font)) {
            this.unsupportedFonts.add(font);
            return;
        }
        if (font.getBaseFont() != null) {
            this.fonts.add(font);
            return;
        }
        BaseFont bf = font.getCalculatedBaseFont(true);
        Font f2 = new Font(bf, font.getSize(), font.getCalculatedStyle(), font.getColor());
        this.fonts.add(f2);
    }

    public Phrase process(String text) {
        if (this.getSize() == 0) {
            throw new IndexOutOfBoundsException(MessageLocalization.getComposedMessage("no.font.is.defined", new Object[0]));
        }
        char[] cc = text.toCharArray();
        int len = cc.length;
        StringBuffer sb = new StringBuffer();
        Phrase ret = new Phrase();
        this.currentFont = null;
        for (int k = 0; k < len; ++k) {
            Chunk newChunk = this.processChar(cc, k, sb);
            if (newChunk == null) continue;
            ret.add(newChunk);
        }
        if (sb.length() > 0) {
            Chunk ck = new Chunk(sb.toString(), this.currentFont != null ? this.currentFont : this.getFont(0));
            ret.add(ck);
        }
        return ret;
    }

    protected Chunk processChar(char[] cc, int k, StringBuffer sb) {
        Chunk newChunk = null;
        char c = cc[k];
        if (c == '\n' || c == '\r') {
            sb.append(c);
        } else {
            Font font = null;
            if (Utilities.isSurrogatePair(cc, k)) {
                int u = Utilities.convertToUtf32(cc, k);
                for (int f = 0; f < this.getSize(); ++f) {
                    font = this.getFont(f);
                    if (!font.getBaseFont().charExists(u) && Character.getType(u) != 16) continue;
                    if (this.currentFont != font) {
                        if (sb.length() > 0 && this.currentFont != null) {
                            newChunk = new Chunk(sb.toString(), this.currentFont);
                            sb.setLength(0);
                        }
                        this.currentFont = font;
                    }
                    sb.append(c);
                    sb.append(cc[++k]);
                    break;
                }
            } else {
                for (int f = 0; f < this.getSize(); ++f) {
                    font = this.getFont(f);
                    if (!font.getBaseFont().charExists(c) && Character.getType(c) != 16) continue;
                    if (this.currentFont != font) {
                        if (sb.length() > 0 && this.currentFont != null) {
                            newChunk = new Chunk(sb.toString(), this.currentFont);
                            sb.setLength(0);
                        }
                        this.currentFont = font;
                    }
                    sb.append(c);
                    break;
                }
            }
        }
        return newChunk;
    }

    protected int getSize() {
        return this.fonts.size() + this.unsupportedFonts.size();
    }

    protected Font getFont(int i2) {
        return i2 < this.fonts.size() ? this.fonts.get(i2) : this.unsupportedFonts.get(i2);
    }

    private boolean isSupported(Font font) {
        BaseFont bf = font.getBaseFont();
        if (bf instanceof TrueTypeFont && "Cp1252".equals(bf.getEncoding()) && !((TrueTypeFont)bf).isWinAnsiSupported()) {
            LOGGER.warn(MessageFormat.format("cmap(1, 0) not found for TrueType Font {0}, it is required for WinAnsi encoding.", font));
            return false;
        }
        return true;
    }
}

