/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.error_messages.MessageLocalization;
import com.itextpdf.text.pdf.CMYKColor;
import com.itextpdf.text.pdf.ICachedColorSpace;
import com.itextpdf.text.pdf.LabColor;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfWriter;
import java.util.Arrays;

public class PdfLabColor
implements ICachedColorSpace {
    float[] whitePoint = new float[]{0.9505f, 1.0f, 1.089f};
    float[] blackPoint = null;
    float[] range = null;

    public PdfLabColor() {
    }

    public PdfLabColor(float[] whitePoint) {
        if (whitePoint == null || whitePoint.length != 3 || whitePoint[0] < 1.0E-6f || whitePoint[2] < 1.0E-6f || whitePoint[1] < 0.999999f || whitePoint[1] > 1.000001f) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("lab.cs.white.point", new Object[0]));
        }
        this.whitePoint = whitePoint;
    }

    public PdfLabColor(float[] whitePoint, float[] blackPoint) {
        this(whitePoint);
        this.blackPoint = blackPoint;
    }

    public PdfLabColor(float[] whitePoint, float[] blackPoint, float[] range) {
        this(whitePoint, blackPoint);
        this.range = range;
    }

    public PdfObject getPdfObject(PdfWriter writer) {
        PdfArray array = new PdfArray(PdfName.LAB);
        PdfDictionary dictionary = new PdfDictionary();
        if (this.whitePoint == null || this.whitePoint.length != 3 || this.whitePoint[0] < 1.0E-6f || this.whitePoint[2] < 1.0E-6f || this.whitePoint[1] < 0.999999f || this.whitePoint[1] > 1.000001f) {
            throw new RuntimeException(MessageLocalization.getComposedMessage("lab.cs.white.point", new Object[0]));
        }
        dictionary.put(PdfName.WHITEPOINT, new PdfArray(this.whitePoint));
        if (this.blackPoint != null) {
            if (this.blackPoint.length != 3 || this.blackPoint[0] < -1.0E-6f || this.blackPoint[1] < -1.0E-6f || this.blackPoint[2] < -1.0E-6f) {
                throw new RuntimeException(MessageLocalization.getComposedMessage("lab.cs.black.point", new Object[0]));
            }
            dictionary.put(PdfName.BLACKPOINT, new PdfArray(this.blackPoint));
        }
        if (this.range != null) {
            if (this.range.length != 4 || this.range[0] > this.range[1] || this.range[2] > this.range[3]) {
                throw new RuntimeException(MessageLocalization.getComposedMessage("lab.cs.range", new Object[0]));
            }
            dictionary.put(PdfName.RANGE, new PdfArray(this.range));
        }
        array.add(dictionary);
        return array;
    }

    public BaseColor lab2Rgb(float l, float a, float b) {
        double[] clinear = this.lab2RgbLinear(l, a, b);
        return new BaseColor((float)clinear[0], (float)clinear[1], (float)clinear[2]);
    }

    CMYKColor lab2Cmyk(float l, float a, float b) {
        double[] clinear = this.lab2RgbLinear(l, a, b);
        double r = clinear[0];
        double g = clinear[1];
        double bee = clinear[2];
        double computedC = 0.0;
        double computedM = 0.0;
        double computedY = 0.0;
        double computedK = 0.0;
        if (r == 0.0 && g == 0.0 && b == 0.0f) {
            computedK = 1.0;
        } else {
            computedC = 1.0 - r;
            computedM = 1.0 - g;
            computedY = 1.0 - bee;
            double minCMY = Math.min(computedC, Math.min(computedM, computedY));
            computedC = (computedC - minCMY) / (1.0 - minCMY);
            computedM = (computedM - minCMY) / (1.0 - minCMY);
            computedY = (computedY - minCMY) / (1.0 - minCMY);
            computedK = minCMY;
        }
        return new CMYKColor((float)computedC, (float)computedM, (float)computedY, (float)computedK);
    }

    protected double[] lab2RgbLinear(float l, float a, float b) {
        if (this.range != null && this.range.length == 4) {
            if (a < this.range[0]) {
                a = this.range[0];
            }
            if (a > this.range[1]) {
                a = this.range[1];
            }
            if (b < this.range[2]) {
                b = this.range[2];
            }
            if (b > this.range[3]) {
                b = this.range[3];
            }
        }
        double theta = 0.20689655172413793;
        double fy = (double)(l + 16.0f) / 116.0;
        double fx = fy + (double)a / 500.0;
        double fz = fy - (double)b / 200.0;
        double x = fx > theta ? (double)this.whitePoint[0] * (fx * fx * fx) : (fx - 0.13793103448275862) * 3.0 * (theta * theta) * (double)this.whitePoint[0];
        double y = fy > theta ? (double)this.whitePoint[1] * (fy * fy * fy) : (fy - 0.13793103448275862) * 3.0 * (theta * theta) * (double)this.whitePoint[1];
        double z = fz > theta ? (double)this.whitePoint[2] * (fz * fz * fz) : (fz - 0.13793103448275862) * 3.0 * (theta * theta) * (double)this.whitePoint[2];
        double[] clinear = new double[]{x * 3.241 - y * 1.5374 - z * 0.4986, -x * 0.9692 + y * 1.876 - z * 0.0416, x * 0.0556 - y * 0.204 + z * 1.057};
        for (int i2 = 0; i2 < 3; ++i2) {
            double d = clinear[i2] = clinear[i2] <= 0.0031308 ? 12.92 * clinear[i2] : 1.055 * Math.pow(clinear[i2], 0.4166666666666667) - 0.055;
            if (clinear[i2] < 0.0) {
                clinear[i2] = 0.0;
                continue;
            }
            if (!(clinear[i2] > 1.0)) continue;
            clinear[i2] = 1.0;
        }
        return clinear;
    }

    public LabColor rgb2lab(BaseColor baseColor) {
        double rLinear = (float)baseColor.getRed() / 255.0f;
        double gLinear = (float)baseColor.getGreen() / 255.0f;
        double bLinear = (float)baseColor.getBlue() / 255.0f;
        double r = rLinear > 0.04045 ? Math.pow((rLinear + 0.055) / 1.055, 2.2) : rLinear / 12.92;
        double g = gLinear > 0.04045 ? Math.pow((gLinear + 0.055) / 1.055, 2.2) : gLinear / 12.92;
        double b = bLinear > 0.04045 ? Math.pow((bLinear + 0.055) / 1.055, 2.2) : bLinear / 12.92;
        double x = r * 0.4124 + g * 0.3576 + b * 0.1805;
        double y = r * 0.2126 + g * 0.7152 + b * 0.0722;
        double z = r * 0.0193 + g * 0.1192 + b * 0.9505;
        float l = (float)Math.round((116.0 * PdfLabColor.fXyz(y / (double)this.whitePoint[1]) - 16.0) * 1000.0) / 1000.0f;
        float a = (float)Math.round(500.0 * (PdfLabColor.fXyz(x / (double)this.whitePoint[0]) - PdfLabColor.fXyz(y / (double)this.whitePoint[1])) * 1000.0) / 1000.0f;
        float bee = (float)Math.round(200.0 * (PdfLabColor.fXyz(y / (double)this.whitePoint[1]) - PdfLabColor.fXyz(z / (double)this.whitePoint[2])) * 1000.0) / 1000.0f;
        return new LabColor(this, l, a, bee);
    }

    private static double fXyz(double t) {
        return t > 0.008856 ? Math.pow(t, 0.3333333333333333) : 7.787 * t + 0.13793103448275862;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PdfLabColor)) {
            return false;
        }
        PdfLabColor that = (PdfLabColor)o;
        if (!Arrays.equals(this.blackPoint, that.blackPoint)) {
            return false;
        }
        if (!Arrays.equals(this.range, that.range)) {
            return false;
        }
        return Arrays.equals(this.whitePoint, that.whitePoint);
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.whitePoint);
        result = 31 * result + (this.blackPoint != null ? Arrays.hashCode(this.blackPoint) : 0);
        result = 31 * result + (this.range != null ? Arrays.hashCode(this.range) : 0);
        return result;
    }
}

