/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.fonts.otf;

import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.RandomAccessFileOrArray;
import com.itextpdf.text.pdf.fonts.otf.FontReadingException;
import com.itextpdf.text.pdf.fonts.otf.Language;
import com.itextpdf.text.pdf.fonts.otf.TableHeader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OpenTypeFontTableReader {
    protected static final Logger LOG = LoggerFactory.getLogger(OpenTypeFontTableReader.class);
    protected final RandomAccessFileOrArray rf;
    protected final int tableLocation;
    private List<String> supportedLanguages;

    public OpenTypeFontTableReader(RandomAccessFileOrArray rf, int tableLocation) throws IOException {
        this.rf = rf;
        this.tableLocation = tableLocation;
    }

    public Language getSupportedLanguage() throws FontReadingException {
        Language[] allLangs = Language.values();
        for (String supportedLang : this.supportedLanguages) {
            for (Language lang : allLangs) {
                if (!lang.isSupported(supportedLang)) continue;
                return lang;
            }
        }
        throw new FontReadingException("Unsupported languages " + this.supportedLanguages);
    }

    protected final void startReadingTable() throws FontReadingException {
        try {
            TableHeader header2 = this.readHeader();
            this.readScriptListTable(this.tableLocation + header2.scriptListOffset);
            this.readFeatureListTable(this.tableLocation + header2.featureListOffset);
            this.readLookupListTable(this.tableLocation + header2.lookupListOffset);
        }
        catch (IOException e) {
            throw new FontReadingException("Error reading font file", e);
        }
    }

    protected abstract void readSubTable(int var1, int var2) throws IOException;

    private void readLookupListTable(int lookupListTableLocation) throws IOException {
        int lookupTableOffset;
        int i2;
        this.rf.seek(lookupListTableLocation);
        int lookupCount = this.rf.readShort();
        ArrayList<Integer> lookupTableOffsets = new ArrayList<Integer>();
        for (i2 = 0; i2 < lookupCount; ++i2) {
            lookupTableOffset = this.rf.readShort();
            lookupTableOffsets.add(lookupTableOffset);
        }
        for (i2 = 0; i2 < lookupCount; ++i2) {
            lookupTableOffset = (Integer)lookupTableOffsets.get(i2);
            this.readLookupTable(lookupListTableLocation + lookupTableOffset);
        }
    }

    private void readLookupTable(int lookupTableLocation) throws IOException {
        int subTableOffset;
        this.rf.seek(lookupTableLocation);
        short lookupType = this.rf.readShort();
        this.rf.skipBytes(2);
        int subTableCount = this.rf.readShort();
        ArrayList<Integer> subTableOffsets = new ArrayList<Integer>();
        for (int i2 = 0; i2 < subTableCount; ++i2) {
            subTableOffset = this.rf.readShort();
            subTableOffsets.add(subTableOffset);
        }
        Iterator i$ = subTableOffsets.iterator();
        while (i$.hasNext()) {
            subTableOffset = (Integer)i$.next();
            this.readSubTable(lookupType, lookupTableLocation + subTableOffset);
        }
    }

    protected final List<Integer> readCoverageFormat(int coverageLocation) throws IOException {
        ArrayList<Integer> glyphIds;
        this.rf.seek(coverageLocation);
        short coverageFormat = this.rf.readShort();
        if (coverageFormat == 1) {
            int glyphCount = this.rf.readShort();
            glyphIds = new ArrayList<Integer>(glyphCount);
            for (int i2 = 0; i2 < glyphCount; ++i2) {
                short coverageGlyphId = this.rf.readShort();
                glyphIds.add(Integer.valueOf(coverageGlyphId));
            }
        } else if (coverageFormat == 2) {
            int rangeCount = this.rf.readShort();
            glyphIds = new ArrayList();
            for (int i3 = 0; i3 < rangeCount; ++i3) {
                this.readRangeRecord(glyphIds);
            }
        } else {
            throw new UnsupportedOperationException("Invalid coverage format: " + coverageFormat);
        }
        return Collections.unmodifiableList(glyphIds);
    }

    private void readRangeRecord(List<Integer> glyphIds) throws IOException {
        int startGlyphId = this.rf.readShort();
        short endGlyphId = this.rf.readShort();
        short startCoverageIndex = this.rf.readShort();
        for (int glyphId = startGlyphId; glyphId <= endGlyphId; ++glyphId) {
            glyphIds.add(glyphId);
        }
    }

    private void readScriptListTable(int scriptListTableLocationOffset) throws IOException {
        this.rf.seek(scriptListTableLocationOffset);
        int scriptCount = this.rf.readShort();
        HashMap<String, Integer> scriptRecords = new HashMap<String, Integer>(scriptCount);
        for (int i2 = 0; i2 < scriptCount; ++i2) {
            this.readScriptRecord(scriptListTableLocationOffset, scriptRecords);
        }
        ArrayList<String> supportedLanguages = new ArrayList<String>(scriptCount);
        for (String scriptName : scriptRecords.keySet()) {
            this.readScriptTable((Integer)scriptRecords.get(scriptName));
            supportedLanguages.add(scriptName);
        }
        this.supportedLanguages = Collections.unmodifiableList(supportedLanguages);
    }

    private void readScriptRecord(int scriptListTableLocationOffset, Map<String, Integer> scriptRecords) throws IOException {
        String scriptTag = this.rf.readString(4, "utf-8");
        short scriptOffset = this.rf.readShort();
        scriptRecords.put(scriptTag, scriptListTableLocationOffset + scriptOffset);
    }

    private void readScriptTable(int scriptTableLocationOffset) throws IOException {
        this.rf.seek(scriptTableLocationOffset);
        short defaultLangSys = this.rf.readShort();
        int langSysCount = this.rf.readShort();
        if (langSysCount > 0) {
            LinkedHashMap<String, Integer> langSysRecords = new LinkedHashMap<String, Integer>(langSysCount);
            for (int i2 = 0; i2 < langSysCount; ++i2) {
                this.readLangSysRecord(langSysRecords);
            }
            for (String langSysTag : langSysRecords.keySet()) {
                this.readLangSysTable(scriptTableLocationOffset + (Integer)langSysRecords.get(langSysTag));
            }
        }
        this.readLangSysTable(scriptTableLocationOffset + defaultLangSys);
    }

    private void readLangSysRecord(Map<String, Integer> langSysRecords) throws IOException {
        String langSysTag = this.rf.readString(4, "utf-8");
        short langSys = this.rf.readShort();
        langSysRecords.put(langSysTag, Integer.valueOf(langSys));
    }

    private void readLangSysTable(int langSysTableLocationOffset) throws IOException {
        this.rf.seek(langSysTableLocationOffset);
        short lookupOrderOffset = this.rf.readShort();
        LOG.debug("lookupOrderOffset=" + lookupOrderOffset);
        short reqFeatureIndex = this.rf.readShort();
        LOG.debug("reqFeatureIndex=" + reqFeatureIndex);
        int featureCount = this.rf.readShort();
        ArrayList<Short> featureListIndices = new ArrayList<Short>(featureCount);
        for (int i2 = 0; i2 < featureCount; ++i2) {
            featureListIndices.add(this.rf.readShort());
        }
        LOG.debug("featureListIndices=" + featureListIndices);
    }

    private void readFeatureListTable(int featureListTableLocationOffset) throws IOException {
        this.rf.seek(featureListTableLocationOffset);
        int featureCount = this.rf.readShort();
        LOG.debug("featureCount=" + featureCount);
        LinkedHashMap<String, Short> featureRecords = new LinkedHashMap<String, Short>(featureCount);
        for (int i2 = 0; i2 < featureCount; ++i2) {
            featureRecords.put(this.rf.readString(4, "utf-8"), this.rf.readShort());
        }
        for (String featureName : featureRecords.keySet()) {
            LOG.debug("*************featureName=" + featureName);
            this.readFeatureTable(featureListTableLocationOffset + (Short)featureRecords.get(featureName));
        }
    }

    private void readFeatureTable(int featureTableLocationOffset) throws IOException {
        this.rf.seek(featureTableLocationOffset);
        short featureParamsOffset = this.rf.readShort();
        LOG.debug("featureParamsOffset=" + featureParamsOffset);
        int lookupCount = this.rf.readShort();
        LOG.debug("lookupCount=" + lookupCount);
        ArrayList<Short> lookupListIndices = new ArrayList<Short>(lookupCount);
        for (int i2 = 0; i2 < lookupCount; ++i2) {
            lookupListIndices.add(this.rf.readShort());
        }
    }

    private TableHeader readHeader() throws IOException {
        this.rf.seek(this.tableLocation);
        int version = this.rf.readInt();
        int scriptListOffset = this.rf.readUnsignedShort();
        int featureListOffset = this.rf.readUnsignedShort();
        int lookupListOffset = this.rf.readUnsignedShort();
        TableHeader header2 = new TableHeader(version, scriptListOffset, featureListOffset, lookupListOffset);
        return header2;
    }
}

