/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser.clipper;

import com.itextpdf.text.pdf.parser.clipper.Clipper;
import com.itextpdf.text.pdf.parser.clipper.DefaultClipper;
import com.itextpdf.text.pdf.parser.clipper.LongRect;
import com.itextpdf.text.pdf.parser.clipper.Path;
import com.itextpdf.text.pdf.parser.clipper.Paths;
import com.itextpdf.text.pdf.parser.clipper.Point;
import com.itextpdf.text.pdf.parser.clipper.PolyNode;
import com.itextpdf.text.pdf.parser.clipper.PolyTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClipperOffset {
    private Paths destPolys;
    private Path srcPoly;
    private Path destPoly;
    private final List<Point.DoublePoint> normals;
    private double delta;
    private double inA;
    private double sin;
    private double cos;
    private double miterLim;
    private double stepsPerRad;
    private Point.LongPoint lowest;
    private final PolyNode polyNodes;
    private final double arcTolerance;
    private final double miterLimit;
    private static final double TWO_PI = Math.PI * 2;
    private static final double DEFAULT_ARC_TOLERANCE = 0.25;
    private static final double TOLERANCE = 1.0E-20;

    private static boolean nearZero(double val) {
        return val > -1.0E-20 && val < 1.0E-20;
    }

    public ClipperOffset() {
        this(2.0, 0.25);
    }

    public ClipperOffset(double miterLimit) {
        this(miterLimit, 0.25);
    }

    public ClipperOffset(double miterLimit, double arcTolerance) {
        this.miterLimit = miterLimit;
        this.arcTolerance = arcTolerance;
        this.lowest = new Point.LongPoint();
        this.lowest.setX(-1L);
        this.polyNodes = new PolyNode();
        this.normals = new ArrayList<Point.DoublePoint>();
    }

    public void addPath(Path path, Clipper.JoinType joinType, Clipper.EndType endType) {
        int highI = path.size() - 1;
        if (highI < 0) {
            return;
        }
        PolyNode newNode = new PolyNode();
        newNode.setJoinType(joinType);
        newNode.setEndType(endType);
        if (endType == Clipper.EndType.CLOSED_LINE || endType == Clipper.EndType.CLOSED_POLYGON) {
            while (highI > 0 && path.get(0) == path.get(highI)) {
                --highI;
            }
        }
        newNode.getPolygon().add(path.get(0));
        int j = 0;
        int k = 0;
        for (int i2 = 1; i2 <= highI; ++i2) {
            if (newNode.getPolygon().get(j) == path.get(i2)) continue;
            ++j;
            newNode.getPolygon().add(path.get(i2));
            if (((Point.LongPoint)path.get(i2)).getY() <= ((Point.LongPoint)newNode.getPolygon().get(k)).getY() && (((Point.LongPoint)path.get(i2)).getY() != ((Point.LongPoint)newNode.getPolygon().get(k)).getY() || ((Point.LongPoint)path.get(i2)).getX() >= ((Point.LongPoint)newNode.getPolygon().get(k)).getX())) continue;
            k = j;
        }
        if (endType == Clipper.EndType.CLOSED_POLYGON && j < 2) {
            return;
        }
        this.polyNodes.addChild(newNode);
        if (endType != Clipper.EndType.CLOSED_POLYGON) {
            return;
        }
        if (this.lowest.getX() < 0L) {
            this.lowest = new Point.LongPoint(this.polyNodes.getChildCount() - 1, k);
        } else {
            Point.LongPoint ip = (Point.LongPoint)this.polyNodes.getChilds().get((int)this.lowest.getX()).getPolygon().get((int)this.lowest.getY());
            if (((Point.LongPoint)newNode.getPolygon().get(k)).getY() > ip.getY() || ((Point.LongPoint)newNode.getPolygon().get(k)).getY() == ip.getY() && ((Point.LongPoint)newNode.getPolygon().get(k)).getX() < ip.getX()) {
                this.lowest = new Point.LongPoint(this.polyNodes.getChildCount() - 1, k);
            }
        }
    }

    public void addPaths(Paths paths, Clipper.JoinType joinType, Clipper.EndType endType) {
        for (Path p2 : paths) {
            this.addPath(p2, joinType, endType);
        }
    }

    public void clear() {
        this.polyNodes.getChilds().clear();
        this.lowest.setX(-1L);
    }

    private void doMiter(int j, int k, double r) {
        double q = this.delta / r;
        this.destPoly.add(new Point.LongPoint(Math.round((double)((Point.LongPoint)this.srcPoly.get(j)).getX() + (this.normals.get(k).getX() + this.normals.get(j).getX()) * q), Math.round((double)((Point.LongPoint)this.srcPoly.get(j)).getY() + (this.normals.get(k).getY() + this.normals.get(j).getY()) * q)));
    }

    private void doOffset(double delta) {
        this.destPolys = new Paths();
        this.delta = delta;
        if (ClipperOffset.nearZero(delta)) {
            for (int i2 = 0; i2 < this.polyNodes.getChildCount(); ++i2) {
                PolyNode node = this.polyNodes.getChilds().get(i2);
                if (node.getEndType() != Clipper.EndType.CLOSED_POLYGON) continue;
                this.destPolys.add(node.getPolygon());
            }
            return;
        }
        this.miterLim = this.miterLimit > 2.0 ? 2.0 / (this.miterLimit * this.miterLimit) : 0.5;
        double y = this.arcTolerance <= 0.0 ? 0.25 : (this.arcTolerance > Math.abs(delta) * 0.25 ? Math.abs(delta) * 0.25 : this.arcTolerance);
        double steps = Math.PI / Math.acos(1.0 - y / Math.abs(delta));
        this.sin = Math.sin(Math.PI * 2 / steps);
        this.cos = Math.cos(Math.PI * 2 / steps);
        this.stepsPerRad = steps / (Math.PI * 2);
        if (delta < 0.0) {
            this.sin = -this.sin;
        }
        for (int i3 = 0; i3 < this.polyNodes.getChildCount(); ++i3) {
            int j;
            int j2;
            PolyNode node = this.polyNodes.getChilds().get(i3);
            this.srcPoly = node.getPolygon();
            int len = this.srcPoly.size();
            if (len == 0 || delta <= 0.0 && (len < 3 || node.getEndType() != Clipper.EndType.CLOSED_POLYGON)) continue;
            this.destPoly = new Path();
            if (len == 1) {
                int j3;
                double Y;
                double X;
                if (node.getJoinType() == Clipper.JoinType.ROUND) {
                    X = 1.0;
                    Y = 0.0;
                    j3 = 1;
                    while ((double)j3 <= steps) {
                        this.destPoly.add(new Point.LongPoint(Math.round((double)((Point.LongPoint)this.srcPoly.get(0)).getX() + X * delta), Math.round((double)((Point.LongPoint)this.srcPoly.get(0)).getY() + Y * delta)));
                        double X2 = X;
                        X = X * this.cos - this.sin * Y;
                        Y = X2 * this.sin + Y * this.cos;
                        ++j3;
                    }
                } else {
                    X = -1.0;
                    Y = -1.0;
                    for (j3 = 0; j3 < 4; ++j3) {
                        this.destPoly.add(new Point.LongPoint(Math.round((double)((Point.LongPoint)this.srcPoly.get(0)).getX() + X * delta), Math.round((double)((Point.LongPoint)this.srcPoly.get(0)).getY() + Y * delta)));
                        if (X < 0.0) {
                            X = 1.0;
                            continue;
                        }
                        if (Y < 0.0) {
                            Y = 1.0;
                            continue;
                        }
                        X = -1.0;
                    }
                }
                this.destPolys.add(this.destPoly);
                continue;
            }
            this.normals.clear();
            for (int j4 = 0; j4 < len - 1; ++j4) {
                this.normals.add(Point.getUnitNormal((Point.LongPoint)this.srcPoly.get(j4), (Point.LongPoint)this.srcPoly.get(j4 + 1)));
            }
            if (node.getEndType() == Clipper.EndType.CLOSED_LINE || node.getEndType() == Clipper.EndType.CLOSED_POLYGON) {
                this.normals.add(Point.getUnitNormal((Point.LongPoint)this.srcPoly.get(len - 1), (Point.LongPoint)this.srcPoly.get(0)));
            } else {
                this.normals.add(new Point.DoublePoint(this.normals.get(len - 2)));
            }
            if (node.getEndType() == Clipper.EndType.CLOSED_POLYGON) {
                int[] k = new int[]{len - 1};
                for (j2 = 0; j2 < len; ++j2) {
                    this.offsetPoint(j2, k, node.getJoinType());
                }
                this.destPolys.add(this.destPoly);
                continue;
            }
            if (node.getEndType() == Clipper.EndType.CLOSED_LINE) {
                int j5;
                int[] k = new int[]{len - 1};
                for (j2 = 0; j2 < len; ++j2) {
                    this.offsetPoint(j2, k, node.getJoinType());
                }
                this.destPolys.add(this.destPoly);
                this.destPoly = new Path();
                Point.DoublePoint n = this.normals.get(len - 1);
                for (j5 = len - 1; j5 > 0; --j5) {
                    this.normals.set(j5, new Point.DoublePoint(-this.normals.get(j5 - 1).getX(), -this.normals.get(j5 - 1).getY()));
                }
                this.normals.set(0, new Point.DoublePoint(-n.getX(), -n.getY(), 0.0));
                k[0] = 0;
                for (j5 = len - 1; j5 >= 0; --j5) {
                    this.offsetPoint(j5, k, node.getJoinType());
                }
                this.destPolys.add(this.destPoly);
                continue;
            }
            int[] k = new int[1];
            for (j2 = 1; j2 < len - 1; ++j2) {
                this.offsetPoint(j2, k, node.getJoinType());
            }
            if (node.getEndType() == Clipper.EndType.OPEN_BUTT) {
                j = len - 1;
                Point.LongPoint pt1 = new Point.LongPoint(Math.round((double)((Point.LongPoint)this.srcPoly.get(j)).getX() + this.normals.get(j).getX() * delta), Math.round((double)((Point.LongPoint)this.srcPoly.get(j)).getY() + this.normals.get(j).getY() * delta), 0L);
                this.destPoly.add(pt1);
                pt1 = new Point.LongPoint(Math.round((double)((Point.LongPoint)this.srcPoly.get(j)).getX() - this.normals.get(j).getX() * delta), Math.round((double)((Point.LongPoint)this.srcPoly.get(j)).getY() - this.normals.get(j).getY() * delta), 0L);
                this.destPoly.add(pt1);
            } else {
                j = len - 1;
                k[0] = len - 2;
                this.inA = 0.0;
                this.normals.set(j, new Point.DoublePoint(-this.normals.get(j).getX(), -this.normals.get(j).getY()));
                if (node.getEndType() == Clipper.EndType.OPEN_SQUARE) {
                    this.doSquare(j, k[0], true);
                } else {
                    this.doRound(j, k[0]);
                }
            }
            for (j = len - 1; j > 0; --j) {
                this.normals.set(j, new Point.DoublePoint(-this.normals.get(j - 1).getX(), -this.normals.get(j - 1).getY()));
            }
            this.normals.set(0, new Point.DoublePoint(-this.normals.get(1).getX(), -this.normals.get(1).getY()));
            k[0] = len - 1;
            for (j = k[0] - 1; j > 0; --j) {
                this.offsetPoint(j, k, node.getJoinType());
            }
            if (node.getEndType() == Clipper.EndType.OPEN_BUTT) {
                Point.LongPoint pt1 = new Point.LongPoint(Math.round((double)((Point.LongPoint)this.srcPoly.get(0)).getX() - this.normals.get(0).getX() * delta), Math.round((double)((Point.LongPoint)this.srcPoly.get(0)).getY() - this.normals.get(0).getY() * delta));
                this.destPoly.add(pt1);
                pt1 = new Point.LongPoint(Math.round((double)((Point.LongPoint)this.srcPoly.get(0)).getX() + this.normals.get(0).getX() * delta), Math.round((double)((Point.LongPoint)this.srcPoly.get(0)).getY() + this.normals.get(0).getY() * delta));
                this.destPoly.add(pt1);
            } else {
                k[0] = 1;
                this.inA = 0.0;
                if (node.getEndType() == Clipper.EndType.OPEN_SQUARE) {
                    this.doSquare(0, 1, true);
                } else {
                    this.doRound(0, 1);
                }
            }
            this.destPolys.add(this.destPoly);
        }
    }

    private void doRound(int j, int k) {
        double a = Math.atan2(this.inA, this.normals.get(k).getX() * this.normals.get(j).getX() + this.normals.get(k).getY() * this.normals.get(j).getY());
        int steps = Math.max((int)Math.round(this.stepsPerRad * Math.abs(a)), 1);
        double X = this.normals.get(k).getX();
        double Y = this.normals.get(k).getY();
        for (int i2 = 0; i2 < steps; ++i2) {
            this.destPoly.add(new Point.LongPoint(Math.round((double)((Point.LongPoint)this.srcPoly.get(j)).getX() + X * this.delta), Math.round((double)((Point.LongPoint)this.srcPoly.get(j)).getY() + Y * this.delta)));
            double X2 = X;
            X = X * this.cos - this.sin * Y;
            Y = X2 * this.sin + Y * this.cos;
        }
        this.destPoly.add(new Point.LongPoint(Math.round((double)((Point.LongPoint)this.srcPoly.get(j)).getX() + this.normals.get(j).getX() * this.delta), Math.round((double)((Point.LongPoint)this.srcPoly.get(j)).getY() + this.normals.get(j).getY() * this.delta)));
    }

    private void doSquare(int j, int k, boolean addExtra) {
        double nkx = this.normals.get(k).getX();
        double nky = this.normals.get(k).getY();
        double njx = this.normals.get(j).getX();
        double njy = this.normals.get(j).getY();
        double sjx = ((Point.LongPoint)this.srcPoly.get(j)).getX();
        double sjy = ((Point.LongPoint)this.srcPoly.get(j)).getY();
        double dx = Math.tan(Math.atan2(this.inA, nkx * njx + nky * njy) / 4.0);
        this.destPoly.add(new Point.LongPoint(Math.round(sjx + this.delta * (nkx - (addExtra ? nky * dx : 0.0))), Math.round(sjy + this.delta * (nky + (addExtra ? nkx * dx : 0.0))), 0L));
        this.destPoly.add(new Point.LongPoint(Math.round(sjx + this.delta * (njx + (addExtra ? njy * dx : 0.0))), Math.round(sjy + this.delta * (njy - (addExtra ? njx * dx : 0.0))), 0L));
    }

    public void execute(Paths solution, double delta) {
        solution.clear();
        this.fixOrientations();
        this.doOffset(delta);
        DefaultClipper clpr = new DefaultClipper(1);
        clpr.addPaths(this.destPolys, Clipper.PolyType.SUBJECT, true);
        if (delta > 0.0) {
            clpr.execute(Clipper.ClipType.UNION, solution, Clipper.PolyFillType.POSITIVE, Clipper.PolyFillType.POSITIVE);
        } else {
            LongRect r = this.destPolys.getBounds();
            Path outer = new Path(4);
            outer.add(new Point.LongPoint(r.left - 10L, r.bottom + 10L, 0L));
            outer.add(new Point.LongPoint(r.right + 10L, r.bottom + 10L, 0L));
            outer.add(new Point.LongPoint(r.right + 10L, r.top - 10L, 0L));
            outer.add(new Point.LongPoint(r.left - 10L, r.top - 10L, 0L));
            clpr.addPath(outer, Clipper.PolyType.SUBJECT, true);
            clpr.execute(Clipper.ClipType.UNION, solution, Clipper.PolyFillType.NEGATIVE, Clipper.PolyFillType.NEGATIVE);
            if (solution.size() > 0) {
                solution.remove(0);
            }
        }
    }

    public void execute(PolyTree solution, double delta) {
        solution.Clear();
        this.fixOrientations();
        this.doOffset(delta);
        DefaultClipper clpr = new DefaultClipper(1);
        clpr.addPaths(this.destPolys, Clipper.PolyType.SUBJECT, true);
        if (delta > 0.0) {
            clpr.execute(Clipper.ClipType.UNION, solution, Clipper.PolyFillType.POSITIVE, Clipper.PolyFillType.POSITIVE);
        } else {
            LongRect r = this.destPolys.getBounds();
            Path outer = new Path(4);
            outer.add(new Point.LongPoint(r.left - 10L, r.bottom + 10L, 0L));
            outer.add(new Point.LongPoint(r.right + 10L, r.bottom + 10L, 0L));
            outer.add(new Point.LongPoint(r.right + 10L, r.top - 10L, 0L));
            outer.add(new Point.LongPoint(r.left - 10L, r.top - 10L, 0L));
            clpr.addPath(outer, Clipper.PolyType.SUBJECT, true);
            clpr.execute(Clipper.ClipType.UNION, solution, Clipper.PolyFillType.NEGATIVE, Clipper.PolyFillType.NEGATIVE);
            if (solution.getChildCount() == 1 && solution.getChilds().get(0).getChildCount() > 0) {
                PolyNode outerNode = solution.getChilds().get(0);
                solution.getChilds().set(0, outerNode.getChilds().get(0));
                solution.getChilds().get(0).setParent(solution);
                for (int i2 = 1; i2 < outerNode.getChildCount(); ++i2) {
                    solution.addChild(outerNode.getChilds().get(i2));
                }
            } else {
                solution.Clear();
            }
        }
    }

    private void fixOrientations() {
        if (this.lowest.getX() >= 0L && !this.polyNodes.childs.get((int)this.lowest.getX()).getPolygon().orientation()) {
            for (int i2 = 0; i2 < this.polyNodes.getChildCount(); ++i2) {
                PolyNode node = this.polyNodes.childs.get(i2);
                if (node.getEndType() != Clipper.EndType.CLOSED_POLYGON && (node.getEndType() != Clipper.EndType.CLOSED_LINE || !node.getPolygon().orientation())) continue;
                Collections.reverse(node.getPolygon());
            }
        } else {
            for (int i3 = 0; i3 < this.polyNodes.getChildCount(); ++i3) {
                PolyNode node = this.polyNodes.childs.get(i3);
                if (node.getEndType() != Clipper.EndType.CLOSED_LINE || node.getPolygon().orientation()) continue;
                Collections.reverse(node.getPolygon());
            }
        }
    }

    private void offsetPoint(int j, int[] kV, Clipper.JoinType jointype) {
        int k = kV[0];
        double nkx = this.normals.get(k).getX();
        double nky = this.normals.get(k).getY();
        double njy = this.normals.get(j).getY();
        double njx = this.normals.get(j).getX();
        long sjx = ((Point.LongPoint)this.srcPoly.get(j)).getX();
        long sjy = ((Point.LongPoint)this.srcPoly.get(j)).getY();
        this.inA = nkx * njy - njx * nky;
        if (Math.abs(this.inA * this.delta) < 1.0) {
            double cosA = nkx * njx + njy * nky;
            if (cosA > 0.0) {
                this.destPoly.add(new Point.LongPoint(Math.round((double)sjx + nkx * this.delta), Math.round((double)sjy + nky * this.delta), 0L));
                return;
            }
        } else if (this.inA > 1.0) {
            this.inA = 1.0;
        } else if (this.inA < -1.0) {
            this.inA = -1.0;
        }
        if (this.inA * this.delta < 0.0) {
            this.destPoly.add(new Point.LongPoint(Math.round((double)sjx + nkx * this.delta), Math.round((double)sjy + nky * this.delta)));
            this.destPoly.add(this.srcPoly.get(j));
            this.destPoly.add(new Point.LongPoint(Math.round((double)sjx + njx * this.delta), Math.round((double)sjy + njy * this.delta)));
        } else {
            switch (jointype) {
                case MITER: {
                    double r = 1.0 + njx * nkx + njy * nky;
                    if (r >= this.miterLim) {
                        this.doMiter(j, k, r);
                        break;
                    }
                    this.doSquare(j, k, false);
                    break;
                }
                case BEVEL: {
                    this.doSquare(j, k, false);
                    break;
                }
                case ROUND: {
                    this.doRound(j, k);
                }
            }
        }
        kV[0] = j;
    }
}

