/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf.parser.clipper;

import java.math.BigInteger;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Point<T extends Number> {
    private static final NumberComparator NUMBER_COMPARATOR = new NumberComparator();
    protected T x;
    protected T y;
    protected T z;

    static boolean arePointsClose(Point<? extends Number> pt1, Point<? extends Number> pt2, double distSqrd) {
        double dy;
        double dx = ((Number)pt1.x).doubleValue() - ((Number)pt2.x).doubleValue();
        return dx * dx + (dy = ((Number)pt1.y).doubleValue() - ((Number)pt2.y).doubleValue()) * dy <= distSqrd;
    }

    static double distanceFromLineSqrd(Point<? extends Number> pt, Point<? extends Number> ln1, Point<? extends Number> ln2) {
        double A2 = ((Number)ln1.y).doubleValue() - ((Number)ln2.y).doubleValue();
        double B = ((Number)ln2.x).doubleValue() - ((Number)ln1.x).doubleValue();
        double C = A2 * ((Number)ln1.x).doubleValue() + B * ((Number)ln1.y).doubleValue();
        C = A2 * ((Number)pt.x).doubleValue() + B * ((Number)pt.y).doubleValue() - C;
        return C * C / (A2 * A2 + B * B);
    }

    static DoublePoint getUnitNormal(LongPoint pt1, LongPoint pt2) {
        double dx = (Long)pt2.x - (Long)pt1.x;
        double dy = (Long)pt2.y - (Long)pt1.y;
        if (dx == 0.0 && dy == 0.0) {
            return new DoublePoint();
        }
        double f = 1.0 / Math.sqrt(dx * dx + dy * dy);
        return new DoublePoint(dy *= f, -(dx *= f));
    }

    protected static boolean isPt2BetweenPt1AndPt3(LongPoint pt1, LongPoint pt2, LongPoint pt3) {
        if (pt1.equals(pt3) || pt1.equals(pt2) || pt3.equals(pt2)) {
            return false;
        }
        if (pt1.x != pt3.x) {
            return (Long)pt2.x > (Long)pt1.x == (Long)pt2.x < (Long)pt3.x;
        }
        return (Long)pt2.y > (Long)pt1.y == (Long)pt2.y < (Long)pt3.y;
    }

    protected static boolean slopesEqual(LongPoint pt1, LongPoint pt2, LongPoint pt3, boolean useFullRange) {
        if (useFullRange) {
            return BigInteger.valueOf(pt1.getY() - pt2.getY()).multiply(BigInteger.valueOf(pt2.getX() - pt3.getX())).equals(BigInteger.valueOf(pt1.getX() - pt2.getX()).multiply(BigInteger.valueOf(pt2.getY() - pt3.getY())));
        }
        return (pt1.getY() - pt2.getY()) * (pt2.getX() - pt3.getX()) - (pt1.getX() - pt2.getX()) * (pt2.getY() - pt3.getY()) == 0L;
    }

    protected static boolean slopesEqual(LongPoint pt1, LongPoint pt2, LongPoint pt3, LongPoint pt4, boolean useFullRange) {
        if (useFullRange) {
            return BigInteger.valueOf(pt1.getY() - pt2.getY()).multiply(BigInteger.valueOf(pt3.getX() - pt4.getX())).equals(BigInteger.valueOf(pt1.getX() - pt2.getX()).multiply(BigInteger.valueOf(pt3.getY() - pt4.getY())));
        }
        return (pt1.getY() - pt2.getY()) * (pt3.getX() - pt4.getX()) - (pt1.getX() - pt2.getX()) * (pt3.getY() - pt4.getY()) == 0L;
    }

    static boolean slopesNearCollinear(LongPoint pt1, LongPoint pt2, LongPoint pt3, double distSqrd) {
        if (Math.abs((Long)pt1.x - (Long)pt2.x) > Math.abs((Long)pt1.y - (Long)pt2.y)) {
            if ((Long)pt1.x > (Long)pt2.x == (Long)pt1.x < (Long)pt3.x) {
                return Point.distanceFromLineSqrd(pt1, pt2, pt3) < distSqrd;
            }
            if ((Long)pt2.x > (Long)pt1.x == (Long)pt2.x < (Long)pt3.x) {
                return Point.distanceFromLineSqrd(pt2, pt1, pt3) < distSqrd;
            }
            return Point.distanceFromLineSqrd(pt3, pt1, pt2) < distSqrd;
        }
        if ((Long)pt1.y > (Long)pt2.y == (Long)pt1.y < (Long)pt3.y) {
            return Point.distanceFromLineSqrd(pt1, pt2, pt3) < distSqrd;
        }
        if ((Long)pt2.y > (Long)pt1.y == (Long)pt2.y < (Long)pt3.y) {
            return Point.distanceFromLineSqrd(pt2, pt1, pt3) < distSqrd;
        }
        return Point.distanceFromLineSqrd(pt3, pt1, pt2) < distSqrd;
    }

    protected Point(Point<T> pt) {
        this(pt.x, pt.y, pt.z);
    }

    protected Point(T x, T y, T z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Point) {
            Point a = (Point)obj;
            return NUMBER_COMPARATOR.compare(this.x, a.x) == 0 && NUMBER_COMPARATOR.compare(this.y, a.y) == 0;
        }
        return false;
    }

    public void set(Point<T> other) {
        this.x = other.x;
        this.y = other.y;
        this.z = other.z;
    }

    public void setX(T x) {
        this.x = x;
    }

    public void setY(T y) {
        this.y = y;
    }

    public void setZ(T z) {
        this.z = z;
    }

    public String toString() {
        return "Point [x=" + this.x + ", y=" + this.y + ", z=" + this.z + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NumberComparator<T extends Number>
    implements Comparator<T> {
        private NumberComparator() {
        }

        @Override
        public int compare(T a, T b) throws ClassCastException {
            return ((Comparable)a).compareTo(b);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongPoint
    extends Point<Long> {
        public static double getDeltaX(LongPoint pt1, LongPoint pt2) {
            if (pt1.getY() == pt2.getY()) {
                return -3.4E38;
            }
            return (double)(pt2.getX() - pt1.getX()) / (double)(pt2.getY() - pt1.getY());
        }

        public LongPoint() {
            this(0L, 0L);
        }

        public LongPoint(long x, long y) {
            this(x, y, 0L);
        }

        public LongPoint(double x, double y) {
            this((long)x, (long)y);
        }

        public LongPoint(long x, long y, long z) {
            super(x, y, z);
        }

        public LongPoint(LongPoint other) {
            super(other);
        }

        public long getX() {
            return (Long)this.x;
        }

        public long getY() {
            return (Long)this.y;
        }

        public long getZ() {
            return (Long)this.z;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoublePoint
    extends Point<Double> {
        public DoublePoint() {
            this(0.0, 0.0);
        }

        public DoublePoint(double x, double y) {
            this(x, y, 0.0);
        }

        public DoublePoint(double x, double y, double z) {
            super(x, y, z);
        }

        public DoublePoint(DoublePoint other) {
            super(other);
        }

        public double getX() {
            return (Double)this.x;
        }

        public double getY() {
            return (Double)this.y;
        }

        public double getZ() {
            return (Double)this.z;
        }
    }
}

