/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactoryImp;
import com.itextpdf.text.pdf.BaseFont;
import java.nio.charset.UnsupportedCharsetException;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLWorkerFontProvider
extends FontFactoryImp {
    public static final String DONTLOOKFORFONTS = "\ufffc";
    protected HashMap<String, String> fontSubstitutionMap = new HashMap();
    protected boolean useUnicode = true;

    public XMLWorkerFontProvider() {
        this(null, null);
    }

    public XMLWorkerFontProvider(String fontsPath) {
        this(fontsPath, null);
    }

    public XMLWorkerFontProvider(String fontsPath, HashMap<String, String> fontSubstitutionMap) {
        if (fontsPath == null || fontsPath.length() == 0) {
        } else if (!fontsPath.equals(DONTLOOKFORFONTS)) {
            super.registerDirectory(fontsPath, true);
        }
        if (fontSubstitutionMap != null) {
            this.fontSubstitutionMap = fontSubstitutionMap;
        }
    }

    public void addFontSubstitute(String font, String substitute) {
        this.fontSubstitutionMap.put(font, substitute);
    }

    public void setUseUnicode(boolean useUnicode) {
        this.useUnicode = useUnicode;
    }

    @Override
    public Font getFont(String fontname, String encoding, boolean embedded, float size, int style, BaseColor color) {
        Font font = this.getFont(fontname, encoding, size, style);
        font.setColor(color);
        return font;
    }

    @Override
    public Font getFont(String fontname, String encoding, float size, int style) {
        if (fontname == null) {
            return new Font(Font.FontFamily.UNDEFINED, size, style);
        }
        Font unicodeFont = this.getUnicodeFont(fontname, encoding, size, style);
        return unicodeFont;
    }

    private Font getUnicodeFont(String fontName, String encoding, float size, int style) {
        Font font;
        block5: {
            font = null;
            try {
                String substFontName;
                BaseFont baseFont = null;
                font = super.getFont(fontName, this.useUnicode ? "Identity-H" : encoding, true, size, style, null);
                if (font != null) {
                    baseFont = font.getBaseFont();
                }
                if (baseFont == null && (substFontName = this.fontSubstitutionMap.get(fontName)) != null && substFontName.length() > 0) {
                    font = super.getFont(substFontName, this.useUnicode ? "Identity-H" : encoding, true, size, style, null);
                }
            }
            catch (UnsupportedCharsetException uce) {
                String substFontName;
                BaseFont baseFont = null;
                font = super.getFont(fontName, encoding, true, size, style, null);
                if (font != null) {
                    baseFont = font.getBaseFont();
                }
                if (baseFont != null || (substFontName = this.fontSubstitutionMap.get(fontName)) == null || substFontName.length() <= 0) break block5;
                font = super.getFont(substFontName, encoding, true, size, style, null);
            }
        }
        return font;
    }
}

