/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css;

import com.itextpdf.text.html.WebColors;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.apply.MarginMemory;
import com.itextpdf.tool.xml.exceptions.NoDataException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssUtils {
    private static final String COLOR = "-color";
    private static final String STYLE = "-style";
    private static final String WIDTH = "-width";
    private static final String BORDER2 = "border-";
    private static final String _0_LEFT_1 = "{0}left{1}";
    private static final String _0_RIGHT_1 = "{0}right{1}";
    private static final String _0_BOTTOM_1 = "{0}bottom{1}";
    private static final String _0_TOP_1 = "{0}top{1}";
    private static CssUtils instance = new CssUtils();
    public static final int DEFAULT_FONT_SIZE_PT = 12;
    private static final Set<String> borderwidth = new HashSet<String>(Arrays.asList("thin", "medium", "thick"));
    private static final Set<String> borderstyle = new HashSet<String>(Arrays.asList("none", "hidden", "dotted", "dashed", "solid", "double", "groove", "ridge", "inset", "outset"));
    private static final Set<String> backgroundPositions = new HashSet<String>(Arrays.asList("left", "center", "bottom", "top", "right"));

    public static CssUtils getInstance() {
        return instance;
    }

    private CssUtils() {
    }

    public Map<String, String> parseBoxValues(String box, String pre, String post) {
        return this.parseBoxValues(box, pre, post, null);
    }

    public Map<String, String> parseBoxValues(String box, String pre, String post, String preKey) {
        String[] props = box.split(" ");
        int length = props.length;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(4);
        if (length == 1) {
            String value = props[0];
            if (preKey == null) {
                map.put(MessageFormat.format(_0_TOP_1, pre, post), value);
                map.put(MessageFormat.format(_0_BOTTOM_1, pre, post), value);
                map.put(MessageFormat.format(_0_RIGHT_1, pre, post), value);
                map.put(MessageFormat.format(_0_LEFT_1, pre, post), value);
            } else {
                map.put(MessageFormat.format(preKey + "{0}", post), value);
            }
        } else if (length == 2) {
            if (preKey == null) {
                map.put(MessageFormat.format(_0_TOP_1, pre, post), props[0]);
                map.put(MessageFormat.format(_0_BOTTOM_1, pre, post), props[0]);
                map.put(MessageFormat.format(_0_RIGHT_1, pre, post), props[1]);
                map.put(MessageFormat.format(_0_LEFT_1, pre, post), props[1]);
            } else {
                map.put(MessageFormat.format(preKey + "{0}", post), props[0]);
            }
        } else if (length == 3) {
            if (preKey == null) {
                map.put(MessageFormat.format(_0_TOP_1, pre, post), props[0]);
                map.put(MessageFormat.format(_0_BOTTOM_1, pre, post), props[2]);
                map.put(MessageFormat.format(_0_RIGHT_1, pre, post), props[1]);
                map.put(MessageFormat.format(_0_LEFT_1, pre, post), props[1]);
            } else {
                map.put(MessageFormat.format(preKey + "{0}", post), props[0]);
            }
        } else if (length == 4) {
            if (preKey == null) {
                map.put(MessageFormat.format(_0_TOP_1, pre, post), props[0]);
                map.put(MessageFormat.format(_0_BOTTOM_1, pre, post), props[2]);
                map.put(MessageFormat.format(_0_RIGHT_1, pre, post), props[1]);
                map.put(MessageFormat.format(_0_LEFT_1, pre, post), props[3]);
            } else {
                map.put(MessageFormat.format(preKey + "{0}", post), props[0]);
            }
        }
        return map;
    }

    public Map<String, String> parseBorder(String border) {
        return this.parseBorder(border, null);
    }

    public Map<String, String> parseBorder(String border, String borderKey) {
        HashMap<String, String> map = new HashMap<String, String>(0);
        String[] split = this.splitComplexCssStyle(border);
        int length = split.length;
        if (length == 1) {
            if (borderwidth.contains(split[0]) || this.isNumericValue(split[0]) || this.isMetricValue(split[0])) {
                map.putAll(this.parseBoxValues(split[0], BORDER2, WIDTH, borderKey));
            } else {
                map.putAll(this.parseBoxValues(split[0], BORDER2, STYLE, borderKey));
            }
        } else {
            for (int i2 = 0; i2 < length; ++i2) {
                String value = split[i2];
                if (borderwidth.contains(value) || this.isNumericValue(value) || this.isMetricValue(value)) {
                    map.putAll(this.parseBoxValues(value, BORDER2, WIDTH, borderKey));
                    continue;
                }
                if (borderstyle.contains(value)) {
                    map.putAll(this.parseBoxValues(value, BORDER2, STYLE, borderKey));
                    continue;
                }
                if (!value.contains("rgb(") && !value.contains("#") && !WebColors.NAMES.containsKey(value.toLowerCase())) continue;
                map.putAll(this.parseBoxValues(value, BORDER2, COLOR, borderKey));
            }
        }
        return map;
    }

    public String stripDoubleSpacesAndTrim(String str) {
        char[] charArray = str.toCharArray();
        if (str.contains("  ")) {
            StringBuilder builder = new StringBuilder();
            for (int i2 = 0; i2 < charArray.length; ++i2) {
                char c = charArray[i2];
                if (c != ' ') {
                    builder.append(c);
                    continue;
                }
                if (i2 + 1 >= charArray.length || charArray[i2 + 1] == ' ') continue;
                builder.append(' ');
            }
            return builder.toString().trim();
        }
        return String.valueOf(charArray).trim();
    }

    public String stripDoubleSpacesTrimAndToLowerCase(String str) {
        return this.stripDoubleSpacesAndTrim(str).toLowerCase();
    }

    public Map<String, String> processBackground(String background) {
        String[] styles;
        HashMap<String, String> rules = new HashMap<String, String>();
        for (String style : styles = this.splitComplexCssStyle(background)) {
            if (style.contains("url(")) {
                rules.put("background-image", style);
                continue;
            }
            if (style.equalsIgnoreCase("repeat") || style.equalsIgnoreCase("no-repeat") || style.equalsIgnoreCase("repeat-x") || style.equalsIgnoreCase("repeat-y")) {
                rules.put("background-repeat", style);
                continue;
            }
            if (style.equalsIgnoreCase("fixed") || style.equalsIgnoreCase("scroll")) {
                rules.put("background-attachment", style);
                continue;
            }
            if (backgroundPositions.contains(style)) {
                if (rules.get("background-position") == null) {
                    rules.put("background-position", style);
                    continue;
                }
                style = style.concat(" " + (String)rules.get("background-position"));
                rules.put("background-position", style);
                continue;
            }
            if (this.isNumericValue(style) || this.isMetricValue(style) || this.isRelativeValue(style)) {
                if (rules.get("background-position") == null) {
                    rules.put("background-position", style);
                    continue;
                }
                style = style.concat(" " + (String)rules.get("background-position"));
                rules.put("background-position", style);
                continue;
            }
            if (!style.contains("rgb(") && !style.contains("rgba(") && !style.contains("#") && !WebColors.NAMES.containsKey(style.toLowerCase())) continue;
            rules.put("background-color", style);
        }
        return rules;
    }

    public Map<String, String> processListStyle(String listStyle) {
        String[] styles;
        HashMap<String, String> rules = new HashMap<String, String>();
        for (String style : styles = this.splitComplexCssStyle(listStyle)) {
            if (style.equalsIgnoreCase("disc") || style.equalsIgnoreCase("square") || style.equalsIgnoreCase("circle") || style.equalsIgnoreCase("lower-roman") || style.equalsIgnoreCase("upper-roman") || style.equalsIgnoreCase("lower-greek") || style.equalsIgnoreCase("upper-greek") || style.equalsIgnoreCase("lower-alpha") || style.equalsIgnoreCase("upper-alpha") || style.equalsIgnoreCase("lower-latin") || style.equalsIgnoreCase("upper-latin")) {
                rules.put("list-style-type", style);
                continue;
            }
            if (style.equalsIgnoreCase("inside") || style.equalsIgnoreCase("outside")) {
                rules.put("list-style-position", style);
                continue;
            }
            if (!style.contains("url(")) continue;
            rules.put("list-style-image", style);
        }
        return rules;
    }

    public Map<String, String> processFont(String font) {
        HashMap<String, String> rules = new HashMap<String, String>();
        String[] styleAndRest = font.split("\\s");
        for (int i2 = 0; i2 < styleAndRest.length; ++i2) {
            String style = styleAndRest[i2];
            if (style.equalsIgnoreCase("italic") || style.equalsIgnoreCase("oblique")) {
                rules.put("font-style", style);
                continue;
            }
            if (style.equalsIgnoreCase("small-caps")) {
                rules.put("font-variant", style);
                continue;
            }
            if (style.equalsIgnoreCase("bold")) {
                rules.put("font-weight", style);
                continue;
            }
            if (!this.isMetricValue(style) && !this.isNumericValue(style)) continue;
            if (style.contains("/")) {
                String[] sizeAndLineHeight = style.split("/");
                style = sizeAndLineHeight[0];
                rules.put("line-height", sizeAndLineHeight[1]);
            }
            rules.put("font-size", style);
            if (i2 == styleAndRest.length - 1) continue;
            String rest = styleAndRest[i2 + 1];
            rest = rest.replaceAll("\"", "");
            rest = rest.replaceAll("'", "");
            rules.put("font-family", rest);
        }
        return rules;
    }

    public float checkMetricStyle(Tag t, String style) {
        Float metricValue = this.checkMetricStyle(t.getCSS(), style);
        if (metricValue != null) {
            return metricValue.floatValue();
        }
        return 0.0f;
    }

    public Float checkMetricStyle(Map<String, String> css, String style) {
        String value = css.get(style);
        if (value != null && (this.isMetricValue(value) || this.isNumericValue(value))) {
            return Float.valueOf(this.parsePxInCmMmPcToPt(value));
        }
        return null;
    }

    public boolean isMetricValue(String value) {
        return value.contains("px") || value.contains("in") || value.contains("cm") || value.contains("mm") || value.contains("pc") || value.contains("pt");
    }

    public boolean isRelativeValue(String value) {
        return value.contains("%") || value.contains("em") || value.contains("ex");
    }

    public boolean isNumericValue(String value) {
        return value.matches("^-?\\d\\d*\\.\\d*$") || value.matches("^-?\\d\\d*$") || value.matches("^-?\\.\\d\\d*$");
    }

    public float parseValueToPt(String value, float baseValue) {
        float parsedValue = 0.0f;
        if (this.isMetricValue(value) || this.isNumericValue(value)) {
            parsedValue = this.parsePxInCmMmPcToPt(value);
        } else if (this.isRelativeValue(value)) {
            parsedValue = this.parseRelativeValue(value, baseValue);
        }
        return parsedValue;
    }

    public float parseRelativeValue(String relativeValue, float baseValue) {
        int pos = this.determinePositionBetweenValueAndUnit(relativeValue);
        if (pos == 0) {
            return 0.0f;
        }
        float f = Float.parseFloat(relativeValue.substring(0, pos) + "f");
        String unit = relativeValue.substring(pos);
        if (unit.startsWith("%")) {
            f = baseValue * f / 100.0f;
        } else if (unit.startsWith("em")) {
            f = baseValue * f;
        } else if (unit.contains("ex")) {
            f = baseValue * f / 2.0f;
        }
        return f;
    }

    public float parsePxInCmMmPcToPt(String length, String defaultMetric) {
        int pos = this.determinePositionBetweenValueAndUnit(length);
        if (pos == 0) {
            return 0.0f;
        }
        float f = Float.parseFloat(length.substring(0, pos) + "f");
        String unit = length.substring(pos);
        if (unit.startsWith("in") || unit.equals("") && defaultMetric.equals("in")) {
            f *= 72.0f;
        } else if (unit.startsWith("cm") || unit.equals("") && defaultMetric.equals("cm")) {
            f = f / 2.54f * 72.0f;
        } else if (unit.startsWith("mm") || unit.equals("") && defaultMetric.equals("mm")) {
            f = f / 25.4f * 72.0f;
        } else if (unit.startsWith("pc") || unit.equals("") && defaultMetric.equals("pc")) {
            f *= 12.0f;
        } else if (unit.startsWith("px") || unit.equals("") && defaultMetric.equals("px")) {
            f *= 0.75f;
        }
        return f;
    }

    public float parsePxInCmMmPcToPt(String length) {
        return this.parsePxInCmMmPcToPt(length, "px");
    }

    public int determinePositionBetweenValueAndUnit(String string) {
        if (string == null) {
            return 0;
        }
        int pos = 0;
        boolean ok = true;
        block3: while (ok && pos < string.length()) {
            switch (string.charAt(pos)) {
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    ++pos;
                    continue block3;
                }
            }
            ok = false;
        }
        return pos;
    }

    public float getLeftAndRightMargin(Tag t, float pageWidth) {
        float horizontalMargin = 0.0f;
        String value = t.getCSS().get("margin-left");
        if (value != null) {
            horizontalMargin += this.parseValueToPt(value, pageWidth);
        }
        if ((value = t.getCSS().get("margin-right")) != null) {
            horizontalMargin += this.parseValueToPt(value, pageWidth);
        }
        return horizontalMargin;
    }

    public String extractUrl(String url) {
        String urlString;
        String str = null;
        str = url.startsWith("url") ? ((urlString = url.substring(3).trim().replace("(", "").replace(")", "").trim()).startsWith("'") && urlString.endsWith("'") ? urlString.substring(urlString.indexOf("'") + 1, urlString.lastIndexOf("'")) : (urlString.startsWith("\"") && urlString.endsWith("\"") ? urlString.substring(urlString.indexOf(34) + 1, urlString.lastIndexOf(34)) : urlString)) : url;
        return str;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public float validateTextHeight(Map<String, String> css, float textHeight) {
        if (null != css.get("min-height")) {
            CssUtils cssUtils = new CssUtils();
            if (textHeight < cssUtils.parsePxInCmMmPcToPt(css.get("min-height"))) {
                return new CssUtils().parsePxInCmMmPcToPt(css.get("min-height"));
            }
        }
        if (null == css.get("max-height")) return textHeight;
        CssUtils cssUtils = new CssUtils();
        if (!(textHeight > cssUtils.parsePxInCmMmPcToPt(css.get("max-height")))) return textHeight;
        return new CssUtils().parsePxInCmMmPcToPt(css.get("max-height"));
    }

    public float calculateMarginTop(String value, float largestFont, MarginMemory configuration) {
        return this.calculateMarginTop(this.parseValueToPt(value, largestFont), configuration);
    }

    public float calculateMarginTop(float value, MarginMemory configuration) {
        float marginTop = value;
        try {
            float marginBottom = configuration.getLastMarginBottom().floatValue();
            marginTop = marginTop > marginBottom ? marginTop - marginBottom : 0.0f;
        }
        catch (NoDataException e) {
            // empty catch block
        }
        return marginTop;
    }

    public String trimAndRemoveQuoutes(String s) {
        if (((s = s.trim()).startsWith("\"") || s.startsWith("'")) && s.endsWith("\"") || s.endsWith("'")) {
            s = s.substring(1, s.length() - 1);
        }
        return s;
    }

    public String[] splitComplexCssStyle(String s) {
        s = s.replaceAll("\\s*,\\s*", ",");
        return s.split("\\s");
    }
}

