/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.text.Image;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.apply.MarginMemory;
import com.itextpdf.tool.xml.css.apply.PageSizeContainable;
import com.itextpdf.tool.xml.html.CssApplier;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageCssApplier
implements CssApplier<Image> {
    public Image apply(Image img, Tag tag) {
        return this.apply(img, tag, (MarginMemory)null, (PageSizeContainable)null, (HtmlPipelineContext)null);
    }

    @Override
    public Image apply(Image img, Tag tag, MarginMemory mm, PageSizeContainable psc, HtmlPipelineContext ctx) {
        String after;
        String before;
        String borderLeftWidth;
        String borderLeftColor;
        String borderBottomWidth;
        String borderBottomColor;
        String borderRightWidth;
        String borderRightColor;
        String borderTopWidth;
        String heightValue;
        Map<String, String> cssMap = tag.getCSS();
        String widthValue = cssMap.get("width");
        if (widthValue == null) {
            widthValue = tag.getAttributes().get("width");
        }
        if ((heightValue = cssMap.get("height")) == null) {
            heightValue = tag.getAttributes().get("height");
        }
        if (widthValue == null) {
            img.setScaleToFitLineWhenOverflow(true);
        } else {
            img.setScaleToFitLineWhenOverflow(false);
        }
        img.setScaleToFitHeight(false);
        CssUtils utils = CssUtils.getInstance();
        float widthInPoints = utils.parsePxInCmMmPcToPt(widthValue);
        float heightInPoints = utils.parsePxInCmMmPcToPt(heightValue);
        if (widthInPoints > 0.0f && heightInPoints > 0.0f) {
            img.scaleAbsolute(widthInPoints, heightInPoints);
        } else if (widthInPoints > 0.0f) {
            heightInPoints = img.getHeight() * widthInPoints / img.getWidth();
            img.scaleAbsolute(widthInPoints, heightInPoints);
        } else if (heightInPoints > 0.0f) {
            widthInPoints = img.getWidth() * heightInPoints / img.getHeight();
            img.scaleAbsolute(widthInPoints, heightInPoints);
        }
        String borderTopColor = cssMap.get("border-top-color");
        if (borderTopColor != null) {
            img.setBorderColorTop(HtmlUtilities.decodeColor(borderTopColor));
        }
        if ((borderTopWidth = cssMap.get("border-top-width")) != null) {
            img.setBorderWidthTop(utils.parseValueToPt(borderTopWidth, 1.0f));
        }
        if ((borderRightColor = cssMap.get("border-right-color")) != null) {
            img.setBorderColorRight(HtmlUtilities.decodeColor(borderRightColor));
        }
        if ((borderRightWidth = cssMap.get("border-right-width")) != null) {
            img.setBorderWidthRight(utils.parseValueToPt(borderRightWidth, 1.0f));
        }
        if ((borderBottomColor = cssMap.get("border-bottom-color")) != null) {
            img.setBorderColorBottom(HtmlUtilities.decodeColor(borderBottomColor));
        }
        if ((borderBottomWidth = cssMap.get("border-bottom-width")) != null) {
            img.setBorderWidthBottom(utils.parseValueToPt(borderBottomWidth, 1.0f));
        }
        if ((borderLeftColor = cssMap.get("border-left-color")) != null) {
            img.setBorderColorLeft(HtmlUtilities.decodeColor(borderLeftColor));
        }
        if ((borderLeftWidth = cssMap.get("border-left-width")) != null) {
            img.setBorderWidthLeft(utils.parseValueToPt(borderLeftWidth, 1.0f));
        }
        if ((before = cssMap.get("before")) != null) {
            img.setSpacingBefore(Float.parseFloat(before));
        }
        if ((after = cssMap.get("after")) != null) {
            img.setSpacingAfter(Float.parseFloat(after));
        }
        img.setWidthPercentage(0.0f);
        return img;
    }
}

