/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.apply;

import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CSS;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import com.itextpdf.tool.xml.css.apply.MarginMemory;
import com.itextpdf.tool.xml.css.apply.PageSizeContainable;
import com.itextpdf.tool.xml.html.CssApplier;
import com.itextpdf.tool.xml.html.CssAppliers;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParagraphCssApplier
implements CssApplier<Paragraph> {
    private final CssAppliers appliers;

    public ParagraphCssApplier(CssAppliers appliers) {
        this.appliers = appliers;
    }

    public Paragraph apply(Paragraph p2, Tag t, MarginMemory configuration) {
        return this.apply(p2, t, configuration, (PageSizeContainable)null, (HtmlPipelineContext)null);
    }

    @Override
    public Paragraph apply(Paragraph p2, Tag t, MarginMemory configuration, PageSizeContainable psc, HtmlPipelineContext ctx) {
        String value;
        CssUtils utils = CssUtils.getInstance();
        float fontSize = FontSizeTranslator.getInstance().getFontSize(t);
        if (fontSize == -1.0f) {
            fontSize = 0.0f;
        }
        float lmb = 0.0f;
        boolean hasLMB = false;
        Map<String, String> css = t.getCSS();
        for (Map.Entry<String, String> entry : css.entrySet()) {
            String key = entry.getKey();
            String value2 = entry.getValue();
            if ("margin-top".equalsIgnoreCase(key)) {
                p2.setSpacingBefore(p2.getSpacingBefore() + utils.calculateMarginTop(value2, fontSize, configuration));
                continue;
            }
            if ("padding-top".equalsIgnoreCase(key)) {
                p2.setSpacingBefore(p2.getSpacingBefore() + utils.parseValueToPt(value2, fontSize));
                p2.setPaddingTop(utils.parseValueToPt(value2, fontSize));
                continue;
            }
            if ("margin-bottom".equalsIgnoreCase(key)) {
                float after = utils.parseValueToPt(value2, fontSize);
                p2.setSpacingAfter(p2.getSpacingAfter() + after);
                lmb = after;
                hasLMB = true;
                continue;
            }
            if ("padding-bottom".equalsIgnoreCase(key)) {
                p2.setSpacingAfter(p2.getSpacingAfter() + utils.parseValueToPt(value2, fontSize));
                continue;
            }
            if ("margin-left".equalsIgnoreCase(key)) {
                p2.setIndentationLeft(p2.getIndentationLeft() + utils.parseValueToPt(value2, fontSize));
                continue;
            }
            if ("margin-right".equalsIgnoreCase(key)) {
                p2.setIndentationRight(p2.getIndentationRight() + utils.parseValueToPt(value2, fontSize));
                continue;
            }
            if ("padding-left".equalsIgnoreCase(key)) {
                p2.setIndentationLeft(p2.getIndentationLeft() + utils.parseValueToPt(value2, fontSize));
                continue;
            }
            if ("padding-right".equalsIgnoreCase(key)) {
                p2.setIndentationRight(p2.getIndentationRight() + utils.parseValueToPt(value2, fontSize));
                continue;
            }
            if ("text-align".equalsIgnoreCase(key)) {
                p2.setAlignment(CSS.getElementAlignment(value2));
                continue;
            }
            if ("text-indent".equalsIgnoreCase(key)) {
                p2.setFirstLineIndent(utils.parseValueToPt(value2, fontSize));
                continue;
            }
            if (!"line-height".equalsIgnoreCase(key)) continue;
            if (utils.isNumericValue(value2)) {
                p2.setLeading(Float.parseFloat(value2) * fontSize);
                continue;
            }
            if (utils.isRelativeValue(value2)) {
                p2.setLeading(utils.parseRelativeValue(value2, fontSize));
                continue;
            }
            if (!utils.isMetricValue(value2)) continue;
            p2.setLeading(utils.parsePxInCmMmPcToPt(value2));
        }
        if (t.getAttributes().containsKey("align") && (value = t.getAttributes().get("align")) != null) {
            p2.setAlignment(CSS.getElementAlignment(value));
        }
        if (hasLMB) {
            configuration.setLastMarginBottom(Float.valueOf(lmb));
        }
        Font font = this.appliers.getChunkCssAplier().applyFontStyles(t);
        p2.setFont(font);
        return p2;
    }
}

