/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.api.Indentable;
import com.itextpdf.text.pdf.draw.LineSeparator;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.CssAppliers;
import com.itextpdf.tool.xml.html.CssAppliersAware;
import com.itextpdf.tool.xml.html.HTMLUtils;
import com.itextpdf.tool.xml.html.TagProcessor;
import com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import com.itextpdf.tool.xml.pipeline.css.CSSResolver;
import com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import com.itextpdf.tool.xml.pipeline.ctx.ObjectContext;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import com.itextpdf.tool.xml.util.ParentTreeUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractTagProcessor
implements TagProcessor,
CssAppliersAware {
    private final FontSizeTranslator fontsizeTrans;
    private CssAppliers cssAppliers;
    private Set<String> ignoreDirAttribute = new HashSet<String>(){
        {
            this.add("p");
            this.add("span");
        }
    };
    private List<Tag> tree;

    public AbstractTagProcessor() {
        this.fontsizeTrans = FontSizeTranslator.getInstance();
    }

    public CSSResolver getCSSResolver(WorkerContext context) throws NoCustomContextException {
        return (CSSResolver)((ObjectContext)context.get(CssResolverPipeline.class.getName())).get();
    }

    public HtmlPipelineContext getHtmlPipelineContext(WorkerContext context) throws NoCustomContextException {
        return (HtmlPipelineContext)context.get(HtmlPipeline.class.getName());
    }

    @Override
    public final List<Element> startElement(WorkerContext ctx, Tag tag) {
        String pagebreak;
        float fontSize = this.fontsizeTrans.translateFontSize(tag);
        if (fontSize != -1.0f) {
            tag.getCSS().put("font-size", fontSize + "pt");
        }
        if (null != (pagebreak = tag.getCSS().get("page-break-before")) && "always".equalsIgnoreCase(pagebreak)) {
            ArrayList<Element> list = new ArrayList<Element>(2);
            list.add(Chunk.NEXTPAGE);
            list.addAll(this.start(ctx, tag));
            return list;
        }
        return this.start(ctx, tag);
    }

    public List<Element> start(WorkerContext ctx, Tag tag) {
        return new ArrayList<Element>(0);
    }

    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        return new ArrayList<Element>(0);
    }

    private String getParentDirection() {
        String result = null;
        for (Tag tag : this.tree) {
            if (!(this.ignoreDirAttribute.contains(tag.getName().toLowerCase()) || (result = tag.getAttributes().get("dir")) == null && (result = tag.getCSS().get("direction")) == null)) break;
        }
        return result;
    }

    protected int getRunDirection(Tag tag) {
        boolean toFetchRunDirFromThisTag;
        String dirValue = null;
        boolean bl = toFetchRunDirFromThisTag = tag.getName() != null && !this.ignoreDirAttribute.contains(tag.getName().toLowerCase());
        if (toFetchRunDirFromThisTag) {
            dirValue = tag.getAttributes().get("dir");
        }
        if (dirValue == null) {
            if (toFetchRunDirFromThisTag) {
                dirValue = tag.getCSS().get("direction");
            }
            if (dirValue == null) {
                this.tree = new ParentTreeUtil().getParentTagTree(tag, this.tree);
                dirValue = this.getParentDirection();
            }
        }
        if ("rtl".equalsIgnoreCase(dirValue)) {
            return 3;
        }
        if ("ltr".equalsIgnoreCase(dirValue)) {
            return 2;
        }
        if ("auto".equalsIgnoreCase(dirValue)) {
            return 0;
        }
        return 1;
    }

    protected List<Element> textContent(WorkerContext ctx, Tag tag, String content) {
        List<Chunk> sanitizedChunks = HTMLUtils.sanitize(content, false);
        ArrayList<Element> l = new ArrayList<Element>(1);
        for (Chunk sanitized : sanitizedChunks) {
            try {
                l.add(this.getCssAppliers().apply(sanitized, tag, this.getHtmlPipelineContext(ctx)));
            }
            catch (NoCustomContextException e) {
                throw new RuntimeWorkerException(e);
            }
        }
        return l;
    }

    @Override
    public final List<Element> endElement(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        ArrayList<Element> list = new ArrayList();
        if (currentContent.isEmpty()) {
            list = this.end(ctx, tag, currentContent);
        } else {
            ArrayList<Element> elements = new ArrayList<Element>();
            for (Element el : currentContent) {
                if (el instanceof Chunk && ((Chunk)el).hasAttributes() && ((Chunk)el).getAttributes().containsKey("NEWPAGE")) {
                    if (elements.size() > 0) {
                        list.addAll(this.end(ctx, tag, elements));
                        elements.clear();
                    }
                    list.add(el);
                    continue;
                }
                elements.add(el);
            }
            if (elements.size() > 0) {
                list.addAll(this.end(ctx, tag, elements));
                elements.clear();
            }
        }
        String pagebreak = tag.getCSS().get("page-break-after");
        if (null != pagebreak && "always".equalsIgnoreCase(pagebreak)) {
            list.add(Chunk.NEXTPAGE);
        }
        return list;
    }

    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        return new ArrayList<Element>(currentContent);
    }

    @Override
    public boolean isStackOwner() {
        return false;
    }

    public List<Element> currentContentToParagraph(List<Element> currentContent, boolean addNewLines, boolean applyCSS, Tag tag, WorkerContext ctx) {
        try {
            int direction = this.getRunDirection(tag);
            ArrayList<Element> list = new ArrayList<Element>();
            if (currentContent.size() > 0) {
                if (addNewLines) {
                    Paragraph p2 = this.createParagraph();
                    p2.setMultipliedLeading(1.2f);
                    for (Element e : currentContent) {
                        if (e instanceof LineSeparator) {
                            try {
                                HtmlPipelineContext htmlPipelineContext = this.getHtmlPipelineContext(ctx);
                                Chunk newLine = (Chunk)this.getCssAppliers().apply(new Chunk(Chunk.NEWLINE), tag, htmlPipelineContext);
                                p2.add(newLine);
                            }
                            catch (NoCustomContextException e1) {
                                throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e1);
                            }
                        }
                        p2.add(e);
                    }
                    if (p2.trim()) {
                        if (applyCSS) {
                            p2 = (Paragraph)this.getCssAppliers().apply(p2, tag, this.getHtmlPipelineContext(ctx));
                        }
                        if (direction == 3) {
                            this.doRtlIndentCorrections(p2);
                            this.invertTextAlignForParagraph(p2);
                        }
                        list.add(p2);
                    }
                } else {
                    NoNewLineParagraph p3 = new NoNewLineParagraph(Float.NaN);
                    p3.setMultipliedLeading(1.2f);
                    for (Element e : currentContent) {
                        this.updateParagraphFontIfNeeded(p3, e);
                        p3.add(e);
                    }
                    p3 = (NoNewLineParagraph)this.getCssAppliers().apply(p3, tag, this.getHtmlPipelineContext(ctx));
                    if (direction == 3) {
                        this.doRtlIndentCorrections(p3);
                        this.invertTextAlignForParagraph(p3);
                    }
                    list.add(p3);
                }
            }
            return list;
        }
        catch (NoCustomContextException e) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
        }
    }

    public final List<Element> currentContentToParagraph(List<Element> currentContent, boolean addNewLines) {
        return this.currentContentToParagraph(currentContent, addNewLines, false, null, null);
    }

    @Override
    public void setCssAppliers(CssAppliers cssAppliers) {
        this.cssAppliers = cssAppliers;
    }

    @Override
    public CssAppliers getCssAppliers() {
        return this.cssAppliers;
    }

    protected Paragraph createParagraph() {
        return new Paragraph(Float.NaN);
    }

    protected void doRtlIndentCorrections(Indentable p2) {
        float right = p2.getIndentationRight();
        p2.setIndentationRight(p2.getIndentationLeft());
        p2.setIndentationLeft(right);
    }

    protected void invertTextAlignForParagraph(Paragraph p2) {
        switch (p2.getAlignment()) {
            case -1: 
            case 1: 
            case 3: 
            case 8: {
                break;
            }
            case 2: {
                p2.setAlignment(0);
                break;
            }
            default: {
                p2.setAlignment(2);
            }
        }
    }

    protected void invertTextAlignForParagraph(NoNewLineParagraph p2) {
        switch (p2.getAlignment()) {
            case -1: 
            case 1: 
            case 3: 
            case 8: {
                break;
            }
            case 2: {
                p2.setAlignment(0);
                break;
            }
            default: {
                p2.setAlignment(2);
            }
        }
    }

    protected void updateParagraphFontIfNeeded(Phrase p2, Element child) {
        float pFontSize;
        Font childFont = null;
        if (child instanceof Chunk) {
            childFont = ((Chunk)child).getFont();
        } else if (child instanceof Phrase) {
            childFont = ((Phrase)child).getFont();
        }
        float f = pFontSize = p2.getFont() != null ? p2.getFont().getSize() : 12.0f;
        if (childFont != null && childFont.getSize() > pFontSize) {
            p2.setFont(childFont);
        }
    }
}

