/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.Element;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.text.pdf.PdfBody;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.html.HTMLUtils;
import com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import com.itextpdf.tool.xml.pipeline.ctx.MapContext;
import com.itextpdf.tool.xml.pipeline.end.PdfWriterPipeline;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Body
extends AbstractTagProcessor {
    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        List<Chunk> sanitizedChunks = HTMLUtils.sanitize(content, false);
        ArrayList<Element> l = new ArrayList<Element>(1);
        NoNewLineParagraph sanitizedNoNewLineParagraph = new NoNewLineParagraph();
        for (Chunk sanitized : sanitizedChunks) {
            Chunk c = this.getCssAppliers().getChunkCssAplier().apply(sanitized, tag);
            sanitizedNoNewLineParagraph.add(c);
        }
        if (sanitizedNoNewLineParagraph.size() > 0) {
            try {
                l.add(this.getCssAppliers().apply(sanitizedNoNewLineParagraph, tag, this.getHtmlPipelineContext(ctx)));
            }
            catch (NoCustomContextException e) {
                throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
            }
        }
        return l;
    }

    @Override
    public List<Element> start(WorkerContext ctx, Tag tag) {
        ArrayList<Element> l = new ArrayList<Element>(1);
        try {
            MapContext pipeline;
            Map<String, String> css = tag.getCSS();
            if (css.containsKey("background-color") && (pipeline = (MapContext)ctx.get(PdfWriterPipeline.class.getName())) != null) {
                Document document = (Document)pipeline.get("DOCUMENT");
                Rectangle rectangle = new Rectangle(document.left(), document.bottom(), document.right(), document.top(), document.getPageSize().getRotation());
                rectangle.setBackgroundColor(HtmlUtilities.decodeColor(css.get("background-color")));
                PdfBody body2 = new PdfBody(rectangle);
                l.add(body2);
            }
        }
        catch (NoCustomContextException e) {
            // empty catch block
        }
        return l;
    }
}

