/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfDiv;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.html.HTMLUtils;
import com.itextpdf.tool.xml.html.pdfelement.NoNewLineParagraph;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Div
extends AbstractTagProcessor {
    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        List<Chunk> sanitizedChunks = HTMLUtils.sanitize(content, false);
        NoNewLineParagraph noNewLineParagraph = new NoNewLineParagraph();
        ArrayList<Element> l = new ArrayList<Element>(1);
        try {
            HtmlPipelineContext htmlPipelineContext = this.getHtmlPipelineContext(ctx);
            for (Chunk sanitized : sanitizedChunks) {
                noNewLineParagraph.add(this.getCssAppliers().apply(sanitized, tag, htmlPipelineContext));
            }
            if (noNewLineParagraph.size() > 0) {
                l.add(this.getCssAppliers().apply(noNewLineParagraph, tag, htmlPipelineContext));
            }
        }
        catch (NoCustomContextException e) {
            throw new RuntimeWorkerException(e);
        }
        return l;
    }

    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        try {
            Phrase p2 = null;
            PdfDiv div = (PdfDiv)this.getCssAppliers().apply(new PdfDiv(), tag, this.getHtmlPipelineContext(ctx));
            int direction = this.getRunDirection(tag);
            if (direction != 1) {
                div.setRunDirection(direction);
            }
            for (Element e : currentContent) {
                if (e instanceof Paragraph || e instanceof PdfPTable || e instanceof PdfDiv) {
                    if (p2 != null) {
                        if (p2.trim()) {
                            div.addElement(p2);
                        }
                        p2 = null;
                    }
                    div.addElement(e);
                    continue;
                }
                if (p2 == null) {
                    p2 = new Paragraph();
                    ((Paragraph)p2).setAlignment(div.getTextAlignment());
                    if (direction == 3) {
                        this.invertTextAlignForParagraph((Paragraph)p2);
                    }
                    p2.setMultipliedLeading(1.2f);
                }
                ((Paragraph)p2).add(e);
            }
            if (p2 != null && p2.trim()) {
                div.addElement(p2);
            }
            if (direction == 3) {
                this.invertTextAlignForDiv(div);
            }
            ArrayList<Element> l = new ArrayList<Element>(1);
            l.add(div);
            return l;
        }
        catch (NoCustomContextException e) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
        }
    }

    private void invertTextAlignForDiv(PdfDiv div) {
        switch (div.getTextAlignment()) {
            case -1: 
            case 1: 
            case 3: 
            case 8: {
                break;
            }
            case 2: {
                div.setTextAlignment(0);
                break;
            }
            default: {
                div.setTextAlignment(2);
            }
        }
    }

    @Override
    public boolean isStackOwner() {
        return true;
    }
}

