/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Element;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.draw.LineSeparator;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HorizontalRule
extends AbstractTagProcessor {
    @Override
    public List<Element> start(WorkerContext ctx, Tag tag) {
        try {
            String marginBottom;
            String marginTop;
            ArrayList<Element> list = new ArrayList<Element>();
            HtmlPipelineContext htmlPipelineContext = this.getHtmlPipelineContext(ctx);
            LineSeparator lineSeparator = (LineSeparator)this.getCssAppliers().apply(new LineSeparator(), tag, htmlPipelineContext);
            Paragraph p2 = new Paragraph();
            Map<String, String> css = tag.getCSS();
            float fontSize = 12.0f;
            if (css.get("font-size") != null) {
                fontSize = CssUtils.getInstance().parsePxInCmMmPcToPt(css.get("font-size"));
            }
            if ((marginTop = css.get("margin-top")) == null) {
                marginTop = "0.5em";
            }
            if ((marginBottom = css.get("margin-bottom")) == null) {
                marginBottom = "0.5em";
            }
            p2.setSpacingBefore(p2.getSpacingBefore() + CssUtils.getInstance().parseValueToPt(marginTop, fontSize));
            p2.setSpacingAfter(p2.getSpacingAfter() + CssUtils.getInstance().parseValueToPt(marginBottom, fontSize));
            p2.setLeading(0.0f);
            p2.add(lineSeparator);
            list.add(p2);
            return list;
        }
        catch (NoCustomContextException e) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
        }
    }
}

