/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Element;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.draw.LineSeparator;
import com.itextpdf.text.pdf.draw.VerticalPositionMark;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.html.HTMLUtils;
import com.itextpdf.tool.xml.html.pdfelement.TabbedChunk;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParaGraph
extends AbstractTagProcessor {
    @Override
    public List<Element> content(WorkerContext ctx, Tag tag, String content) {
        List<Chunk> sanitizedChunks = HTMLUtils.sanitize(content, false);
        ArrayList<Element> l = new ArrayList<Element>(1);
        for (Chunk sanitized : sanitizedChunks) {
            TabbedChunk tabbedChunk;
            HtmlPipelineContext myctx;
            try {
                myctx = this.getHtmlPipelineContext(ctx);
            }
            catch (NoCustomContextException e) {
                throw new RuntimeWorkerException(e);
            }
            if (null != tag.getCSS().get("tab-interval")) {
                tabbedChunk = new TabbedChunk(sanitized.getContent());
                if (null != this.getLastChild(tag) && null != this.getLastChild(tag).getCSS().get("xfa-tab-count")) {
                    tabbedChunk.setTabCount(Integer.parseInt(this.getLastChild(tag).getCSS().get("xfa-tab-count")));
                }
                l.add(this.getCssAppliers().apply(tabbedChunk, tag, myctx));
                continue;
            }
            if (null != this.getLastChild(tag) && null != this.getLastChild(tag).getCSS().get("xfa-tab-count")) {
                tabbedChunk = new TabbedChunk(sanitized.getContent());
                tabbedChunk.setTabCount(Integer.parseInt(this.getLastChild(tag).getCSS().get("xfa-tab-count")));
                l.add(this.getCssAppliers().apply(tabbedChunk, tag, myctx));
                continue;
            }
            l.add(this.getCssAppliers().apply(sanitized, tag, myctx));
        }
        return l;
    }

    private Tag getLastChild(Tag tag) {
        if (0 != tag.getChildren().size()) {
            return tag.getChildren().get(tag.getChildren().size() - 1);
        }
        return null;
    }

    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        ArrayList<Element> l = new ArrayList<Element>(1);
        if (currentContent.size() > 0) {
            ArrayList<Element> elements = new ArrayList<Element>();
            ArrayList<ListItem> listItems = new ArrayList<ListItem>();
            for (Element el : currentContent) {
                if (el instanceof ListItem) {
                    if (!elements.isEmpty()) {
                        this.processParagraphItems(ctx, tag, elements, l);
                        elements.clear();
                    }
                    listItems.add((ListItem)el);
                    continue;
                }
                if (!listItems.isEmpty()) {
                    this.processListItems(ctx, tag, listItems, l);
                    listItems.clear();
                }
                elements.add(el);
            }
            if (!elements.isEmpty()) {
                this.processParagraphItems(ctx, tag, elements, l);
                elements.clear();
            } else if (!listItems.isEmpty()) {
                this.processListItems(ctx, tag, listItems, l);
                listItems.clear();
            }
        }
        return l;
    }

    protected void processParagraphItems(WorkerContext ctx, Tag tag, List<Element> paragraphItems, List<Element> l) {
        Paragraph p2 = new Paragraph();
        p2.setMultipliedLeading(1.2f);
        Map<String, String> css = tag.getCSS();
        if (null != css.get("tab-interval")) {
            this.addTabIntervalContent(ctx, tag, paragraphItems, p2, css.get("tab-interval"));
            l.add(p2);
        } else if (null != css.get("tab-stops")) {
            this.addTabStopsContent(paragraphItems, p2, css.get("tab-stops"));
            l.add(p2);
        } else if (null != css.get("xfa-tab-stops")) {
            this.addTabStopsContent(paragraphItems, p2, css.get("xfa-tab-stops"));
            l.add(p2);
        } else {
            Element firstElement;
            List<Element> paraList = this.currentContentToParagraph(paragraphItems, true, true, tag, ctx);
            if (!l.isEmpty() && !paraList.isEmpty() && (firstElement = paraList.get(0)) instanceof Paragraph) {
                ((Paragraph)firstElement).setSpacingBefore(0.0f);
            }
            for (Element e : paraList) {
                l.add(e);
            }
        }
    }

    protected void processListItems(WorkerContext ctx, Tag tag, List<ListItem> listItems, List<Element> l) {
        try {
            Element latestElement;
            com.itextpdf.text.List list = new com.itextpdf.text.List();
            list.setAlignindent(false);
            list = (com.itextpdf.text.List)this.getCssAppliers().apply(list, tag, this.getHtmlPipelineContext(ctx));
            list.setIndentationLeft(0.0f);
            int i2 = 0;
            for (ListItem li : listItems) {
                li = (ListItem)this.getCssAppliers().apply(li, tag, this.getHtmlPipelineContext(ctx));
                if (i2 != listItems.size() - 1) {
                    li.setSpacingAfter(0.0f);
                }
                if (i2 != 0) {
                    li.setSpacingBefore(0.0f);
                }
                ++i2;
                li.setMultipliedLeading(1.2f);
                list.add(li);
            }
            if (!l.isEmpty() && (latestElement = l.get(l.size() - 1)) instanceof Paragraph) {
                ((Paragraph)latestElement).setSpacingAfter(0.0f);
            }
            l.add(list);
        }
        catch (NoCustomContextException e) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
        }
    }

    private void addTabIntervalContent(WorkerContext ctx, Tag tag, List<Element> currentContent, Paragraph p2, String value) {
        float width = 0.0f;
        for (Element e : currentContent) {
            if (e instanceof TabbedChunk) {
                TabbedChunk tab = new TabbedChunk(new VerticalPositionMark(), width += (float)((TabbedChunk)e).getTabCount() * CssUtils.getInstance().parsePxInCmMmPcToPt(value), false);
                p2.add(new Chunk(tab));
                p2.add(new Chunk((TabbedChunk)e));
                continue;
            }
            if (e instanceof LineSeparator) {
                try {
                    HtmlPipelineContext htmlPipelineContext = this.getHtmlPipelineContext(ctx);
                    Chunk newLine = (Chunk)this.getCssAppliers().apply(new Chunk(Chunk.NEWLINE), tag, htmlPipelineContext);
                    p2.add(newLine);
                }
                catch (NoCustomContextException e1) {
                    throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e1);
                }
            }
            p2.add(e);
        }
    }

    private void addTabStopsContent(List<Element> currentContent, Paragraph p2, String value) {
        ArrayList<TabbedChunk> tabs = new ArrayList<TabbedChunk>();
        String[] alignAndWidth = value.split(" ");
        float tabWidth = 0.0f;
        int i2 = 0;
        for (int j = 1; j < alignAndWidth.length; j += 2) {
            TabbedChunk tab = new TabbedChunk(new VerticalPositionMark(), tabWidth += CssUtils.getInstance().parsePxInCmMmPcToPt(alignAndWidth[j]), true, alignAndWidth[i2]);
            tabs.add(tab);
            i2 += 2;
        }
        int tabsPerRow = tabs.size();
        int currentTab = 0;
        for (Element e : currentContent) {
            if (e instanceof TabbedChunk) {
                if (currentTab == tabsPerRow) {
                    currentTab = 0;
                }
                if (((TabbedChunk)e).getTabCount() == 0) continue;
                p2.add(new Chunk((Chunk)tabs.get(currentTab)));
                p2.add(new Chunk((TabbedChunk)e));
                ++currentTab;
                continue;
            }
            p2.add(e);
        }
    }

    @Override
    public boolean isStackOwner() {
        return true;
    }
}

