/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.html.table;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Image;
import com.itextpdf.text.ListItem;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.html.HtmlUtilities;
import com.itextpdf.text.log.Level;
import com.itextpdf.text.log.Logger;
import com.itextpdf.text.log.LoggerFactory;
import com.itextpdf.text.pdf.PdfDiv;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPRow;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPTableEvent;
import com.itextpdf.tool.xml.NoCustomContextException;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.CSS;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.FontSizeTranslator;
import com.itextpdf.tool.xml.css.HeightCalculator;
import com.itextpdf.tool.xml.css.WidthCalculator;
import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.RuntimeWorkerException;
import com.itextpdf.tool.xml.html.AbstractTagProcessor;
import com.itextpdf.tool.xml.html.pdfelement.HtmlCell;
import com.itextpdf.tool.xml.html.table.TableBorderEvent;
import com.itextpdf.tool.xml.html.table.TableRowElement;
import com.itextpdf.tool.xml.html.table.TableStyleValues;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Table
extends AbstractTagProcessor {
    public static final float DEFAULT_CELL_BORDER_WIDTH = 0.75f;
    private static final Logger LOG = LoggerFactory.getLogger(Table.class);
    private static final CssUtils utils = CssUtils.getInstance();
    private static final FontSizeTranslator fst = FontSizeTranslator.getInstance();

    @Override
    public List<Element> end(WorkerContext ctx, Tag tag, List<Element> currentContent) {
        try {
            int column;
            boolean percentage = false;
            String widthValue = tag.getCSS().get("width");
            if (widthValue == null) {
                widthValue = tag.getAttributes().get("width");
            }
            if (widthValue != null && widthValue.trim().endsWith("%")) {
                percentage = true;
            }
            int numberOfColumns = 0;
            ArrayList<TableRowElement> tableRows = new ArrayList<TableRowElement>(currentContent.size());
            ArrayList<Element> invalidRowElements = new ArrayList<Element>(1);
            String repeatHeader = tag.getCSS().get("repeat-header");
            String repeatFooter = tag.getCSS().get("repeat-footer");
            int headerRows = 0;
            int footerRows = 0;
            for (Element e : currentContent) {
                int localNumCols = 0;
                if (e instanceof TableRowElement) {
                    TableRowElement tableRowElement = (TableRowElement)e;
                    for (HtmlCell cell : tableRowElement.getContent()) {
                        localNumCols += cell.getColspan();
                    }
                    if (localNumCols > numberOfColumns) {
                        numberOfColumns = localNumCols;
                    }
                    tableRows.add(tableRowElement);
                    if (repeatHeader != null && repeatHeader.equalsIgnoreCase("yes") && tableRowElement.getPlace().equals((Object)TableRowElement.Place.HEADER)) {
                        ++headerRows;
                    }
                    if (repeatFooter == null || !repeatFooter.equalsIgnoreCase("yes") || !tableRowElement.getPlace().equals((Object)TableRowElement.Place.FOOTER)) continue;
                    ++footerRows;
                    continue;
                }
                invalidRowElements.add(e);
            }
            if (repeatFooter == null || !repeatFooter.equalsIgnoreCase("yes")) {
                Collections.sort(tableRows, new NormalRowComparator());
            } else {
                Collections.sort(tableRows, new RepeatedRowComparator());
            }
            PdfPTable table = this.intPdfPTable(numberOfColumns);
            table.setHeaderRows(headerRows + footerRows);
            table.setFooterRows(footerRows);
            if (tag.getAttributes().containsKey("align")) {
                String value = tag.getAttributes().get("align");
                table.setHorizontalAlignment(CSS.getElementAlignment(value));
            }
            int direction = this.getRunDirection(tag);
            table.setRunDirection(direction);
            for (Map.Entry<String, String> entry : tag.getCSS().entrySet()) {
                if (!entry.getKey().equalsIgnoreCase("page-break-inside") || !entry.getValue().equalsIgnoreCase("avoid")) continue;
                table.setKeepTogether(true);
            }
            TableStyleValues styleValues = Table.setStyleValues(tag);
            table.setTableEvent(new TableBorderEvent(styleValues));
            this.setVerticalMargin(table, tag, styleValues, ctx);
            this.widenLastCell(tableRows, styleValues.getHorBorderSpacing());
            float[] columnWidths = new float[numberOfColumns];
            float[] widestWords = new float[numberOfColumns];
            float[] fixedWidths = new float[numberOfColumns];
            float[] colspanWidestWords = new float[numberOfColumns];
            int[] rowspanValue = new int[numberOfColumns];
            float largestColumn = 0.0f;
            float largestColspanColumn = 0.0f;
            int indexOfLargestColumn = -1;
            int indexOfLargestColspanColumn = -1;
            for (TableRowElement row : tableRows) {
                int column2 = 0;
                for (HtmlCell cell : row.getContent()) {
                    while (column2 < numberOfColumns && rowspanValue[column2] > 0) {
                        rowspanValue[column2] = rowspanValue[column2] - 1;
                        ++column2;
                    }
                    if (cell.getRowspan() > 1 && column2 != numberOfColumns - 1 && column2 < rowspanValue.length) {
                        rowspanValue[column2] = cell.getRowspan() - 1;
                    }
                    int colspan = cell.getColspan();
                    if (cell.getFixedWidth() != 0.0f) {
                        int c;
                        float fixedWidth = cell.getFixedWidth() + this.getCellStartWidth(cell);
                        float colSpanWidthSum = 0.0f;
                        int nonZeroColspanCols = 0;
                        for (c = column2; c < column2 + colspan && c < numberOfColumns; ++c) {
                            colSpanWidthSum += fixedWidths[c];
                            if (fixedWidths[c] == 0.0f) continue;
                            ++nonZeroColspanCols;
                        }
                        for (c = column2; c < column2 + colspan && c < numberOfColumns; ++c) {
                            if (fixedWidths[c] != 0.0f) continue;
                            fixedWidths[c] = (fixedWidth - colSpanWidthSum) / (float)(colspan - nonZeroColspanCols);
                            columnWidths[c] = (fixedWidth - colSpanWidthSum) / (float)(colspan - nonZeroColspanCols);
                        }
                    }
                    if (cell.getCompositeElements() != null) {
                        float[] widthValues = this.setCellWidthAndWidestWord(cell);
                        float cellWidth = widthValues[0] / (float)colspan;
                        float widestWordOfCell = widthValues[1] / (float)colspan;
                        for (int i2 = 0; i2 < colspan; ++i2) {
                            int c = column2 + i2;
                            if (c >= numberOfColumns) continue;
                            if (fixedWidths[c] == 0.0f && cellWidth > columnWidths[c]) {
                                columnWidths[c] = cellWidth;
                                if (colspan == 1) {
                                    if (cellWidth > largestColumn) {
                                        largestColumn = cellWidth;
                                        indexOfLargestColumn = c;
                                    }
                                } else if (cellWidth > largestColspanColumn) {
                                    largestColspanColumn = cellWidth;
                                    indexOfLargestColspanColumn = c;
                                }
                            }
                            if (colspan == 1) {
                                if (!(widestWordOfCell > widestWords[c])) continue;
                                widestWords[c] = widestWordOfCell;
                                continue;
                            }
                            if (!(widestWordOfCell > colspanWidestWords[c])) continue;
                            colspanWidestWords[c] = widestWordOfCell;
                        }
                    }
                    if (colspan > 1) {
                        if (LOG.isLogging(Level.TRACE)) {
                            LOG.trace(String.format(LocaleMessages.getInstance().getMessage("html.tag.table.colspan"), colspan));
                        }
                        column2 += colspan - 1;
                    }
                    ++column2;
                }
            }
            if (indexOfLargestColumn == -1) {
                indexOfLargestColumn = indexOfLargestColspanColumn;
                if (indexOfLargestColumn == -1) {
                    indexOfLargestColumn = 0;
                }
                for (int column3 = 0; column3 < numberOfColumns; ++column3) {
                    widestWords[column3] = colspanWidestWords[column3];
                }
            }
            float outerWidth = this.getTableOuterWidth(tag, styleValues.getHorBorderSpacing(), ctx);
            float initialTotalWidth = this.getTableWidth(columnWidths, 0.0f);
            float targetWidth = 0.0f;
            HtmlPipelineContext htmlPipelineContext = this.getHtmlPipelineContext(ctx);
            float max = htmlPipelineContext.getPageSize().getWidth() - outerWidth;
            boolean tableWidthFixed = false;
            if (tag.getAttributes().get("width") != null || tag.getCSS().get("width") != null) {
                targetWidth = new WidthCalculator().getWidth(tag, htmlPipelineContext.getRootTags(), htmlPipelineContext.getPageSize().getWidth(), initialTotalWidth);
                if (targetWidth > max) {
                    targetWidth = max;
                }
                tableWidthFixed = true;
            } else {
                targetWidth = initialTotalWidth <= max ? initialTotalWidth : (null == tag.getParent() || null != tag.getParent() && htmlPipelineContext.getRootTags().contains(tag.getParent().getName()) ? max : this.getTableWidth(columnWidths, outerWidth));
            }
            float totalFixedColumnWidth = this.getTableWidth(fixedWidths, 0.0f);
            float targetPercentage = 0.0f;
            if (totalFixedColumnWidth == initialTotalWidth) {
                targetPercentage = targetWidth / initialTotalWidth;
                if (initialTotalWidth > targetWidth) {
                    column = 0;
                    while (column < columnWidths.length) {
                        int n = column++;
                        columnWidths[n] = columnWidths[n] * targetPercentage;
                    }
                } else if (tableWidthFixed && targetPercentage != 1.0f) {
                    column = 0;
                    while (column < columnWidths.length) {
                        int n = column++;
                        columnWidths[n] = columnWidths[n] * targetPercentage;
                    }
                }
            } else {
                targetPercentage = (targetWidth - totalFixedColumnWidth) / (initialTotalWidth - totalFixedColumnWidth);
                if (initialTotalWidth > targetWidth) {
                    int column4;
                    float leftToReduce = 0.0f;
                    for (column4 = 0; column4 < columnWidths.length; ++column4) {
                        if (fixedWidths[column4] == 0.0f) {
                            if (widestWords[column4] <= columnWidths[column4] * targetPercentage) {
                                int n = column4;
                                columnWidths[n] = columnWidths[n] * targetPercentage;
                                continue;
                            }
                            columnWidths[column4] = widestWords[column4];
                            leftToReduce += widestWords[column4] - columnWidths[column4] * targetPercentage;
                            continue;
                        }
                        if (!(fixedWidths[column4] < widestWords[column4])) continue;
                        columnWidths[column4] = widestWords[column4];
                        leftToReduce += widestWords[column4] - fixedWidths[column4];
                    }
                    if (leftToReduce != 0.0f) {
                        if (widestWords[indexOfLargestColumn] <= columnWidths[indexOfLargestColumn] - leftToReduce) {
                            int n = indexOfLargestColumn;
                            columnWidths[n] = columnWidths[n] - leftToReduce;
                        } else {
                            for (column4 = 0; leftToReduce != 0.0f && column4 < columnWidths.length; ++column4) {
                                if (fixedWidths[column4] != 0.0f || !(columnWidths[column4] > widestWords[column4])) continue;
                                float difference = columnWidths[column4] - widestWords[column4];
                                if (difference <= leftToReduce) {
                                    leftToReduce -= difference;
                                    columnWidths[column4] = widestWords[column4];
                                    continue;
                                }
                                int n = column4;
                                columnWidths[n] = columnWidths[n] - leftToReduce;
                                leftToReduce = 0.0f;
                            }
                            if (leftToReduce != 0.0f) {
                                float pageWidth = this.getHtmlPipelineContext(ctx).getPageSize().getWidth();
                                if (this.getTableWidth(widestWords, outerWidth) < pageWidth) {
                                    targetWidth = this.getTableWidth(widestWords, outerWidth);
                                    leftToReduce = 0.0f;
                                } else {
                                    targetWidth = pageWidth - outerWidth;
                                    leftToReduce = 0.0f;
                                }
                            }
                        }
                    }
                } else if (initialTotalWidth < targetWidth) {
                    for (column = 0; column < columnWidths.length; ++column) {
                        if (fixedWidths[column] != 0.0f) continue;
                        int n = column;
                        columnWidths[n] = columnWidths[n] * targetPercentage;
                    }
                }
            }
            try {
                table.setTotalWidth(columnWidths);
                table.setLockedWidth(true);
                table.getDefaultCell().setBorder(0);
            }
            catch (DocumentException e) {
                throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
            }
            Float tableHeight = new HeightCalculator().getHeight(tag, this.getHtmlPipelineContext(ctx).getPageSize().getHeight());
            Float tableRowHeight = null;
            if (tableHeight != null && tableHeight.floatValue() > 0.0f) {
                tableRowHeight = Float.valueOf(tableHeight.floatValue() / (float)tableRows.size());
            }
            int rowNumber = 0;
            for (TableRowElement row : tableRows) {
                int columnNumber = -1;
                Float computedRowHeight = null;
                List<HtmlCell> rowContent = row.getContent();
                if (rowContent.size() < 1) continue;
                for (HtmlCell cell : rowContent) {
                    List<Element> compositeElements = cell.getCompositeElements();
                    if (compositeElements != null) {
                        for (Element baseLevel : compositeElements) {
                            if (!(baseLevel instanceof PdfPTable)) continue;
                            TableStyleValues cellValues = cell.getCellValues();
                            float totalBordersWidth = cellValues.isLastInRow() ? styleValues.getHorBorderSpacing() * 2.0f : styleValues.getHorBorderSpacing();
                            totalBordersWidth += cellValues.getBorderWidthLeft() + cellValues.getBorderWidthRight();
                            float columnWidth = 0.0f;
                            for (int currentColumnNumber = columnNumber + 1; currentColumnNumber <= columnNumber + cell.getColspan(); ++currentColumnNumber) {
                                columnWidth += columnWidths[currentColumnNumber];
                            }
                            PdfPTableEvent tableEvent = ((PdfPTable)baseLevel).getTableEvent();
                            TableStyleValues innerStyleValues = ((TableBorderEvent)tableEvent).getTableStyleValues();
                            totalBordersWidth += innerStyleValues.getBorderWidthLeft();
                            ((PdfPTable)baseLevel).setTotalWidth(columnWidth - (totalBordersWidth += innerStyleValues.getBorderWidthRight()));
                        }
                    }
                    columnNumber += cell.getColspan();
                    table.addCell(cell);
                }
                table.completeRow();
                if ((computedRowHeight == null || computedRowHeight.floatValue() <= 0.0f) && tableRowHeight != null) {
                    computedRowHeight = tableRowHeight;
                }
                if (computedRowHeight != null && computedRowHeight.floatValue() > 0.0f) {
                    float rowHeight = table.getRow(rowNumber).getMaxHeights();
                    if (rowHeight < computedRowHeight.floatValue()) {
                        table.getRow(rowNumber).setMaxHeights(computedRowHeight.floatValue());
                    } else if (tableRowHeight != null && tableRowHeight.floatValue() < rowHeight) {
                        tableRowHeight = Float.valueOf((tableHeight.floatValue() - rowHeight - (float)rowNumber * tableRowHeight.floatValue()) / (float)(tableRows.size() - rowNumber - 1));
                    }
                }
                ++rowNumber;
            }
            if (percentage) {
                table.setWidthPercentage(utils.parsePxInCmMmPcToPt(widthValue));
                table.setLockedWidth(false);
            }
            ArrayList<Element> elems = new ArrayList<Element>();
            if (invalidRowElements.size() > 0) {
                int i3 = 0;
                Tag captionTag = tag.getChildren().get(i3++);
                while (!captionTag.getName().equalsIgnoreCase("caption") && i3 < tag.getChildren().size()) {
                    captionTag = tag.getChildren().get(i3);
                    ++i3;
                }
                String captionSideValue = captionTag.getCSS().get("caption-side");
                if (captionSideValue != null && captionSideValue.equalsIgnoreCase("bottom")) {
                    elems.add(table);
                    elems.addAll(invalidRowElements);
                } else {
                    elems.addAll(invalidRowElements);
                    elems.add(table);
                }
            } else {
                elems.add(table);
            }
            return elems;
        }
        catch (NoCustomContextException e) {
            throw new RuntimeWorkerException(LocaleMessages.getInstance().getMessage("customcontext.404"), e);
        }
    }

    protected PdfPTable intPdfPTable(int numberOfColumn) {
        PdfPTable table = new PdfPTable(numberOfColumn);
        table.setHorizontalAlignment(0);
        table.setSplitLate(false);
        return table;
    }

    private float calculateTargetWidth(Tag tag, float[] columnWidths, float outerWidth, WorkerContext ctx) throws NoCustomContextException {
        float targetWidth = 0.0f;
        HtmlPipelineContext htmlPipelineContext = this.getHtmlPipelineContext(ctx);
        float max = htmlPipelineContext.getPageSize().getWidth() - outerWidth;
        float start = this.getTableWidth(columnWidths, 0.0f);
        if (tag.getAttributes().get("width") != null || tag.getCSS().get("width") != null) {
            targetWidth = new WidthCalculator().getWidth(tag, htmlPipelineContext.getRootTags(), htmlPipelineContext.getPageSize().getWidth());
            if (targetWidth > max) {
                targetWidth = max;
            }
        } else {
            targetWidth = start <= max ? start : (null == tag.getParent() || null != tag.getParent() && htmlPipelineContext.getRootTags().contains(tag.getParent().getName()) ? max : this.getTableWidth(columnWidths, outerWidth));
        }
        return targetWidth;
    }

    private void widenLastCell(List<TableRowElement> tableRows, float horBorderSpacing) {
        for (TableRowElement row : tableRows) {
            List<HtmlCell> cells = row.getContent();
            if (cells.size() < 1) continue;
            HtmlCell last = cells.get(cells.size() - 1);
            last.getCellValues().setLastInRow(true);
            last.setPaddingRight(last.getPaddingRight() + horBorderSpacing);
        }
    }

    public static TableStyleValues setStyleValues(Tag tag) {
        TableStyleValues styleValues = new TableStyleValues();
        Map<String, String> css = tag.getCSS();
        Map<String, String> attributes = tag.getAttributes();
        if (attributes.containsKey("border")) {
            styleValues.setBorderColor(BaseColor.BLACK);
            String borderValue = attributes.get("border");
            if ("".equals(borderValue)) {
                styleValues.setBorderWidth(0.75f);
            } else {
                styleValues.setBorderWidth(utils.parsePxInCmMmPcToPt(borderValue));
            }
        } else {
            Float width;
            for (Map.Entry<String, String> entry : css.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key.equalsIgnoreCase("border-left-style") && "solid".equalsIgnoreCase(value)) {
                    styleValues.setBorderColorLeft(BaseColor.BLACK);
                    styleValues.setBorderWidthLeft(0.75f);
                    continue;
                }
                if (key.equalsIgnoreCase("border-right-style") && "solid".equalsIgnoreCase(value)) {
                    styleValues.setBorderColorRight(BaseColor.BLACK);
                    styleValues.setBorderWidthRight(0.75f);
                    continue;
                }
                if (key.equalsIgnoreCase("border-top-style") && "solid".equalsIgnoreCase(value)) {
                    styleValues.setBorderColorTop(BaseColor.BLACK);
                    styleValues.setBorderWidthTop(0.75f);
                    continue;
                }
                if (!key.equalsIgnoreCase("border-bottom-style") || !"solid".equalsIgnoreCase(value)) continue;
                styleValues.setBorderColorBottom(BaseColor.BLACK);
                styleValues.setBorderWidthBottom(0.75f);
            }
            String color = css.get("border-bottom-color");
            if (color != null) {
                styleValues.setBorderColorBottom(HtmlUtilities.decodeColor(color));
            }
            if ((color = css.get("border-top-color")) != null) {
                styleValues.setBorderColorTop(HtmlUtilities.decodeColor(color));
            }
            if ((color = css.get("border-left-color")) != null) {
                styleValues.setBorderColorLeft(HtmlUtilities.decodeColor(color));
            }
            if ((color = css.get("border-right-color")) != null) {
                styleValues.setBorderColorRight(HtmlUtilities.decodeColor(color));
            }
            if ((width = utils.checkMetricStyle(css, "border-bottom-width")) != null) {
                styleValues.setBorderWidthBottom(width.floatValue());
            }
            if ((width = utils.checkMetricStyle(css, "border-top-width")) != null) {
                styleValues.setBorderWidthTop(width.floatValue());
            }
            if ((width = utils.checkMetricStyle(css, "border-right-width")) != null) {
                styleValues.setBorderWidthRight(width.floatValue());
            }
            if ((width = utils.checkMetricStyle(css, "border-left-width")) != null) {
                styleValues.setBorderWidthLeft(width.floatValue());
            }
        }
        styleValues.setBackground(HtmlUtilities.decodeColor(css.get("background-color")));
        styleValues.setHorBorderSpacing(Table.getBorderOrCellSpacing(true, css, attributes));
        styleValues.setVerBorderSpacing(Table.getBorderOrCellSpacing(false, css, attributes));
        return styleValues;
    }

    public static TableStyleValues setBorderAttributeForCell(Tag tag) {
        TableStyleValues styleValues = new TableStyleValues();
        if (tag == null) {
            return styleValues;
        }
        Map<String, String> attributes = tag.getAttributes();
        Map<String, String> css = tag.getCSS();
        String border = attributes.get("border");
        if (border != null && (border.trim().length() == 0 || utils.parsePxInCmMmPcToPt(attributes.get("border")) > 0.0f)) {
            styleValues.setBorderColor(BaseColor.BLACK);
            styleValues.setBorderWidth(0.75f);
        }
        styleValues.setHorBorderSpacing(Table.getBorderOrCellSpacing(true, css, attributes));
        styleValues.setVerBorderSpacing(Table.getBorderOrCellSpacing(false, css, attributes));
        return styleValues;
    }

    public static float getBorderOrCellSpacing(boolean getHor, Map<String, String> css, Map<String, String> attributes) {
        float spacing = 0.0f;
        String collapse = css.get("border-collapse");
        if (collapse == null || collapse.equals("separate")) {
            String borderSpacing = css.get("border-spacing");
            String cellSpacing = attributes.get("cellspacing");
            spacing = borderSpacing != null ? (borderSpacing.contains(" ") ? (getHor ? utils.parsePxInCmMmPcToPt(borderSpacing.split(" ")[0]) : utils.parsePxInCmMmPcToPt(borderSpacing.split(" ")[1])) : utils.parsePxInCmMmPcToPt(borderSpacing)) : (cellSpacing != null ? utils.parsePxInCmMmPcToPt(cellSpacing) : 1.5f);
        } else if (collapse.equals("collapse")) {
            spacing = 0.0f;
        }
        return spacing;
    }

    private float[] setCellWidthAndWidestWord(HtmlCell cell) {
        float cellWidth;
        ArrayList<Float> rulesWidth = new ArrayList<Float>();
        float widestWordOfCell = 0.0f;
        float startWidth = this.getCellStartWidth(cell);
        float widthDeviation = 0.001f;
        List<Element> compositeElements = cell.getCompositeElements();
        if (compositeElements != null) {
            for (Element baseLevel : compositeElements) {
                float divActualWidth;
                cellWidth = Float.NaN;
                if (baseLevel instanceof Phrase) {
                    for (int i2 = 0; i2 < ((Phrase)baseLevel).size(); ++i2) {
                        Element inner = (Element)((Phrase)baseLevel).get(i2);
                        if (!(inner instanceof Chunk)) continue;
                        if (Float.isNaN(cellWidth)) {
                            cellWidth = startWidth + widthDeviation;
                        }
                        cellWidth += ((Chunk)inner).getWidthPoint();
                        float widestWord = startWidth + widthDeviation + this.getCssAppliers().getChunkCssAplier().getWidestWord((Chunk)inner);
                        if (!(widestWord > widestWordOfCell)) continue;
                        widestWordOfCell = widestWord;
                    }
                    if (Float.isNaN(cellWidth)) continue;
                    rulesWidth.add(Float.valueOf(cellWidth));
                    continue;
                }
                if (baseLevel instanceof com.itextpdf.text.List) {
                    for (Element li : ((com.itextpdf.text.List)baseLevel).getItems()) {
                        cellWidth = startWidth + widthDeviation + ((ListItem)li).getIndentationLeft();
                        for (Chunk c : li.getChunks()) {
                            cellWidth += c.getWidthPoint();
                            float widestWord = this.getCssAppliers().getChunkCssAplier().getWidestWord(c);
                            if (!(startWidth + widthDeviation + widestWord > widestWordOfCell)) continue;
                            widestWordOfCell = startWidth + widthDeviation + widestWord;
                        }
                        rulesWidth.add(Float.valueOf(cellWidth));
                    }
                    continue;
                }
                if (baseLevel instanceof PdfPTable) {
                    cellWidth = startWidth + widthDeviation + ((PdfPTable)baseLevel).getTotalWidth();
                    for (PdfPRow innerRow : ((PdfPTable)baseLevel).getRows()) {
                        int size = innerRow.getCells().length;
                        TableBorderEvent event = (TableBorderEvent)((PdfPTable)baseLevel).getTableEvent();
                        TableStyleValues values = event.getTableStyleValues();
                        float minRowWidth = values.getBorderWidthLeft() + (float)(size + 1) * values.getHorBorderSpacing() + values.getBorderWidthRight();
                        int celnr = 0;
                        for (PdfPCell innerCell : innerRow.getCells()) {
                            ++celnr;
                            if (innerCell == null) continue;
                            float innerWidestWordOfCell = this.setCellWidthAndWidestWord(new HtmlCell(innerCell, celnr == size))[1];
                            minRowWidth += innerWidestWordOfCell;
                        }
                        if (!(minRowWidth > widestWordOfCell)) continue;
                        widestWordOfCell = minRowWidth;
                    }
                    rulesWidth.add(Float.valueOf(cellWidth));
                    continue;
                }
                if (!(baseLevel instanceof PdfDiv)) continue;
                PdfDiv div = (PdfDiv)baseLevel;
                if (div.getWidth() != null) {
                    divActualWidth = div.getWidth().floatValue();
                } else {
                    ArrayList<Element> divContent = div.getContent();
                    divActualWidth = this.calculateDivWidestElementWidth(divContent);
                }
                cellWidth = startWidth + widthDeviation + divActualWidth;
                rulesWidth.add(Float.valueOf(cellWidth));
            }
        }
        cellWidth = startWidth;
        for (Float width : rulesWidth) {
            if (!(width.floatValue() > cellWidth)) continue;
            cellWidth = width.floatValue();
        }
        return new float[]{cellWidth, widestWordOfCell};
    }

    private float calculateDivWidestElementWidth(ArrayList<Element> divContent) {
        float maxWidth = 0.0f;
        for (Element element : divContent) {
            float width = 0.0f;
            if (element instanceof PdfDiv) {
                width = this.calculateDivWidestElementWidth(((PdfDiv)element).getContent());
            } else if (element instanceof PdfPTable) {
                width = ((PdfPTable)element).getTotalWidth();
            } else if (element instanceof Paragraph) {
                Paragraph p2 = (Paragraph)element;
                float widestWordOfParagraph = 0.0f;
                for (Element inner : p2) {
                    float widestWord = 0.0f;
                    if (inner instanceof Chunk) {
                        HashMap<String, Object> chunkAttributes = ((Chunk)inner).getAttributes();
                        if (chunkAttributes != null && chunkAttributes.containsKey("IMAGE")) {
                            Object o = chunkAttributes.get("IMAGE");
                            if (o instanceof Object[] && ((Object[])o)[0] instanceof Image) {
                                widestWord = ((Image)((Object[])o)[0]).getWidth();
                            }
                        } else {
                            widestWord = this.getCssAppliers().getChunkCssAplier().getWidestWord((Chunk)inner);
                        }
                    }
                    if (!(widestWord > widestWordOfParagraph)) continue;
                    widestWordOfParagraph = widestWord;
                }
                width = widestWordOfParagraph;
            }
            if (!(width > maxWidth)) continue;
            maxWidth = width;
        }
        return maxWidth;
    }

    private float getTableWidth(float[] widths, float outerWidth) throws NoCustomContextException {
        float width = 0.0f;
        for (float f : widths) {
            width += f;
        }
        return width + outerWidth;
    }

    private float getTableOuterWidth(Tag tag, float horBorderSpacing, WorkerContext ctx) throws NoCustomContextException {
        float total = utils.getLeftAndRightMargin(tag, this.getHtmlPipelineContext(ctx).getPageSize().getWidth()) + utils.checkMetricStyle(tag, "border-left-width") + utils.checkMetricStyle(tag, "border-right-width") + horBorderSpacing;
        Tag parent = tag.getParent();
        if (parent != null) {
            total += utils.getLeftAndRightMargin(parent, this.getHtmlPipelineContext(ctx).getPageSize().getWidth());
        }
        return total;
    }

    private float getCellStartWidth(HtmlCell cell) {
        TableStyleValues cellStyleValues = cell.getCellValues();
        int spacingMultiplier = cell.getColspan() - 1;
        float spacing = (float)spacingMultiplier * cellStyleValues.getHorBorderSpacing();
        return spacing + cell.getPaddingLeft() + cell.getPaddingRight();
    }

    private void setVerticalMargin(PdfPTable table, Tag t, TableStyleValues values, WorkerContext ctx) throws NoCustomContextException {
        float spacingBefore = values.getBorderWidthTop();
        float spacingAfter = values.getVerBorderSpacing() + values.getBorderWidthBottom();
        for (Map.Entry<String, String> css : t.getCSS().entrySet()) {
            String key = css.getKey();
            String value = css.getValue();
            if ("margin-top".equalsIgnoreCase(key)) {
                CssUtils utils = CssUtils.getInstance();
                spacingBefore += utils.calculateMarginTop(value, fst.getFontSize(t), this.getHtmlPipelineContext(ctx));
                continue;
            }
            if ("margin-bottom".equalsIgnoreCase(key)) {
                float marginBottom = utils.parseValueToPt(value, fst.getFontSize(t));
                spacingAfter += marginBottom;
                this.getHtmlPipelineContext(ctx).getMemory().put("lastMarginBottom", Float.valueOf(marginBottom));
                continue;
            }
            if (!"padding-top".equalsIgnoreCase(key)) continue;
            table.setPaddingTop(utils.parseValueToPt(value, fst.getFontSize(t)));
        }
        table.setSpacingBefore(spacingBefore);
        table.setSpacingAfter(spacingAfter);
    }

    @Override
    public boolean isStackOwner() {
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class RepeatedRowComparator
    implements Comparator<TableRowElement> {
        private RepeatedRowComparator() {
        }

        @Override
        public int compare(TableRowElement o1, TableRowElement o2) {
            return o1.getPlace().getRepeated().compareTo(o2.getPlace().getRepeated());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class NormalRowComparator
    implements Comparator<TableRowElement> {
        private NormalRowComparator() {
        }

        @Override
        public int compare(TableRowElement o1, TableRowElement o2) {
            return o1.getPlace().getNormal().compareTo(o2.getPlace().getNormal());
        }
    }
}

