/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.CJKFont;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.EnumerateTTC;
import com.lowagie.text.pdf.GlyphList;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStream;
import com.lowagie.text.pdf.PdfWriter;
import com.lowagie.text.pdf.TrueTypeFont;
import com.lowagie.text.pdf.TrueTypeFontUnicode;
import com.lowagie.text.pdf.Type1Font;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public abstract class BaseFont {
    public static final String COURIER = "Courier";
    public static final String COURIER_BOLD = "Courier-Bold";
    public static final String COURIER_OBLIQUE = "Courier-Oblique";
    public static final String COURIER_BOLDOBLIQUE = "Courier-BoldOblique";
    public static final String HELVETICA = "Helvetica";
    public static final String HELVETICA_BOLD = "Helvetica-Bold";
    public static final String HELVETICA_OBLIQUE = "Helvetica-Oblique";
    public static final String HELVETICA_BOLDOBLIQUE = "Helvetica-BoldOblique";
    public static final String SYMBOL = "Symbol";
    public static final String TIMES_ROMAN = "Times-Roman";
    public static final String TIMES_BOLD = "Times-Bold";
    public static final String TIMES_ITALIC = "Times-Italic";
    public static final String TIMES_BOLDITALIC = "Times-BoldItalic";
    public static final String ZAPFDINGBATS = "ZapfDingbats";
    public static final int ASCENT = 1;
    public static final int CAPHEIGHT = 2;
    public static final int DESCENT = 3;
    public static final int ITALICANGLE = 4;
    public static final int BBOXLLX = 5;
    public static final int BBOXLLY = 6;
    public static final int BBOXURX = 7;
    public static final int BBOXURY = 8;
    public static final int AWT_ASCENT = 9;
    public static final int AWT_DESCENT = 10;
    public static final int AWT_LEADING = 11;
    public static final int AWT_MAXADVANCE = 12;
    public static final int UNDERLINE_POSITION = 13;
    public static final int UNDERLINE_THICKNESS = 14;
    public static final int STRIKETHROUGH_POSITION = 15;
    public static final int STRIKETHROUGH_THICKNESS = 16;
    public static final int SUBSCRIPT_SIZE = 17;
    public static final int SUBSCRIPT_OFFSET = 18;
    public static final int SUPERSCRIPT_SIZE = 19;
    public static final int SUPERSCRIPT_OFFSET = 20;
    public static final int FONT_TYPE_T1 = 0;
    public static final int FONT_TYPE_TT = 1;
    public static final int FONT_TYPE_CJK = 2;
    public static final int FONT_TYPE_TTUNI = 3;
    public static final int FONT_TYPE_DOCUMENT = 4;
    public static final int FONT_TYPE_T3 = 5;
    public static final String IDENTITY_H = "Identity-H";
    public static final String IDENTITY_V = "Identity-V";
    public static final String CP1250 = "Cp1250";
    public static final String CP1252 = "Cp1252";
    public static final String CP1257 = "Cp1257";
    public static final String WINANSI = "Cp1252";
    public static final String MACROMAN = "MacRoman";
    public static final int[] CHAR_RANGE_LATIN = new int[]{0, 383, 8192, 8303, 8352, 8399, 64256, 64262};
    public static final int[] CHAR_RANGE_ARABIC = new int[]{0, 127, 1536, 1663, 8352, 8399, 64336, 64511, 65136, 65279};
    public static final int[] CHAR_RANGE_HEBREW = new int[]{0, 127, 1424, 1535, 8352, 8399, 64285, 64335};
    public static final int[] CHAR_RANGE_CYRILLIC = new int[]{0, 127, 1024, 1327, 8192, 8303, 8352, 8399};
    public static final boolean EMBEDDED = true;
    public static final boolean NOT_EMBEDDED = false;
    public static final boolean CACHED = true;
    public static final boolean NOT_CACHED = false;
    public static final String RESOURCE_PATH = "com/lowagie/text/pdf/fonts/";
    public static final char CID_NEWLINE = Short.MAX_VALUE;
    protected ArrayList subsetRanges;
    int fontType;
    public static final String notdef = ".notdef";
    protected int[] widths = new int[256];
    protected String[] differences = new String[256];
    protected char[] unicodeDifferences = new char[256];
    protected int[][] charBBoxes = new int[256][];
    protected String encoding;
    protected boolean embedded;
    protected int compressionLevel = -1;
    protected boolean fontSpecific = true;
    protected static HashMap fontCache = new HashMap();
    protected static final HashMap BuiltinFonts14 = new HashMap();
    protected boolean forceWidthsOutput = false;
    protected boolean directTextToByte = false;
    protected boolean subset = true;
    protected boolean fastWinansi = false;
    protected IntHashtable specialMap;

    protected BaseFont() {
    }

    public static BaseFont createFont() throws DocumentException, IOException {
        return BaseFont.createFont(HELVETICA, "Cp1252", false);
    }

    public static BaseFont createFont(String string, String string2, boolean bl) throws DocumentException, IOException {
        return BaseFont.createFont(string, string2, bl, true, null, null, false);
    }

    public static BaseFont createFont(String string, String string2, boolean bl, boolean bl2) throws DocumentException, IOException {
        return BaseFont.createFont(string, string2, bl, true, null, null, bl2);
    }

    public static BaseFont createFont(String string, String string2, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2) throws DocumentException, IOException {
        return BaseFont.createFont(string, string2, bl, bl2, byArray, byArray2, false);
    }

    public static BaseFont createFont(String string, String string2, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2, boolean bl3) throws DocumentException, IOException {
        return BaseFont.createFont(string, string2, bl, bl2, byArray, byArray2, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseFont createFont(String string, String string2, boolean bl, boolean bl2, byte[] byArray, byte[] byArray2, boolean bl3, boolean bl4) throws DocumentException, IOException {
        HashMap hashMap;
        boolean bl5;
        String string3 = BaseFont.getBaseName(string);
        string2 = BaseFont.normalizeEncoding(string2);
        boolean bl6 = BuiltinFonts14.containsKey(string);
        boolean bl7 = bl5 = bl6 ? false : CJKFont.isCJKFont(string3, string2);
        if (bl6 || bl5) {
            bl = false;
        } else if (string2.equals(IDENTITY_H) || string2.equals(IDENTITY_V)) {
            bl = true;
        }
        BaseFont baseFont = null;
        BaseFont baseFont2 = null;
        String string4 = string + "\n" + string2 + "\n" + bl;
        if (bl2) {
            hashMap = fontCache;
            synchronized (hashMap) {
                baseFont = (BaseFont)fontCache.get(string4);
            }
            if (baseFont != null) {
                return baseFont;
            }
        }
        if (bl6 || string.toLowerCase().endsWith(".afm") || string.toLowerCase().endsWith(".pfm")) {
            baseFont2 = new Type1Font(string, string2, bl, byArray, byArray2, bl4);
            baseFont2.fastWinansi = string2.equals("Cp1252");
        } else if (string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0) {
            if (string2.equals(IDENTITY_H) || string2.equals(IDENTITY_V)) {
                baseFont2 = new TrueTypeFontUnicode(string, string2, bl, byArray, bl4);
            } else {
                baseFont2 = new TrueTypeFont(string, string2, bl, byArray, false, bl4);
                baseFont2.fastWinansi = string2.equals("Cp1252");
            }
        } else if (bl5) {
            baseFont2 = new CJKFont(string, string2, bl);
        } else {
            if (bl3) {
                return null;
            }
            throw new DocumentException("Font '" + string + "' with '" + string2 + "' is not recognized.");
        }
        if (bl2) {
            hashMap = fontCache;
            synchronized (hashMap) {
                baseFont = (BaseFont)fontCache.get(string4);
                if (baseFont != null) {
                    return baseFont;
                }
                fontCache.put(string4, baseFont2);
            }
        }
        return baseFont2;
    }

    public static BaseFont createFont(PRIndirectReference pRIndirectReference) {
        return new DocumentFont(pRIndirectReference);
    }

    protected static String getBaseName(String string) {
        if (string.endsWith(",Bold")) {
            return string.substring(0, string.length() - 5);
        }
        if (string.endsWith(",Italic")) {
            return string.substring(0, string.length() - 7);
        }
        if (string.endsWith(",BoldItalic")) {
            return string.substring(0, string.length() - 11);
        }
        return string;
    }

    protected static String normalizeEncoding(String string) {
        if (string.equals("winansi") || string.equals("")) {
            return "Cp1252";
        }
        if (string.equals("macroman")) {
            return MACROMAN;
        }
        return string;
    }

    protected void createEncoding() {
        if (this.encoding.startsWith("#")) {
            int n;
            String string;
            this.specialMap = new IntHashtable();
            StringTokenizer stringTokenizer = new StringTokenizer(this.encoding.substring(1), " ,\t\n\r\f");
            if (stringTokenizer.nextToken().equals("full")) {
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    string = stringTokenizer.nextToken();
                    n = Integer.parseInt(stringTokenizer.nextToken(), 16);
                    int n2 = string2.startsWith("'") ? (int)string2.charAt(1) : Integer.parseInt(string2);
                    this.specialMap.put(n, n2 %= 256);
                    this.differences[n2] = string;
                    this.unicodeDifferences[n2] = n;
                    this.widths[n2] = this.getRawWidth(n, string);
                    this.charBBoxes[n2] = this.getRawCharBBox(n, string);
                }
            } else {
                int n3 = 0;
                if (stringTokenizer.hasMoreTokens()) {
                    n3 = Integer.parseInt(stringTokenizer.nextToken());
                }
                while (stringTokenizer.hasMoreTokens() && n3 < 256) {
                    string = stringTokenizer.nextToken();
                    n = Integer.parseInt(string, 16) % 65536;
                    String string3 = GlyphList.unicodeToName(n);
                    if (string3 == null) continue;
                    this.specialMap.put(n, n3);
                    this.differences[n3] = string3;
                    this.unicodeDifferences[n3] = (char)n;
                    this.widths[n3] = this.getRawWidth(n, string3);
                    this.charBBoxes[n3] = this.getRawCharBBox(n, string3);
                    ++n3;
                }
            }
            for (int j = 0; j < 256; ++j) {
                if (this.differences[j] != null) continue;
                this.differences[j] = notdef;
            }
        } else if (this.fontSpecific) {
            for (int j = 0; j < 256; ++j) {
                this.widths[j] = this.getRawWidth(j, null);
                this.charBBoxes[j] = this.getRawCharBBox(j, null);
            }
        } else {
            byte[] byArray = new byte[1];
            for (int j = 0; j < 256; ++j) {
                byArray[0] = (byte)j;
                String string = PdfEncodings.convertToString(byArray, this.encoding);
                int n = string.length() > 0 ? (int)string.charAt(0) : 63;
                String string4 = GlyphList.unicodeToName(n);
                if (string4 == null) {
                    string4 = notdef;
                }
                this.differences[j] = string4;
                this.unicodeDifferences[j] = n;
                this.widths[j] = this.getRawWidth(n, string4);
                this.charBBoxes[j] = this.getRawCharBBox(n, string4);
            }
        }
    }

    abstract int getRawWidth(int var1, String var2);

    public abstract int getKerning(int var1, int var2);

    public abstract boolean setKerning(int var1, int var2, int var3);

    public int getWidth(int n) {
        if (this.fastWinansi) {
            if (n < 128 || n >= 160 && n <= 255) {
                return this.widths[n];
            }
            return this.widths[PdfEncodings.winansi.get(n)];
        }
        int n2 = 0;
        byte[] byArray = this.convertToBytes((char)n);
        for (int j = 0; j < byArray.length; ++j) {
            n2 += this.widths[0xFF & byArray[j]];
        }
        return n2;
    }

    public int getWidth(String string) {
        int n = 0;
        if (this.fastWinansi) {
            int n2 = string.length();
            for (int j = 0; j < n2; ++j) {
                char c = string.charAt(j);
                if (c < '\u0080' || c >= '\u00a0' && c <= '\u00ff') {
                    n += this.widths[c];
                    continue;
                }
                n += this.widths[PdfEncodings.winansi.get(c)];
            }
            return n;
        }
        byte[] byArray = this.convertToBytes(string);
        for (int j = 0; j < byArray.length; ++j) {
            n += this.widths[0xFF & byArray[j]];
        }
        return n;
    }

    public int getDescent(String string) {
        int n = 0;
        char[] cArray = string.toCharArray();
        for (int j = 0; j < cArray.length; ++j) {
            int[] nArray = this.getCharBBox(cArray[j]);
            if (nArray == null || nArray[1] >= n) continue;
            n = nArray[1];
        }
        return n;
    }

    public int getAscent(String string) {
        int n = 0;
        char[] cArray = string.toCharArray();
        for (int j = 0; j < cArray.length; ++j) {
            int[] nArray = this.getCharBBox(cArray[j]);
            if (nArray == null || nArray[3] <= n) continue;
            n = nArray[3];
        }
        return n;
    }

    public float getDescentPoint(String string, float f) {
        return (float)this.getDescent(string) * 0.001f * f;
    }

    public float getAscentPoint(String string, float f) {
        return (float)this.getAscent(string) * 0.001f * f;
    }

    public float getWidthPointKerned(String string, float f) {
        float f2 = (float)this.getWidth(string) * 0.001f * f;
        if (!this.hasKernPairs()) {
            return f2;
        }
        int n = string.length() - 1;
        int n2 = 0;
        char[] cArray = string.toCharArray();
        for (int j = 0; j < n; ++j) {
            n2 += this.getKerning(cArray[j], cArray[j + 1]);
        }
        return f2 + (float)n2 * 0.001f * f;
    }

    public float getWidthPoint(String string, float f) {
        return (float)this.getWidth(string) * 0.001f * f;
    }

    public float getWidthPoint(int n, float f) {
        return (float)this.getWidth(n) * 0.001f * f;
    }

    byte[] convertToBytes(String string) {
        if (this.directTextToByte) {
            return PdfEncodings.convertToBytes(string, null);
        }
        if (this.specialMap != null) {
            byte[] byArray = new byte[string.length()];
            int n = 0;
            int n2 = string.length();
            for (int j = 0; j < n2; ++j) {
                char c = string.charAt(j);
                if (!this.specialMap.containsKey(c)) continue;
                byArray[n++] = (byte)this.specialMap.get(c);
            }
            if (n < n2) {
                byte[] byArray2 = new byte[n];
                System.arraycopy(byArray, 0, byArray2, 0, n);
                return byArray2;
            }
            return byArray;
        }
        return PdfEncodings.convertToBytes(string, this.encoding);
    }

    byte[] convertToBytes(int n) {
        if (this.directTextToByte) {
            return PdfEncodings.convertToBytes((char)n, null);
        }
        if (this.specialMap != null) {
            if (this.specialMap.containsKey(n)) {
                return new byte[]{(byte)this.specialMap.get(n)};
            }
            return new byte[0];
        }
        return PdfEncodings.convertToBytes((char)n, this.encoding);
    }

    abstract void writeFont(PdfWriter var1, PdfIndirectReference var2, Object[] var3) throws DocumentException, IOException;

    abstract PdfStream getFullFontStream() throws IOException, DocumentException;

    public String getEncoding() {
        return this.encoding;
    }

    public abstract float getFontDescriptor(int var1, float var2);

    public int getFontType() {
        return this.fontType;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public boolean isFontSpecific() {
        return this.fontSpecific;
    }

    public static String createSubsetPrefix() {
        String string = "";
        for (int j = 0; j < 6; ++j) {
            string = string + (char)(Math.random() * 26.0 + 65.0);
        }
        return string + "+";
    }

    char getUnicodeDifferences(int n) {
        return this.unicodeDifferences[n];
    }

    public abstract String getPostscriptFontName();

    public abstract void setPostscriptFontName(String var1);

    public abstract String[][] getFullFontName();

    public abstract String[][] getAllNameEntries();

    public static String[][] getFullFontName(String string, String string2, byte[] byArray) throws DocumentException, IOException {
        String string3 = BaseFont.getBaseName(string);
        BaseFont baseFont = null;
        baseFont = string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0 ? new TrueTypeFont(string, "Cp1252", false, byArray, true, false) : BaseFont.createFont(string, string2, false, false, byArray, null);
        return ((BaseFont)baseFont).getFullFontName();
    }

    public static Object[] getAllFontNames(String string, String string2, byte[] byArray) throws DocumentException, IOException {
        String string3 = BaseFont.getBaseName(string);
        BaseFont baseFont = null;
        baseFont = string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0 ? new TrueTypeFont(string, "Cp1252", false, byArray, true, false) : BaseFont.createFont(string, string2, false, false, byArray, null);
        return new Object[]{baseFont.getPostscriptFontName(), baseFont.getFamilyFontName(), baseFont.getFullFontName()};
    }

    public static String[][] getAllNameEntries(String string, String string2, byte[] byArray) throws DocumentException, IOException {
        String string3 = BaseFont.getBaseName(string);
        BaseFont baseFont = null;
        baseFont = string3.toLowerCase().endsWith(".ttf") || string3.toLowerCase().endsWith(".otf") || string3.toLowerCase().indexOf(".ttc,") > 0 ? new TrueTypeFont(string, "Cp1252", false, byArray, true, false) : BaseFont.createFont(string, string2, false, false, byArray, null);
        return ((BaseFont)baseFont).getAllNameEntries();
    }

    public abstract String[][] getFamilyFontName();

    public String[] getCodePagesSupported() {
        return new String[0];
    }

    public static String[] enumerateTTCNames(String string) throws DocumentException, IOException {
        return new EnumerateTTC(string).getNames();
    }

    public static String[] enumerateTTCNames(byte[] byArray) throws DocumentException, IOException {
        return new EnumerateTTC(byArray).getNames();
    }

    public int[] getWidths() {
        return this.widths;
    }

    public String[] getDifferences() {
        return this.differences;
    }

    public char[] getUnicodeDifferences() {
        return this.unicodeDifferences;
    }

    public boolean isForceWidthsOutput() {
        return this.forceWidthsOutput;
    }

    public void setForceWidthsOutput(boolean bl) {
        this.forceWidthsOutput = bl;
    }

    public boolean isDirectTextToByte() {
        return this.directTextToByte;
    }

    public void setDirectTextToByte(boolean bl) {
        this.directTextToByte = bl;
    }

    public boolean isSubset() {
        return this.subset;
    }

    public void setSubset(boolean bl) {
        this.subset = bl;
    }

    public static InputStream getResourceStream(String string) {
        return BaseFont.getResourceStream(string, null);
    }

    public static InputStream getResourceStream(String string, ClassLoader classLoader) {
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        InputStream inputStream = null;
        if (classLoader != null && (inputStream = classLoader.getResourceAsStream(string)) != null) {
            return inputStream;
        }
        try {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            if (classLoader2 != null) {
                inputStream = classLoader2.getResourceAsStream(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (inputStream == null) {
            inputStream = BaseFont.class.getResourceAsStream("/" + string);
        }
        if (inputStream == null) {
            inputStream = ClassLoader.getSystemResourceAsStream(string);
        }
        return inputStream;
    }

    public int getUnicodeEquivalent(int n) {
        return n;
    }

    public int getCidCode(int n) {
        return n;
    }

    public abstract boolean hasKernPairs();

    public boolean charExists(int n) {
        byte[] byArray = this.convertToBytes(n);
        return byArray.length > 0;
    }

    public boolean setCharAdvance(int n, int n2) {
        byte[] byArray = this.convertToBytes(n);
        if (byArray.length == 0) {
            return false;
        }
        this.widths[0xFF & byArray[0]] = n2;
        return true;
    }

    private static void addFont(PRIndirectReference pRIndirectReference, IntHashtable intHashtable, ArrayList arrayList) {
        PdfObject pdfObject = PdfReader.getPdfObject(pRIndirectReference);
        if (pdfObject == null || !pdfObject.isDictionary()) {
            return;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)pdfObject;
        PdfName pdfName = pdfDictionary.getAsName(PdfName.SUBTYPE);
        if (!PdfName.TYPE1.equals(pdfName) && !PdfName.TRUETYPE.equals(pdfName)) {
            return;
        }
        PdfName pdfName2 = pdfDictionary.getAsName(PdfName.BASEFONT);
        arrayList.add(new Object[]{PdfName.decodeName(pdfName2.toString()), pRIndirectReference});
        intHashtable.put(pRIndirectReference.getNumber(), 1);
    }

    private static void recourseFonts(PdfDictionary pdfDictionary, IntHashtable intHashtable, ArrayList arrayList, int n) {
        Object object;
        Object object2;
        if (++n > 50) {
            return;
        }
        PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(PdfName.RESOURCES);
        if (pdfDictionary2 == null) {
            return;
        }
        PdfDictionary pdfDictionary3 = pdfDictionary2.getAsDict(PdfName.FONT);
        if (pdfDictionary3 != null) {
            object2 = pdfDictionary3.getKeys().iterator();
            while (object2.hasNext()) {
                int n2;
                object = pdfDictionary3.get((PdfName)object2.next());
                if (object == null || !((PdfObject)object).isIndirect() || intHashtable.containsKey(n2 = ((PRIndirectReference)object).getNumber())) continue;
                BaseFont.addFont((PRIndirectReference)object, intHashtable, arrayList);
            }
        }
        if ((object2 = pdfDictionary2.getAsDict(PdfName.XOBJECT)) != null) {
            object = ((PdfDictionary)object2).getKeys().iterator();
            while (object.hasNext()) {
                BaseFont.recourseFonts(((PdfDictionary)object2).getAsDict((PdfName)object.next()), intHashtable, arrayList, n);
            }
        }
    }

    public static ArrayList getDocumentFonts(PdfReader pdfReader) {
        IntHashtable intHashtable = new IntHashtable();
        ArrayList arrayList = new ArrayList();
        int n = pdfReader.getNumberOfPages();
        for (int j = 1; j <= n; ++j) {
            BaseFont.recourseFonts(pdfReader.getPageN(j), intHashtable, arrayList, 1);
        }
        return arrayList;
    }

    public static ArrayList getDocumentFonts(PdfReader pdfReader, int n) {
        IntHashtable intHashtable = new IntHashtable();
        ArrayList arrayList = new ArrayList();
        BaseFont.recourseFonts(pdfReader.getPageN(n), intHashtable, arrayList, 1);
        return arrayList;
    }

    public int[] getCharBBox(int n) {
        byte[] byArray = this.convertToBytes(n);
        if (byArray.length == 0) {
            return null;
        }
        return this.charBBoxes[byArray[0] & 0xFF];
    }

    protected abstract int[] getRawCharBBox(int var1, String var2);

    public void correctArabicAdvance() {
        int n;
        for (n = 1611; n <= 1624; n = (int)((char)(n + 1))) {
            this.setCharAdvance(n, 0);
        }
        this.setCharAdvance(1648, 0);
        for (n = 1750; n <= 1756; n = (int)((char)(n + 1))) {
            this.setCharAdvance(n, 0);
        }
        for (n = 1759; n <= 1764; n = (int)((char)(n + 1))) {
            this.setCharAdvance(n, 0);
        }
        for (n = 1767; n <= 1768; n = (int)((char)(n + 1))) {
            this.setCharAdvance(n, 0);
        }
        for (n = 1770; n <= 1773; n = (int)((char)(n + 1))) {
            this.setCharAdvance(n, 0);
        }
    }

    public void addSubsetRange(int[] nArray) {
        if (this.subsetRanges == null) {
            this.subsetRanges = new ArrayList();
        }
        this.subsetRanges.add(nArray);
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public void setCompressionLevel(int n) {
        this.compressionLevel = n < 0 || n > 9 ? -1 : n;
    }

    static {
        BuiltinFonts14.put(COURIER, PdfName.COURIER);
        BuiltinFonts14.put(COURIER_BOLD, PdfName.COURIER_BOLD);
        BuiltinFonts14.put(COURIER_BOLDOBLIQUE, PdfName.COURIER_BOLDOBLIQUE);
        BuiltinFonts14.put(COURIER_OBLIQUE, PdfName.COURIER_OBLIQUE);
        BuiltinFonts14.put(HELVETICA, PdfName.HELVETICA);
        BuiltinFonts14.put(HELVETICA_BOLD, PdfName.HELVETICA_BOLD);
        BuiltinFonts14.put(HELVETICA_BOLDOBLIQUE, PdfName.HELVETICA_BOLDOBLIQUE);
        BuiltinFonts14.put(HELVETICA_OBLIQUE, PdfName.HELVETICA_OBLIQUE);
        BuiltinFonts14.put(SYMBOL, PdfName.SYMBOL);
        BuiltinFonts14.put(TIMES_ROMAN, PdfName.TIMES_ROMAN);
        BuiltinFonts14.put(TIMES_BOLD, PdfName.TIMES_BOLD);
        BuiltinFonts14.put(TIMES_BOLDITALIC, PdfName.TIMES_BOLDITALIC);
        BuiltinFonts14.put(TIMES_ITALIC, PdfName.TIMES_ITALIC);
        BuiltinFonts14.put(ZAPFDINGBATS, PdfName.ZAPFDINGBATS);
    }

    static class StreamFont
    extends PdfStream {
        public StreamFont(byte[] byArray, int[] nArray, int n) throws DocumentException {
            try {
                this.bytes = byArray;
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                for (int j = 0; j < nArray.length; ++j) {
                    this.put(new PdfName("Length" + (j + 1)), new PdfNumber(nArray[j]));
                }
                this.flateCompress(n);
            }
            catch (Exception exception) {
                throw new DocumentException(exception);
            }
        }

        public StreamFont(byte[] byArray, String string, int n) throws DocumentException {
            try {
                this.bytes = byArray;
                this.put(PdfName.LENGTH, new PdfNumber(this.bytes.length));
                if (string != null) {
                    this.put(PdfName.SUBTYPE, new PdfName(string));
                }
                this.flateCompress(n);
            }
            catch (Exception exception) {
                throw new DocumentException(exception);
            }
        }
    }
}

