/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.FontMapper;
import java.awt.Font;
import java.io.File;
import java.util.HashMap;

public class DefaultFontMapper
implements FontMapper {
    private HashMap aliases = new HashMap();
    private HashMap mapper = new HashMap();

    public BaseFont awtToPdf(Font font) {
        try {
            BaseFontParameters baseFontParameters = this.getBaseFontParameters(font.getFontName());
            if (baseFontParameters != null) {
                return BaseFont.createFont(baseFontParameters.fontName, baseFontParameters.encoding, baseFontParameters.embedded, baseFontParameters.cached, baseFontParameters.ttfAfm, baseFontParameters.pfb);
            }
            String string = null;
            String string2 = font.getName();
            string = string2.equalsIgnoreCase("DialogInput") || string2.equalsIgnoreCase("Monospaced") || string2.equalsIgnoreCase("Courier") ? (font.isItalic() ? (font.isBold() ? "Courier-BoldOblique" : "Courier-Oblique") : (font.isBold() ? "Courier-Bold" : "Courier")) : (string2.equalsIgnoreCase("Serif") || string2.equalsIgnoreCase("TimesRoman") ? (font.isItalic() ? (font.isBold() ? "Times-BoldItalic" : "Times-Italic") : (font.isBold() ? "Times-Bold" : "Times-Roman")) : (font.isItalic() ? (font.isBold() ? "Helvetica-BoldOblique" : "Helvetica-Oblique") : (font.isBold() ? "Helvetica-Bold" : "Helvetica")));
            return BaseFont.createFont(string, "Cp1252", false);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public Font pdfToAwt(BaseFont baseFont, int n) {
        String string;
        String[][] stringArray = baseFont.getFullFontName();
        if (stringArray.length == 1) {
            return new Font(stringArray[0][3], 0, n);
        }
        String string2 = null;
        String string3 = null;
        for (int j = 0; j < stringArray.length; ++j) {
            String[] stringArray2 = stringArray[j];
            if (stringArray2[0].equals("1") && stringArray2[1].equals("0")) {
                string2 = stringArray2[3];
                continue;
            }
            if (!stringArray2[2].equals("1033")) continue;
            string3 = stringArray2[3];
            break;
        }
        if ((string = string3) == null) {
            string = string2;
        }
        if (string == null) {
            string = stringArray[0][3];
        }
        return new Font(string, 0, n);
    }

    public void putName(String string, BaseFontParameters baseFontParameters) {
        this.mapper.put(string, baseFontParameters);
    }

    public void putAlias(String string, String string2) {
        this.aliases.put(string, string2);
    }

    public BaseFontParameters getBaseFontParameters(String string) {
        String string2 = (String)this.aliases.get(string);
        if (string2 == null) {
            return (BaseFontParameters)this.mapper.get(string);
        }
        BaseFontParameters baseFontParameters = (BaseFontParameters)this.mapper.get(string2);
        if (baseFontParameters == null) {
            return (BaseFontParameters)this.mapper.get(string);
        }
        return baseFontParameters;
    }

    public void insertNames(Object[] objectArray, String string) {
        String[][] stringArray = (String[][])objectArray[2];
        String string2 = null;
        for (int j = 0; j < stringArray.length; ++j) {
            String[] stringArray2 = stringArray[j];
            if (!stringArray2[2].equals("1033")) continue;
            string2 = stringArray2[3];
            break;
        }
        if (string2 == null) {
            string2 = stringArray[0][3];
        }
        BaseFontParameters baseFontParameters = new BaseFontParameters(string);
        this.mapper.put(string2, baseFontParameters);
        for (int j = 0; j < stringArray.length; ++j) {
            this.aliases.put(stringArray[j][3], string2);
        }
        this.aliases.put(objectArray[0], string2);
    }

    public int insertDirectory(String string) {
        File file = new File(string);
        if (!file.exists() || !file.isDirectory()) {
            return 0;
        }
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            return 0;
        }
        int n = 0;
        for (int j = 0; j < fileArray.length; ++j) {
            file = fileArray[j];
            String string2 = file.getPath().toLowerCase();
            try {
                Object[] objectArray;
                if (string2.endsWith(".ttf") || string2.endsWith(".otf") || string2.endsWith(".afm")) {
                    objectArray = BaseFont.getAllFontNames(file.getPath(), "Cp1252", null);
                    this.insertNames(objectArray, file.getPath());
                    ++n;
                    continue;
                }
                if (!string2.endsWith(".ttc")) continue;
                objectArray = BaseFont.enumerateTTCNames(file.getPath());
                for (int k = 0; k < objectArray.length; ++k) {
                    String string3 = file.getPath() + "," + k;
                    Object[] objectArray2 = BaseFont.getAllFontNames(string3, "Cp1252", null);
                    this.insertNames(objectArray2, string3);
                }
                ++n;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    public HashMap getMapper() {
        return this.mapper;
    }

    public HashMap getAliases() {
        return this.aliases;
    }

    public static class BaseFontParameters {
        public String fontName;
        public String encoding;
        public boolean embedded;
        public boolean cached;
        public byte[] ttfAfm;
        public byte[] pfb;

        public BaseFontParameters(String string) {
            this.fontName = string;
            this.encoding = "Cp1252";
            this.embedded = true;
            this.cached = true;
        }
    }
}

