/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.SplitCharacter;
import com.lowagie.text.Utilities;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.DefaultSplitCharacter;
import com.lowagie.text.pdf.HyphenationEvent;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfFont;
import java.awt.Color;
import java.util.HashMap;

public class PdfChunk {
    private static final char[] singleSpace = new char[]{' '};
    private static final PdfChunk[] thisChunk = new PdfChunk[1];
    private static final float ITALIC_ANGLE = 0.21256f;
    private static final HashMap keysAttributes = new HashMap();
    private static final HashMap keysNoStroke = new HashMap();
    protected String value = "";
    protected String encoding = "Cp1252";
    protected PdfFont font;
    protected BaseFont baseFont;
    protected SplitCharacter splitCharacter;
    protected HashMap attributes = new HashMap();
    protected HashMap noStroke = new HashMap();
    protected boolean newlineSplit;
    protected Image image;
    protected float offsetX;
    protected float offsetY;
    protected boolean changeLeading = false;

    PdfChunk(String string, PdfChunk pdfChunk) {
        PdfChunk.thisChunk[0] = this;
        this.value = string;
        this.font = pdfChunk.font;
        this.attributes = pdfChunk.attributes;
        this.noStroke = pdfChunk.noStroke;
        this.baseFont = pdfChunk.baseFont;
        Object[] objectArray = (Object[])this.attributes.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
            this.changeLeading = (Boolean)objectArray[3];
        }
        this.encoding = this.font.getFont().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = DefaultSplitCharacter.DEFAULT;
        }
    }

    PdfChunk(Chunk chunk, PdfAction pdfAction) {
        Object object;
        Object[] objectArray;
        PdfChunk.thisChunk[0] = this;
        this.value = chunk.getContent();
        Font font = chunk.getFont();
        float f = font.getSize();
        if (f == -1.0f) {
            f = 12.0f;
        }
        this.baseFont = font.getBaseFont();
        int n = font.getStyle();
        if (n == -1) {
            n = 0;
        }
        if (this.baseFont == null) {
            this.baseFont = font.getCalculatedBaseFont(false);
        } else {
            if ((n & 1) != 0) {
                this.attributes.put("TEXTRENDERMODE", new Object[]{new Integer(2), new Float(f / 30.0f), null});
            }
            if ((n & 2) != 0) {
                this.attributes.put("SKEW", new float[]{0.0f, 0.21256f});
            }
        }
        this.font = new PdfFont(this.baseFont, f);
        HashMap hashMap = chunk.getAttributes();
        if (hashMap != null) {
            objectArray = hashMap.entrySet().iterator();
            while (objectArray.hasNext()) {
                object = objectArray.next();
                Object k = object.getKey();
                if (keysAttributes.containsKey(k)) {
                    this.attributes.put(k, object.getValue());
                    continue;
                }
                if (!keysNoStroke.containsKey(k)) continue;
                this.noStroke.put(k, object.getValue());
            }
            if ("".equals(hashMap.get("GENERICTAG"))) {
                this.attributes.put("GENERICTAG", chunk.getContent());
            }
        }
        if (font.isUnderlined()) {
            objectArray = new Object[]{null, new float[]{0.0f, 0.06666667f, 0.0f, -0.33333334f, 0.0f}};
            object = Utilities.addToArray((Object[][])this.attributes.get("UNDERLINE"), objectArray);
            this.attributes.put("UNDERLINE", object);
        }
        if (font.isStrikethru()) {
            objectArray = new Object[]{null, new float[]{0.0f, 0.06666667f, 0.0f, 0.33333334f, 0.0f}};
            object = Utilities.addToArray((Object[][])this.attributes.get("UNDERLINE"), objectArray);
            this.attributes.put("UNDERLINE", object);
        }
        if (pdfAction != null) {
            this.attributes.put("ACTION", pdfAction);
        }
        this.noStroke.put("COLOR", font.getColor());
        this.noStroke.put("ENCODING", this.font.getFont().getEncoding());
        objectArray = (Object[])this.attributes.get("IMAGE");
        if (objectArray == null) {
            this.image = null;
        } else {
            this.attributes.remove("HSCALE");
            this.image = (Image)objectArray[0];
            this.offsetX = ((Float)objectArray[1]).floatValue();
            this.offsetY = ((Float)objectArray[2]).floatValue();
            this.changeLeading = (Boolean)objectArray[3];
        }
        this.font.setImage(this.image);
        object = (Float)this.attributes.get("HSCALE");
        if (object != null) {
            this.font.setHorizontalScaling(((Float)object).floatValue());
        }
        this.encoding = this.font.getFont().getEncoding();
        this.splitCharacter = (SplitCharacter)this.noStroke.get("SPLITCHARACTER");
        if (this.splitCharacter == null) {
            this.splitCharacter = DefaultSplitCharacter.DEFAULT;
        }
    }

    public int getUnicodeEquivalent(int n) {
        return this.baseFont.getUnicodeEquivalent(n);
    }

    protected int getWord(String string, int n) {
        int n2 = string.length();
        while (n < n2 && Character.isLetter(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    PdfChunk split(float f) {
        Object object;
        int n;
        int n2;
        this.newlineSplit = false;
        if (this.image != null) {
            if (this.image.getScaledWidth() > f) {
                PdfChunk pdfChunk = new PdfChunk("\ufffc", this);
                this.value = "";
                this.attributes = new HashMap();
                this.image = null;
                this.font = PdfFont.getDefaultFont();
                return pdfChunk;
            }
            return null;
        }
        HyphenationEvent hyphenationEvent = (HyphenationEvent)this.noStroke.get("HYPHENATION");
        int n3 = -1;
        float f2 = 0.0f;
        int n4 = -1;
        float f3 = 0.0f;
        int n5 = this.value.length();
        char[] cArray = this.value.toCharArray();
        char c = '\u0000';
        BaseFont baseFont = this.font.getFont();
        boolean bl = false;
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(32) != 32) {
            for (n2 = 0; n2 < n5; ++n2) {
                n = cArray[n2];
                c = (char)baseFont.getUnicodeEquivalent(n);
                if (c == '\n') {
                    this.newlineSplit = true;
                    String string = this.value.substring(n2 + 1);
                    this.value = this.value.substring(0, n2);
                    if (this.value.length() < 1) {
                        this.value = "\u0001";
                    }
                    PdfChunk pdfChunk = new PdfChunk(string, this);
                    return pdfChunk;
                }
                f2 += this.font.width(n);
                if (c == ' ') {
                    n4 = n2 + 1;
                    f3 = f2;
                }
                if (!(f2 > f)) {
                    if (!this.splitCharacter.isSplitCharacter(0, n2, n5, cArray, thisChunk)) continue;
                    n3 = n2 + 1;
                    continue;
                }
                break;
            }
        } else {
            while (n2 < n5) {
                c = cArray[n2];
                if (c == '\r' || c == '\n') {
                    this.newlineSplit = true;
                    int n6 = 1;
                    if (c == '\r' && n2 + 1 < n5 && cArray[n2 + 1] == '\n') {
                        n6 = 2;
                    }
                    String string = this.value.substring(n2 + n6);
                    this.value = this.value.substring(0, n2);
                    if (this.value.length() < 1) {
                        this.value = " ";
                    }
                    PdfChunk pdfChunk = new PdfChunk(string, this);
                    return pdfChunk;
                }
                bl = Utilities.isSurrogatePair(cArray, n2);
                f2 = bl ? (f2 += this.font.width(Utilities.convertToUtf32(cArray[n2], cArray[n2 + 1]))) : (f2 += this.font.width(c));
                if (c == ' ') {
                    n4 = n2 + 1;
                    f3 = f2;
                }
                if (bl) {
                    ++n2;
                }
                if (!(f2 > f)) {
                    if (this.splitCharacter.isSplitCharacter(0, n2, n5, cArray, null)) {
                        n3 = n2 + 1;
                    }
                    ++n2;
                    continue;
                }
                break;
            }
        }
        if (n2 == n5) {
            return null;
        }
        if (n3 < 0) {
            String string = this.value;
            this.value = "";
            PdfChunk pdfChunk = new PdfChunk(string, this);
            return pdfChunk;
        }
        if (n4 > n3 && this.splitCharacter.isSplitCharacter(0, 0, 1, singleSpace, null)) {
            n3 = n4;
        }
        if (hyphenationEvent != null && n4 >= 0 && n4 < n2 && (n = this.getWord(this.value, n4)) > n4) {
            object = hyphenationEvent.getHyphenatedWordPre(this.value.substring(n4, n), this.font.getFont(), this.font.size(), f - f3);
            String string = hyphenationEvent.getHyphenatedWordPost();
            if (((String)object).length() > 0) {
                String string2 = string + this.value.substring(n);
                this.value = this.trim(this.value.substring(0, n4) + (String)object);
                PdfChunk pdfChunk = new PdfChunk(string2, this);
                return pdfChunk;
            }
        }
        String string = this.value.substring(n3);
        this.value = this.trim(this.value.substring(0, n3));
        object = new PdfChunk(string, this);
        return object;
    }

    PdfChunk truncate(float f) {
        int n;
        if (this.image != null) {
            if (this.image.getScaledWidth() > f) {
                PdfChunk pdfChunk = new PdfChunk("", this);
                this.value = "";
                this.attributes.remove("IMAGE");
                this.image = null;
                this.font = PdfFont.getDefaultFont();
                return pdfChunk;
            }
            return null;
        }
        float f2 = 0.0f;
        if (f < this.font.width()) {
            String string = this.value.substring(1);
            this.value = this.value.substring(0, 1);
            PdfChunk pdfChunk = new PdfChunk(string, this);
            return pdfChunk;
        }
        int n2 = this.value.length();
        boolean bl = false;
        for (n = 0; n < n2; ++n) {
            bl = Utilities.isSurrogatePair(this.value, n);
            f2 = bl ? (f2 += this.font.width(Utilities.convertToUtf32(this.value, n))) : (f2 += this.font.width(this.value.charAt(n)));
            if (f2 > f) break;
            if (!bl) continue;
            ++n;
        }
        if (n == n2) {
            return null;
        }
        if (n == 0) {
            n = 1;
            if (bl) {
                ++n;
            }
        }
        String string = this.value.substring(n);
        this.value = this.value.substring(0, n);
        PdfChunk pdfChunk = new PdfChunk(string, this);
        return pdfChunk;
    }

    PdfFont font() {
        return this.font;
    }

    Color color() {
        return (Color)this.noStroke.get("COLOR");
    }

    float width() {
        return this.font.width(this.value);
    }

    public boolean isNewlineSplit() {
        return this.newlineSplit;
    }

    public float getWidthCorrected(float f, float f2) {
        if (this.image != null) {
            return this.image.getScaledWidth() + f;
        }
        int n = 0;
        int n2 = -1;
        while ((n2 = this.value.indexOf(32, n2 + 1)) >= 0) {
            ++n;
        }
        return this.width() + ((float)this.value.length() * f + (float)n * f2);
    }

    public float getTextRise() {
        Float f = (Float)this.getAttribute("SUBSUPSCRIPT");
        if (f != null) {
            return f.floatValue();
        }
        return 0.0f;
    }

    public float trimLastSpace() {
        BaseFont baseFont = this.font.getFont();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(32) != 32) {
            if (this.value.length() > 1 && this.value.endsWith("\u0001")) {
                this.value = this.value.substring(0, this.value.length() - 1);
                return this.font.width(1);
            }
        } else if (this.value.length() > 1 && this.value.endsWith(" ")) {
            this.value = this.value.substring(0, this.value.length() - 1);
            return this.font.width(32);
        }
        return 0.0f;
    }

    public float trimFirstSpace() {
        BaseFont baseFont = this.font.getFont();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(32) != 32) {
            if (this.value.length() > 1 && this.value.startsWith("\u0001")) {
                this.value = this.value.substring(1);
                return this.font.width(1);
            }
        } else if (this.value.length() > 1 && this.value.startsWith(" ")) {
            this.value = this.value.substring(1);
            return this.font.width(32);
        }
        return 0.0f;
    }

    Object getAttribute(String string) {
        if (this.attributes.containsKey(string)) {
            return this.attributes.get(string);
        }
        return this.noStroke.get(string);
    }

    boolean isAttribute(String string) {
        if (this.attributes.containsKey(string)) {
            return true;
        }
        return this.noStroke.containsKey(string);
    }

    boolean isStroked() {
        return !this.attributes.isEmpty();
    }

    boolean isSeparator() {
        return this.isAttribute("SEPARATOR");
    }

    boolean isHorizontalSeparator() {
        if (this.isAttribute("SEPARATOR")) {
            Object[] objectArray = (Object[])this.getAttribute("SEPARATOR");
            return (Boolean)objectArray[1] == false;
        }
        return false;
    }

    boolean isTab() {
        return this.isAttribute("TAB");
    }

    void adjustLeft(float f) {
        Object[] objectArray = (Object[])this.attributes.get("TAB");
        if (objectArray != null) {
            this.attributes.put("TAB", new Object[]{objectArray[0], objectArray[1], objectArray[2], new Float(f)});
        }
    }

    boolean isImage() {
        return this.image != null;
    }

    Image getImage() {
        return this.image;
    }

    void setImageOffsetX(float f) {
        this.offsetX = f;
    }

    float getImageOffsetX() {
        return this.offsetX;
    }

    void setImageOffsetY(float f) {
        this.offsetY = f;
    }

    float getImageOffsetY() {
        return this.offsetY;
    }

    void setValue(String string) {
        this.value = string;
    }

    public String toString() {
        return this.value;
    }

    boolean isSpecialEncoding() {
        return this.encoding.equals("UnicodeBigUnmarked") || this.encoding.equals("Identity-H");
    }

    String getEncoding() {
        return this.encoding;
    }

    int length() {
        return this.value.length();
    }

    int lengthUtf32() {
        if (!"Identity-H".equals(this.encoding)) {
            return this.value.length();
        }
        int n = 0;
        int n2 = this.value.length();
        for (int j = 0; j < n2; ++j) {
            if (Utilities.isSurrogateHigh(this.value.charAt(j))) {
                ++j;
            }
            ++n;
        }
        return n;
    }

    boolean isExtSplitCharacter(int n, int n2, int n3, char[] cArray, PdfChunk[] pdfChunkArray) {
        return this.splitCharacter.isSplitCharacter(n, n2, n3, cArray, pdfChunkArray);
    }

    String trim(String string) {
        BaseFont baseFont = this.font.getFont();
        if (baseFont.getFontType() == 2 && baseFont.getUnicodeEquivalent(32) != 32) {
            while (string.endsWith("\u0001")) {
                string = string.substring(0, string.length() - 1);
            }
        } else {
            while (string.endsWith(" ") || string.endsWith("\t")) {
                string = string.substring(0, string.length() - 1);
            }
        }
        return string;
    }

    public boolean changeLeading() {
        return this.changeLeading;
    }

    float getCharWidth(int n) {
        if (PdfChunk.noPrint(n)) {
            return 0.0f;
        }
        return this.font.width(n);
    }

    public static boolean noPrint(int n) {
        return n >= 8203 && n <= 8207 || n >= 8234 && n <= 8238;
    }

    static {
        keysAttributes.put("ACTION", null);
        keysAttributes.put("UNDERLINE", null);
        keysAttributes.put("REMOTEGOTO", null);
        keysAttributes.put("LOCALGOTO", null);
        keysAttributes.put("LOCALDESTINATION", null);
        keysAttributes.put("GENERICTAG", null);
        keysAttributes.put("NEWPAGE", null);
        keysAttributes.put("IMAGE", null);
        keysAttributes.put("BACKGROUND", null);
        keysAttributes.put("PDFANNOTATION", null);
        keysAttributes.put("SKEW", null);
        keysAttributes.put("HSCALE", null);
        keysAttributes.put("SEPARATOR", null);
        keysAttributes.put("TAB", null);
        keysNoStroke.put("SUBSUPSCRIPT", null);
        keysNoStroke.put("SPLITCHARACTER", null);
        keysNoStroke.put("HYPHENATION", null);
        keysNoStroke.put("TEXTRENDERMODE", null);
    }
}

