/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf.internal;

import com.lowagie.text.pdf.internal.PolylineShapeIterator;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PolylineShape
implements Shape {
    protected int[] x;
    protected int[] y;
    protected int np;

    public PolylineShape(int[] nArray, int[] nArray2, int n) {
        this.np = n;
        this.x = new int[this.np];
        this.y = new int[this.np];
        System.arraycopy(nArray, 0, this.x, 0, this.np);
        System.arraycopy(nArray2, 0, this.y, 0, this.np);
    }

    public Rectangle2D getBounds2D() {
        int[] nArray = this.rect();
        return nArray == null ? null : new Rectangle2D.Double(nArray[0], nArray[1], nArray[2], nArray[3]);
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    private int[] rect() {
        if (this.np == 0) {
            return null;
        }
        int n = this.x[0];
        int n2 = this.y[0];
        int n3 = this.x[0];
        int n4 = this.y[0];
        for (int j = 1; j < this.np; ++j) {
            if (this.x[j] < n) {
                n = this.x[j];
            } else if (this.x[j] > n3) {
                n3 = this.x[j];
            }
            if (this.y[j] < n2) {
                n2 = this.y[j];
                continue;
            }
            if (this.y[j] <= n4) continue;
            n4 = this.y[j];
        }
        return new int[]{n, n2, n3 - n, n4 - n2};
    }

    public boolean contains(double d, double d2) {
        return false;
    }

    public boolean contains(Point2D point2D) {
        return false;
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        return false;
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return false;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        return this.intersects(new Rectangle2D.Double(d, d2, d3, d4));
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        if (this.np == 0) {
            return false;
        }
        Line2D.Double double_ = new Line2D.Double(this.x[0], this.y[0], this.x[0], this.y[0]);
        for (int j = 1; j < this.np; ++j) {
            ((Line2D)double_).setLine(this.x[j - 1], this.y[j - 1], this.x[j], this.y[j]);
            if (!double_.intersects(rectangle2D)) continue;
            return true;
        }
        return false;
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new PolylineShapeIterator(this, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new PolylineShapeIterator(this, affineTransform);
    }
}

