/*
 * Decompiled with CFR 0.152.
 */
package eu.bitwalker.useragentutils;

import eu.bitwalker.useragentutils.Version;
import eu.bitwalker.useragentutils.VersionFetcher;

public class SequentialVersionFetcher
implements VersionFetcher {
    private final VersionFetcher[] fetchers;

    public SequentialVersionFetcher(VersionFetcher first, VersionFetcher ... others) {
        this.fetchers = new VersionFetcher[others.length + 1];
        this.fetchers[0] = first;
        for (int i2 = 0; i2 < others.length; ++i2) {
            this.fetchers[i2 + 1] = others[i2];
        }
    }

    @Override
    public Version version(String str) {
        for (VersionFetcher fetcher : this.fetchers) {
            Version version = fetcher.version(str);
            if (version == null) continue;
            return version;
        }
        return null;
    }
}

