/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.FlowControlException;
import freemarker.core.ParameterRole;
import freemarker.core.ParseException;
import freemarker.core.TemplateElement;
import freemarker.core.TemplatePostProcessor;
import freemarker.core.TemplatePostProcessorException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;

class ThreadInterruptionSupportTemplatePostProcessor
extends TemplatePostProcessor {
    ThreadInterruptionSupportTemplatePostProcessor() {
    }

    @Override
    public void postProcess(Template t) throws TemplatePostProcessorException {
        TemplateElement te = t.getRootTreeNode();
        this.addInterruptionChecks(te);
    }

    private void addInterruptionChecks(TemplateElement te) throws TemplatePostProcessorException {
        if (te == null) {
            return;
        }
        int childCount = te.getChildCount();
        for (int i2 = 0; i2 < childCount; ++i2) {
            this.addInterruptionChecks(te.getChild(i2));
        }
        if (te.isNestedBlockRepeater()) {
            try {
                te.addChild(0, new ThreadInterruptionCheck(te));
            }
            catch (ParseException e) {
                throw new TemplatePostProcessorException("Unexpected error; see cause", e);
            }
        }
    }

    static class TemplateProcessingThreadInterruptedException
    extends FlowControlException {
        TemplateProcessingThreadInterruptedException() {
            super("Template processing thread \"interrupted\" flag was set.");
        }
    }

    static class ThreadInterruptionCheck
    extends TemplateElement {
        private ThreadInterruptionCheck(TemplateElement te) throws ParseException {
            this.setLocation(te.getTemplate(), te.beginColumn, te.beginLine, te.beginColumn, te.beginLine);
        }

        @Override
        TemplateElement[] accept(Environment env) throws TemplateException, IOException {
            if (Thread.currentThread().isInterrupted()) {
                throw new TemplateProcessingThreadInterruptedException();
            }
            return null;
        }

        @Override
        protected String dump(boolean canonical) {
            return canonical ? "" : "<#--" + this.getNodeTypeSymbol() + "--#>";
        }

        @Override
        String getNodeTypeSymbol() {
            return "##threadInterruptionCheck";
        }

        @Override
        int getParameterCount() {
            return 0;
        }

        @Override
        Object getParameterValue(int idx) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        ParameterRole getParameterRole(int idx) {
            throw new IndexOutOfBoundsException();
        }

        @Override
        boolean isNestedBlockRepeater() {
            return false;
        }
    }
}

