/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl;

import io.jsonwebtoken.impl.AbstractTextCodec;
import io.jsonwebtoken.impl.TextCodec;

public class Base64UrlCodec
extends AbstractTextCodec {
    @Override
    public String encode(byte[] data) {
        String base64Text = TextCodec.BASE64.encode(data);
        byte[] bytes = base64Text.getBytes(US_ASCII);
        bytes = this.removePadding(bytes);
        for (int i2 = 0; i2 < bytes.length; ++i2) {
            if (bytes[i2] == 43) {
                bytes[i2] = 45;
                continue;
            }
            if (bytes[i2] != 47) continue;
            bytes[i2] = 95;
        }
        return new String(bytes, US_ASCII);
    }

    protected byte[] removePadding(byte[] bytes) {
        byte[] result = bytes;
        int paddingCount = 0;
        for (int i2 = bytes.length - 1; i2 > 0 && bytes[i2] == 61; --i2) {
            ++paddingCount;
        }
        if (paddingCount > 0) {
            result = new byte[bytes.length - paddingCount];
            System.arraycopy(bytes, 0, result, 0, bytes.length - paddingCount);
        }
        return result;
    }

    @Override
    public byte[] decode(String encoded) {
        char[] chars = encoded.toCharArray();
        chars = this.ensurePadding(chars);
        for (int i2 = 0; i2 < chars.length; ++i2) {
            if (chars[i2] == '-') {
                chars[i2] = 43;
                continue;
            }
            if (chars[i2] != '_') continue;
            chars[i2] = 47;
        }
        String base64Text = new String(chars);
        return TextCodec.BASE64.decode(base64Text);
    }

    protected char[] ensurePadding(char[] chars) {
        char[] result = chars;
        int paddingCount = 0;
        int remainder = chars.length % 4;
        if (remainder == 2 || remainder == 3) {
            paddingCount = 4 - remainder;
        }
        if (paddingCount > 0) {
            result = new char[chars.length + paddingCount];
            System.arraycopy(chars, 0, result, 0, chars.length);
            for (int i2 = 0; i2 < paddingCount; ++i2) {
                result[chars.length + i2] = 61;
            }
        }
        return result;
    }
}

