/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.compression;

import io.jsonwebtoken.CompressionCodec;
import io.jsonwebtoken.CompressionCodecResolver;
import io.jsonwebtoken.CompressionException;
import io.jsonwebtoken.Header;
import io.jsonwebtoken.impl.compression.CompressionCodecs;
import io.jsonwebtoken.lang.Assert;
import io.jsonwebtoken.lang.Strings;

public class DefaultCompressionCodecResolver
implements CompressionCodecResolver {
    @Override
    public CompressionCodec resolveCompressionCodec(Header header2) {
        String cmpAlg = this.getAlgorithmFromHeader(header2);
        boolean hasCompressionAlgorithm = Strings.hasText(cmpAlg);
        if (!hasCompressionAlgorithm) {
            return null;
        }
        if (CompressionCodecs.DEFLATE.getAlgorithmName().equalsIgnoreCase(cmpAlg)) {
            return CompressionCodecs.DEFLATE;
        }
        if (CompressionCodecs.GZIP.getAlgorithmName().equalsIgnoreCase(cmpAlg)) {
            return CompressionCodecs.GZIP;
        }
        throw new CompressionException("Unsupported compression algorithm '" + cmpAlg + "'");
    }

    private String getAlgorithmFromHeader(Header header2) {
        Assert.notNull(header2, "header cannot be null.");
        return header2.getCompressionAlgorithm();
    }
}

