/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.bind.annotation.adapters;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollapsedStringAdapter
extends XmlAdapter<String, String> {
    @Override
    public String unmarshal(String text) {
        int s;
        if (text == null) {
            return null;
        }
        int len = text.length();
        for (s = 0; s < len && !CollapsedStringAdapter.isWhiteSpace(text.charAt(s)); ++s) {
        }
        if (s == len) {
            return text;
        }
        StringBuffer result = new StringBuffer(len);
        if (s != 0) {
            for (int i2 = 0; i2 < s; ++i2) {
                result.append(text.charAt(i2));
            }
            result.append(' ');
        }
        boolean inStripMode = true;
        for (int i3 = s + 1; i3 < len; ++i3) {
            char ch = text.charAt(i3);
            boolean b = CollapsedStringAdapter.isWhiteSpace(ch);
            if (inStripMode && b) continue;
            inStripMode = b;
            if (inStripMode) {
                result.append(' ');
                continue;
            }
            result.append(ch);
        }
        len = result.length();
        if (len > 0 && result.charAt(len - 1) == ' ') {
            result.setLength(len - 1);
        }
        return result.toString();
    }

    @Override
    public String marshal(String s) {
        return s;
    }

    protected static boolean isWhiteSpace(char ch) {
        if (ch > ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }
}

