/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pinyin4j;

import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

class PinyinFormatter {
    PinyinFormatter() {
    }

    static String formatHanyuPinyin(String pinyinStr, HanyuPinyinOutputFormat outputFormat) throws BadHanyuPinyinOutputFormatCombination {
        if (HanyuPinyinToneType.WITH_TONE_MARK == outputFormat.getToneType() && (HanyuPinyinVCharType.WITH_V == outputFormat.getVCharType() || HanyuPinyinVCharType.WITH_U_AND_COLON == outputFormat.getVCharType())) {
            throw new BadHanyuPinyinOutputFormatCombination("tone marks cannot be added to v or u:");
        }
        if (HanyuPinyinToneType.WITHOUT_TONE == outputFormat.getToneType()) {
            pinyinStr = pinyinStr.replaceAll("[1-5]", "");
        } else if (HanyuPinyinToneType.WITH_TONE_MARK == outputFormat.getToneType()) {
            pinyinStr = pinyinStr.replaceAll("u:", "v");
            pinyinStr = PinyinFormatter.convertToneNumber2ToneMark(pinyinStr);
        }
        if (HanyuPinyinVCharType.WITH_V == outputFormat.getVCharType()) {
            pinyinStr = pinyinStr.replaceAll("u:", "v");
        } else if (HanyuPinyinVCharType.WITH_U_UNICODE == outputFormat.getVCharType()) {
            pinyinStr = pinyinStr.replaceAll("u:", "\u00fc");
        }
        if (HanyuPinyinCaseType.UPPERCASE == outputFormat.getCaseType()) {
            pinyinStr = pinyinStr.toUpperCase();
        }
        return pinyinStr;
    }

    private static String convertToneNumber2ToneMark(String pinyinStr) {
        String lowerCasePinyinStr = pinyinStr.toLowerCase();
        if (lowerCasePinyinStr.matches("[a-z]*[1-5]?")) {
            int defautlCharValue = 36;
            int defautlIndexValue = -1;
            int unmarkedVowel = 36;
            int indexOfUnmarkedVowel = -1;
            int charA = 97;
            int charE = 101;
            String ouStr = "ou";
            String allUnmarkedVowelStr = "aeiouv";
            String allMarkedVowelStr = "\u0101\u00e1\u0103\u00e0a\u0113\u00e9\u0115\u00e8e\u012b\u00ed\u012d\u00eci\u014d\u00f3\u014f\u00f2o\u016b\u00fa\u016d\u00f9u\u01d6\u01d8\u01da\u01dc\u00fc";
            if (lowerCasePinyinStr.matches("[a-z]*[1-5]")) {
                int tuneNumber = Character.getNumericValue(lowerCasePinyinStr.charAt(lowerCasePinyinStr.length() - 1));
                int indexOfA = lowerCasePinyinStr.indexOf(97);
                int indexOfE = lowerCasePinyinStr.indexOf(101);
                int ouIndex = lowerCasePinyinStr.indexOf("ou");
                if (-1 != indexOfA) {
                    indexOfUnmarkedVowel = indexOfA;
                    unmarkedVowel = 97;
                } else if (-1 != indexOfE) {
                    indexOfUnmarkedVowel = indexOfE;
                    unmarkedVowel = 101;
                } else if (-1 != ouIndex) {
                    indexOfUnmarkedVowel = ouIndex;
                    unmarkedVowel = "ou".charAt(0);
                } else {
                    for (int i2 = lowerCasePinyinStr.length() - 1; i2 >= 0; --i2) {
                        if (!String.valueOf(lowerCasePinyinStr.charAt(i2)).matches("[aeiouv]")) continue;
                        indexOfUnmarkedVowel = i2;
                        unmarkedVowel = lowerCasePinyinStr.charAt(i2);
                        break;
                    }
                }
                if (36 != unmarkedVowel && -1 != indexOfUnmarkedVowel) {
                    int rowIndex = "aeiouv".indexOf(unmarkedVowel);
                    int columnIndex = tuneNumber - 1;
                    int vowelLocation = rowIndex * 5 + columnIndex;
                    char markedVowel = "\u0101\u00e1\u0103\u00e0a\u0113\u00e9\u0115\u00e8e\u012b\u00ed\u012d\u00eci\u014d\u00f3\u014f\u00f2o\u016b\u00fa\u016d\u00f9u\u01d6\u01d8\u01da\u01dc\u00fc".charAt(vowelLocation);
                    StringBuffer resultBuffer = new StringBuffer();
                    resultBuffer.append(lowerCasePinyinStr.substring(0, indexOfUnmarkedVowel).replaceAll("v", "\u00fc"));
                    resultBuffer.append(markedVowel);
                    resultBuffer.append(lowerCasePinyinStr.substring(indexOfUnmarkedVowel + 1, lowerCasePinyinStr.length() - 1).replaceAll("v", "\u00fc"));
                    return resultBuffer.toString();
                }
                return lowerCasePinyinStr;
            }
            return lowerCasePinyinStr.replaceAll("v", "\u00fc");
        }
        return lowerCasePinyinStr;
    }
}

