/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pinyin4j;

import net.sourceforge.pinyin4j.ChineseToPinyinResource;
import net.sourceforge.pinyin4j.GwoyeuRomatzyhTranslator;
import net.sourceforge.pinyin4j.PinyinFormatter;
import net.sourceforge.pinyin4j.PinyinRomanizationTranslator;
import net.sourceforge.pinyin4j.PinyinRomanizationType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

public class PinyinHelper {
    public static String[] toHanyuPinyinStringArray(char ch) {
        return PinyinHelper.getUnformattedHanyuPinyinStringArray(ch);
    }

    public static String[] toHanyuPinyinStringArray(char ch, HanyuPinyinOutputFormat outputFormat) throws BadHanyuPinyinOutputFormatCombination {
        return PinyinHelper.getFormattedHanyuPinyinStringArray(ch, outputFormat);
    }

    private static String[] getFormattedHanyuPinyinStringArray(char ch, HanyuPinyinOutputFormat outputFormat) throws BadHanyuPinyinOutputFormatCombination {
        String[] pinyinStrArray = PinyinHelper.getUnformattedHanyuPinyinStringArray(ch);
        if (null != pinyinStrArray) {
            for (int i2 = 0; i2 < pinyinStrArray.length; ++i2) {
                pinyinStrArray[i2] = PinyinFormatter.formatHanyuPinyin(pinyinStrArray[i2], outputFormat);
            }
            return pinyinStrArray;
        }
        return null;
    }

    private static String[] getUnformattedHanyuPinyinStringArray(char ch) {
        return ChineseToPinyinResource.getInstance().getHanyuPinyinStringArray(ch);
    }

    public static String[] toTongyongPinyinStringArray(char ch) {
        return PinyinHelper.convertToTargetPinyinStringArray(ch, PinyinRomanizationType.TONGYONG_PINYIN);
    }

    public static String[] toWadeGilesPinyinStringArray(char ch) {
        return PinyinHelper.convertToTargetPinyinStringArray(ch, PinyinRomanizationType.WADEGILES_PINYIN);
    }

    public static String[] toMPS2PinyinStringArray(char ch) {
        return PinyinHelper.convertToTargetPinyinStringArray(ch, PinyinRomanizationType.MPS2_PINYIN);
    }

    public static String[] toYalePinyinStringArray(char ch) {
        return PinyinHelper.convertToTargetPinyinStringArray(ch, PinyinRomanizationType.YALE_PINYIN);
    }

    private static String[] convertToTargetPinyinStringArray(char ch, PinyinRomanizationType targetPinyinSystem) {
        String[] hanyuPinyinStringArray = PinyinHelper.getUnformattedHanyuPinyinStringArray(ch);
        if (null != hanyuPinyinStringArray) {
            String[] targetPinyinStringArray = new String[hanyuPinyinStringArray.length];
            for (int i2 = 0; i2 < hanyuPinyinStringArray.length; ++i2) {
                targetPinyinStringArray[i2] = PinyinRomanizationTranslator.convertRomanizationSystem(hanyuPinyinStringArray[i2], PinyinRomanizationType.HANYU_PINYIN, targetPinyinSystem);
            }
            return targetPinyinStringArray;
        }
        return null;
    }

    public static String[] toGwoyeuRomatzyhStringArray(char ch) {
        return PinyinHelper.convertToGwoyeuRomatzyhStringArray(ch);
    }

    private static String[] convertToGwoyeuRomatzyhStringArray(char ch) {
        String[] hanyuPinyinStringArray = PinyinHelper.getUnformattedHanyuPinyinStringArray(ch);
        if (null != hanyuPinyinStringArray) {
            String[] targetPinyinStringArray = new String[hanyuPinyinStringArray.length];
            for (int i2 = 0; i2 < hanyuPinyinStringArray.length; ++i2) {
                targetPinyinStringArray[i2] = GwoyeuRomatzyhTranslator.convertHanyuPinyinToGwoyeuRomatzyh(hanyuPinyinStringArray[i2]);
            }
            return targetPinyinStringArray;
        }
        return null;
    }

    public static String toHanyuPinyinString(String str, HanyuPinyinOutputFormat outputFormat, String seperater) throws BadHanyuPinyinOutputFormatCombination {
        StringBuffer resultPinyinStrBuf = new StringBuffer();
        for (int i2 = 0; i2 < str.length(); ++i2) {
            String mainPinyinStrOfChar = PinyinHelper.getFirstHanyuPinyinString(str.charAt(i2), outputFormat);
            if (null != mainPinyinStrOfChar) {
                resultPinyinStrBuf.append(mainPinyinStrOfChar);
                if (i2 == str.length() - 1) continue;
                resultPinyinStrBuf.append(seperater);
                continue;
            }
            resultPinyinStrBuf.append(str.charAt(i2));
        }
        return resultPinyinStrBuf.toString();
    }

    private static String getFirstHanyuPinyinString(char ch, HanyuPinyinOutputFormat outputFormat) throws BadHanyuPinyinOutputFormatCombination {
        String[] pinyinStrArray = PinyinHelper.getFormattedHanyuPinyinStringArray(ch, outputFormat);
        if (null != pinyinStrArray && pinyinStrArray.length > 0) {
            return pinyinStrArray[0];
        }
        return null;
    }

    private PinyinHelper() {
    }
}

