/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.builder;

import java.util.HashMap;
import org.apache.ibatis.builder.BuilderException;

public class ParameterExpression
extends HashMap<String, String> {
    private static final long serialVersionUID = -2417552199605158680L;

    public ParameterExpression(String expression) {
        this.parse(expression);
    }

    private void parse(String expression) {
        int p2 = this.skipWS(expression, 0);
        if (expression.charAt(p2) == '(') {
            this.expression(expression, p2 + 1);
        } else {
            this.property(expression, p2);
        }
    }

    private void expression(String expression, int left) {
        int match = 1;
        int right = left + 1;
        while (match > 0) {
            if (expression.charAt(right) == ')') {
                --match;
            } else if (expression.charAt(right) == '(') {
                ++match;
            }
            ++right;
        }
        this.put("expression", expression.substring(left, right - 1));
        this.jdbcTypeOpt(expression, right);
    }

    private void property(String expression, int left) {
        if (left < expression.length()) {
            int right = this.skipUntil(expression, left, ",:");
            this.put("property", this.trimmedStr(expression, left, right));
            this.jdbcTypeOpt(expression, right);
        }
    }

    private int skipWS(String expression, int p2) {
        for (int i2 = p2; i2 < expression.length(); ++i2) {
            if (expression.charAt(i2) <= ' ') continue;
            return i2;
        }
        return expression.length();
    }

    private int skipUntil(String expression, int p2, String endChars) {
        for (int i2 = p2; i2 < expression.length(); ++i2) {
            char c = expression.charAt(i2);
            if (endChars.indexOf(c) <= -1) continue;
            return i2;
        }
        return expression.length();
    }

    private void jdbcTypeOpt(String expression, int p2) {
        if ((p2 = this.skipWS(expression, p2)) < expression.length()) {
            if (expression.charAt(p2) == ':') {
                this.jdbcType(expression, p2 + 1);
            } else if (expression.charAt(p2) == ',') {
                this.option(expression, p2 + 1);
            } else {
                throw new BuilderException("Parsing error in {" + expression + "} in position " + p2);
            }
        }
    }

    private void jdbcType(String expression, int p2) {
        int left = this.skipWS(expression, p2);
        int right = this.skipUntil(expression, left, ",");
        if (right <= left) {
            throw new BuilderException("Parsing error in {" + expression + "} in position " + p2);
        }
        this.put("jdbcType", this.trimmedStr(expression, left, right));
        this.option(expression, right + 1);
    }

    private void option(String expression, int p2) {
        int left = this.skipWS(expression, p2);
        if (left < expression.length()) {
            int right = this.skipUntil(expression, left, "=");
            String name = this.trimmedStr(expression, left, right);
            left = right + 1;
            right = this.skipUntil(expression, left, ",");
            String value = this.trimmedStr(expression, left, right);
            this.put(name, value);
            this.option(expression, right + 1);
        }
    }

    private String trimmedStr(String str, int start, int end) {
        while (str.charAt(start) <= ' ') {
            ++start;
        }
        while (str.charAt(end - 1) <= ' ') {
            --end;
        }
        return start >= end ? "" : str.substring(start, end);
    }
}

