/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.logging.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.jdbc.BaseJdbcLogger;
import org.apache.ibatis.reflection.ExceptionUtil;

public final class ResultSetLogger
extends BaseJdbcLogger
implements InvocationHandler {
    private static final Set<Integer> BLOB_TYPES = new HashSet<Integer>();
    private boolean first = true;
    private int rows;
    private final ResultSet rs;
    private final Set<Integer> blobColumns = new HashSet<Integer>();

    private ResultSetLogger(ResultSet rs, Log statementLog, int queryStack) {
        super(statementLog, queryStack);
        this.rs = rs;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        try {
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this, params);
            }
            Object o = method.invoke((Object)this.rs, params);
            if ("next".equals(method.getName())) {
                if (((Boolean)o).booleanValue()) {
                    ++this.rows;
                    if (this.isTraceEnabled()) {
                        ResultSetMetaData rsmd = this.rs.getMetaData();
                        int columnCount = rsmd.getColumnCount();
                        if (this.first) {
                            this.first = false;
                            this.printColumnHeaders(rsmd, columnCount);
                        }
                        this.printColumnValues(columnCount);
                    }
                } else {
                    this.debug("     Total: " + this.rows, false);
                }
            }
            this.clearColumnInfo();
            return o;
        }
        catch (Throwable t) {
            throw ExceptionUtil.unwrapThrowable(t);
        }
    }

    private void printColumnHeaders(ResultSetMetaData rsmd, int columnCount) throws SQLException {
        StringJoiner row = new StringJoiner(", ", "   Columns: ", "");
        for (int i2 = 1; i2 <= columnCount; ++i2) {
            if (BLOB_TYPES.contains(rsmd.getColumnType(i2))) {
                this.blobColumns.add(i2);
            }
            row.add(rsmd.getColumnLabel(i2));
        }
        this.trace(row.toString(), false);
    }

    private void printColumnValues(int columnCount) {
        StringJoiner row = new StringJoiner(", ", "       Row: ", "");
        for (int i2 = 1; i2 <= columnCount; ++i2) {
            try {
                if (this.blobColumns.contains(i2)) {
                    row.add("<<BLOB>>");
                    continue;
                }
                row.add(this.rs.getString(i2));
                continue;
            }
            catch (SQLException e) {
                row.add("<<Cannot Display>>");
            }
        }
        this.trace(row.toString(), false);
    }

    public static ResultSet newInstance(ResultSet rs, Log statementLog, int queryStack) {
        ResultSetLogger handler = new ResultSetLogger(rs, statementLog, queryStack);
        ClassLoader cl = ResultSet.class.getClassLoader();
        return (ResultSet)Proxy.newProxyInstance(cl, new Class[]{ResultSet.class}, (InvocationHandler)handler);
    }

    public ResultSet getRs() {
        return this.rs;
    }

    static {
        BLOB_TYPES.add(-2);
        BLOB_TYPES.add(2004);
        BLOB_TYPES.add(2005);
        BLOB_TYPES.add(-16);
        BLOB_TYPES.add(-4);
        BLOB_TYPES.add(-1);
        BLOB_TYPES.add(2011);
        BLOB_TYPES.add(-3);
    }
}

