/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.ognl;

import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.ognl.ASTKeyValue;
import org.apache.ibatis.ognl.Node;
import org.apache.ibatis.ognl.OgnlContext;
import org.apache.ibatis.ognl.OgnlException;
import org.apache.ibatis.ognl.OgnlParser;
import org.apache.ibatis.ognl.OgnlRuntime;
import org.apache.ibatis.ognl.SimpleNode;
import org.apache.ibatis.ognl.enhance.UnsupportedCompilationException;

class ASTMap
extends SimpleNode {
    private static Class DEFAULT_MAP_CLASS;
    private String className;

    public ASTMap(int id) {
        super(id);
    }

    public ASTMap(OgnlParser p2, int id) {
        super(p2, id);
    }

    protected void setClassName(String value) {
        this.className = value;
    }

    @Override
    protected Object getValueBody(OgnlContext context, Object source) throws OgnlException {
        Map answer;
        if (this.className == null) {
            try {
                answer = (Map)DEFAULT_MAP_CLASS.newInstance();
            }
            catch (Exception ex) {
                throw new OgnlException("Default Map class '" + DEFAULT_MAP_CLASS.getName() + "' instantiation error", ex);
            }
        }
        try {
            answer = (Map)OgnlRuntime.classForName(context, this.className).newInstance();
        }
        catch (Exception ex) {
            throw new OgnlException("Map implementor '" + this.className + "' not found", ex);
        }
        for (int i2 = 0; i2 < this.jjtGetNumChildren(); ++i2) {
            ASTKeyValue kv = (ASTKeyValue)this._children[i2];
            Node k = kv.getKey();
            Node v = kv.getValue();
            answer.put(k.getValue(context, source), v == null ? null : v.getValue(context, source));
        }
        return answer;
    }

    @Override
    public String toString() {
        String result = "#";
        if (this.className != null) {
            result = result + "@" + this.className + "@";
        }
        result = result + "{ ";
        for (int i2 = 0; i2 < this.jjtGetNumChildren(); ++i2) {
            ASTKeyValue kv = (ASTKeyValue)this._children[i2];
            if (i2 > 0) {
                result = result + ", ";
            }
            result = result + kv.getKey() + " : " + kv.getValue();
        }
        return result + " }";
    }

    @Override
    public String toGetSourceString(OgnlContext context, Object target) {
        throw new UnsupportedCompilationException("Map expressions not supported as native java yet.");
    }

    @Override
    public String toSetSourceString(OgnlContext context, Object target) {
        throw new UnsupportedCompilationException("Map expressions not supported as native java yet.");
    }

    static {
        try {
            DEFAULT_MAP_CLASS = Class.forName("java.util.LinkedHashMap");
        }
        catch (ClassNotFoundException ex) {
            DEFAULT_MAP_CLASS = HashMap.class;
        }
    }
}

