/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.reflection;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import org.apache.ibatis.reflection.Reflector;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.TypeParameterResolver;
import org.apache.ibatis.reflection.invoker.GetFieldInvoker;
import org.apache.ibatis.reflection.invoker.Invoker;
import org.apache.ibatis.reflection.invoker.MethodInvoker;
import org.apache.ibatis.reflection.property.PropertyTokenizer;

public class MetaClass {
    private final ReflectorFactory reflectorFactory;
    private final Reflector reflector;

    private MetaClass(Class<?> type, ReflectorFactory reflectorFactory) {
        this.reflectorFactory = reflectorFactory;
        this.reflector = reflectorFactory.findForClass(type);
    }

    public static MetaClass forClass(Class<?> type, ReflectorFactory reflectorFactory) {
        return new MetaClass(type, reflectorFactory);
    }

    public MetaClass metaClassForProperty(String name) {
        Class<?> propType = this.reflector.getGetterType(name);
        return MetaClass.forClass(propType, this.reflectorFactory);
    }

    public String findProperty(String name) {
        StringBuilder prop = this.buildProperty(name, new StringBuilder());
        return prop.length() > 0 ? prop.toString() : null;
    }

    public String findProperty(String name, boolean useCamelCaseMapping) {
        if (useCamelCaseMapping) {
            name = name.replace("_", "");
        }
        return this.findProperty(name);
    }

    public String[] getGetterNames() {
        return this.reflector.getGetablePropertyNames();
    }

    public String[] getSetterNames() {
        return this.reflector.getSetablePropertyNames();
    }

    public Class<?> getSetterType(String name) {
        PropertyTokenizer prop = new PropertyTokenizer(name);
        if (prop.hasNext()) {
            MetaClass metaProp = this.metaClassForProperty(prop.getName());
            return metaProp.getSetterType(prop.getChildren());
        }
        return this.reflector.getSetterType(prop.getName());
    }

    public Class<?> getGetterType(String name) {
        PropertyTokenizer prop = new PropertyTokenizer(name);
        if (prop.hasNext()) {
            MetaClass metaProp = this.metaClassForProperty(prop);
            return metaProp.getGetterType(prop.getChildren());
        }
        return this.getGetterType(prop);
    }

    private MetaClass metaClassForProperty(PropertyTokenizer prop) {
        Class<?> propType = this.getGetterType(prop);
        return MetaClass.forClass(propType, this.reflectorFactory);
    }

    private Class<?> getGetterType(PropertyTokenizer prop) {
        Type[] actualTypeArguments;
        Type returnType2;
        Class type = this.reflector.getGetterType(prop.getName());
        if (prop.getIndex() != null && Collection.class.isAssignableFrom(type) && (returnType2 = this.getGenericGetterType(prop.getName())) instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)returnType2).getActualTypeArguments()) != null && actualTypeArguments.length == 1) {
            returnType2 = actualTypeArguments[0];
            if (returnType2 instanceof Class) {
                type = (Class)returnType2;
            } else if (returnType2 instanceof ParameterizedType) {
                type = (Class)((ParameterizedType)returnType2).getRawType();
            }
        }
        return type;
    }

    private Type getGenericGetterType(String propertyName) {
        try {
            Invoker invoker = this.reflector.getGetInvoker(propertyName);
            if (invoker instanceof MethodInvoker) {
                Field declaredMethod = MethodInvoker.class.getDeclaredField("method");
                declaredMethod.setAccessible(true);
                Method method = (Method)declaredMethod.get(invoker);
                return TypeParameterResolver.resolveReturnType(method, this.reflector.getType());
            }
            if (invoker instanceof GetFieldInvoker) {
                Field declaredField = GetFieldInvoker.class.getDeclaredField("field");
                declaredField.setAccessible(true);
                Field field = (Field)declaredField.get(invoker);
                return TypeParameterResolver.resolveFieldType(field, this.reflector.getType());
            }
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        return null;
    }

    public boolean hasSetter(String name) {
        PropertyTokenizer prop = new PropertyTokenizer(name);
        if (prop.hasNext()) {
            if (this.reflector.hasSetter(prop.getName())) {
                MetaClass metaProp = this.metaClassForProperty(prop.getName());
                return metaProp.hasSetter(prop.getChildren());
            }
            return false;
        }
        return this.reflector.hasSetter(prop.getName());
    }

    public boolean hasGetter(String name) {
        PropertyTokenizer prop = new PropertyTokenizer(name);
        if (prop.hasNext()) {
            if (this.reflector.hasGetter(prop.getName())) {
                MetaClass metaProp = this.metaClassForProperty(prop);
                return metaProp.hasGetter(prop.getChildren());
            }
            return false;
        }
        return this.reflector.hasGetter(prop.getName());
    }

    public Invoker getGetInvoker(String name) {
        return this.reflector.getGetInvoker(name);
    }

    public Invoker getSetInvoker(String name) {
        return this.reflector.getSetInvoker(name);
    }

    private StringBuilder buildProperty(String name, StringBuilder builder) {
        PropertyTokenizer prop = new PropertyTokenizer(name);
        if (prop.hasNext()) {
            String propertyName = this.reflector.findPropertyName(prop.getName());
            if (propertyName != null) {
                builder.append(propertyName);
                builder.append(".");
                MetaClass metaProp = this.metaClassForProperty(propertyName);
                metaProp.buildProperty(prop.getChildren(), builder);
            }
        } else {
            String propertyName = this.reflector.findPropertyName(name);
            if (propertyName != null) {
                builder.append(propertyName);
            }
        }
        return builder;
    }

    public boolean hasDefaultConstructor() {
        return this.reflector.hasDefaultConstructor();
    }
}

