/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.type;

import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.chrono.JapaneseDate;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public class JapaneseDateTypeHandler
extends BaseTypeHandler<JapaneseDate> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i2, JapaneseDate parameter, JdbcType jdbcType) throws SQLException {
        ps.setDate(i2, Date.valueOf(LocalDate.ofEpochDay(parameter.toEpochDay())));
    }

    @Override
    public JapaneseDate getNullableResult(ResultSet rs, String columnName) throws SQLException {
        Date date2 = rs.getDate(columnName);
        return JapaneseDateTypeHandler.getJapaneseDate(date2);
    }

    @Override
    public JapaneseDate getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        Date date2 = rs.getDate(columnIndex);
        return JapaneseDateTypeHandler.getJapaneseDate(date2);
    }

    @Override
    public JapaneseDate getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        Date date2 = cs.getDate(columnIndex);
        return JapaneseDateTypeHandler.getJapaneseDate(date2);
    }

    private static JapaneseDate getJapaneseDate(Date date2) {
        if (date2 != null) {
            return JapaneseDate.from(date2.toLocalDate());
        }
        return null;
    }
}

