/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.bean;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import com.google.inject.spi.ProvisionListener;
import java.util.ArrayList;

public abstract class BeanScheduler {
    static final Object ACTIVATOR;
    static final Object PLACEHOLDER;
    public static final Module MODULE;
    private static final ThreadLocal<Object[]> pendingHolder;

    static {
        Activator activator;
        try {
            Binder.class.getMethod("bindListener", Matcher.class, ProvisionListener[].class);
            activator = new Activator();
        }
        catch (Exception exception) {
            activator = null;
        }
        catch (LinkageError linkageError) {
            activator = null;
        }
        ACTIVATOR = activator;
        PLACEHOLDER = new Object();
        MODULE = new Module(){

            public void configure(Binder binder) {
                if (ACTIVATOR != null) {
                    binder.bindListener(Matchers.any(), new ProvisionListener[]{(ProvisionListener)ACTIVATOR});
                }
            }
        };
        pendingHolder = new ThreadLocal();
    }

    public final void schedule(Object bean2) {
        if (ACTIVATOR != null) {
            Object[] holder = BeanScheduler.getPendingHolder();
            Object pending = holder[0];
            if (pending == PLACEHOLDER) {
                holder[0] = new Pending(bean2);
                return;
            }
            if (pending instanceof Pending) {
                ((Pending)pending).add(bean2);
                return;
            }
        }
        this.activate(bean2);
    }

    protected abstract void activate(Object var1);

    static Object[] getPendingHolder() {
        Object[] holder = pendingHolder.get();
        if (holder == null) {
            holder = new Object[1];
            pendingHolder.set(holder);
        }
        return holder;
    }

    static final class Activator
    implements ProvisionListener {
        Activator() {
        }

        public <T> void onProvision(ProvisionListener.ProvisionInvocation<T> pi) {
            Object[] holder = BeanScheduler.getPendingHolder();
            if (holder[0] == null) {
                Object pending;
                holder[0] = PLACEHOLDER;
                try {
                    pi.provision();
                }
                finally {
                    pending = holder[0];
                    holder[0] = null;
                }
                if (pending instanceof Pending) {
                    ((Pending)pending).activate();
                }
            }
        }
    }

    private final class Pending
    extends ArrayList<Object> {
        Pending(Object bean2) {
            this.add(bean2);
        }

        public void activate() {
            int i2 = 0;
            int size = this.size();
            while (i2 < size) {
                BeanScheduler.this.activate(this.get(i2));
                ++i2;
            }
        }
    }
}

