/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Configuration;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.InterpolationFilterReader;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.sisu.inject.DeferredClass;
import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.plexus.ConfigurationImpl;
import org.eclipse.sisu.plexus.Hints;
import org.eclipse.sisu.plexus.PlexusBeanMetadata;
import org.eclipse.sisu.plexus.PlexusTypeRegistry;
import org.eclipse.sisu.plexus.PlexusXmlMetadata;
import org.eclipse.sisu.plexus.RequirementImpl;
import org.eclipse.sisu.plexus.Roles;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.Streams;

final class PlexusXmlScanner {
    private final Map<?, ?> variables;
    private final URL plexusXml;
    private final Map<String, PlexusBeanMetadata> metadata;

    PlexusXmlScanner(Map<?, ?> variables, URL plexusXml, Map<String, PlexusBeanMetadata> metadata) {
        this.variables = variables;
        this.plexusXml = plexusXml;
        this.metadata = metadata;
    }

    Map<Component, DeferredClass<?>> scan(ClassSpace space, boolean root) {
        PlexusTypeRegistry registry = new PlexusTypeRegistry(space);
        if (this.plexusXml != null) {
            this.parsePlexusXml(this.plexusXml, registry);
        }
        Enumeration<URL> e = root ? space.getResources("META-INF/plexus/components.xml") : space.findEntries("META-INF/plexus", "components.xml", false);
        while (e.hasMoreElements()) {
            this.parseComponentsXml(e.nextElement(), registry);
        }
        return registry.getComponents();
    }

    private static Reader filteredXmlReader(InputStream in, Map variables) throws IOException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((InputStream)in);
        if (variables != null) {
            return new InterpolationFilterReader((Reader)reader, variables);
        }
        return reader;
    }

    private void parsePlexusXml(URL url, PlexusTypeRegistry registry) {
        try {
            InputStream in = Streams.open(url);
            try {
                MXParser parser = new MXParser();
                parser.setInput(PlexusXmlScanner.filteredXmlReader(in, this.variables));
                parser.nextTag();
                parser.require(2, null, null);
                while (parser.nextTag() == 2) {
                    String name = parser.getName();
                    if ("load-on-start".equals(name)) {
                        while (parser.nextTag() == 2) {
                            PlexusXmlScanner.parseLoadOnStart(parser, registry);
                        }
                        continue;
                    }
                    if ("components".equals(name)) {
                        while (parser.nextTag() == 2) {
                            this.parseComponent(parser, registry);
                        }
                        continue;
                    }
                    parser.skipSubTree();
                }
            }
            finally {
                IOUtil.close((InputStream)in);
            }
        }
        catch (Exception e) {
            Logs.trace("Problem parsing: {}", url, e);
        }
    }

    private void parseComponentsXml(URL url, PlexusTypeRegistry registry) {
        try {
            InputStream in = Streams.open(url);
            try {
                MXParser parser = new MXParser();
                parser.setInput(PlexusXmlScanner.filteredXmlReader(in, this.variables));
                parser.nextTag();
                parser.require(2, null, null);
                parser.nextTag();
                parser.require(2, null, "components");
                while (parser.nextTag() == 2) {
                    this.parseComponent(parser, registry);
                }
            }
            finally {
                IOUtil.close((InputStream)in);
            }
        }
        catch (Exception e) {
            Logs.trace("Problem parsing: {}", url, e);
        }
    }

    private static void parseLoadOnStart(MXParser parser, PlexusTypeRegistry registry) throws XmlPullParserException, IOException {
        if ("component".equals(parser.getName())) {
            String role = null;
            String hint = "";
            while (parser.nextTag() == 2) {
                if ("role".equals(parser.getName())) {
                    role = PlexusXmlScanner.TEXT((XmlPullParser)parser);
                    continue;
                }
                if ("role-hint".equals(parser.getName())) {
                    hint = PlexusXmlScanner.TEXT((XmlPullParser)parser);
                    continue;
                }
                parser.skipSubTree();
            }
            if (role == null) {
                throw new XmlPullParserException("Missing <role> element.", (XmlPullParser)parser, null);
            }
            registry.loadOnStart(role, hint);
        } else {
            parser.skipSubTree();
        }
    }

    private void parseComponent(MXParser parser, PlexusTypeRegistry registry) throws XmlPullParserException, IOException {
        String role = null;
        String hint = "";
        String instantiationStrategy = "singleton";
        String description = "";
        String implementation = null;
        HashMap<String, Requirement> requirementMap = new HashMap<String, Requirement>();
        HashMap<String, Configuration> configurationMap = new HashMap<String, Configuration>();
        ClassSpace space = registry.getSpace();
        parser.require(2, null, "component");
        while (parser.nextTag() == 2) {
            String name = parser.getName();
            if ("requirements".equals(name)) {
                while (parser.nextTag() == 2) {
                    PlexusXmlScanner.parseRequirement(parser, space, requirementMap);
                }
                continue;
            }
            if ("configuration".equals(name)) {
                while (parser.nextTag() == 2) {
                    PlexusXmlScanner.parseConfiguration(parser, configurationMap);
                }
                continue;
            }
            if ("role".equals(name)) {
                role = PlexusXmlScanner.TEXT((XmlPullParser)parser).intern();
                continue;
            }
            if ("role-hint".equals(name)) {
                hint = PlexusXmlScanner.TEXT((XmlPullParser)parser);
                continue;
            }
            if ("instantiation-strategy".equals(name)) {
                instantiationStrategy = PlexusXmlScanner.TEXT((XmlPullParser)parser).intern();
                continue;
            }
            if ("description".equals(name)) {
                description = PlexusXmlScanner.TEXT((XmlPullParser)parser);
                continue;
            }
            if ("implementation".equals(name)) {
                implementation = PlexusXmlScanner.TEXT((XmlPullParser)parser).intern();
                continue;
            }
            parser.skipSubTree();
        }
        if (implementation == null) {
            throw new XmlPullParserException("Missing <implementation> element.", (XmlPullParser)parser, null);
        }
        if (role == null) {
            role = implementation;
        }
        if ((implementation = registry.addComponent(role, hint, instantiationStrategy, description, implementation)) != null) {
            this.updatePlexusBeanMetadata(implementation, configurationMap, requirementMap);
        }
    }

    private void updatePlexusBeanMetadata(String implementation, Map<String, Configuration> configurationMap, Map<String, Requirement> requirementMap) {
        if (!(this.metadata == null || configurationMap.isEmpty() && requirementMap.isEmpty())) {
            PlexusXmlMetadata beanMetadata = (PlexusXmlMetadata)this.metadata.get(implementation);
            if (beanMetadata != null) {
                beanMetadata.merge(configurationMap, requirementMap);
            } else {
                this.metadata.put(implementation, new PlexusXmlMetadata(configurationMap, requirementMap));
            }
        }
    }

    private static void parseRequirement(MXParser parser, ClassSpace space, Map<String, Requirement> requirementMap) throws XmlPullParserException, IOException {
        String role = null;
        ArrayList<String> hintList = new ArrayList<String>();
        String fieldName = null;
        boolean optional = false;
        parser.require(2, null, "requirement");
        while (parser.nextTag() == 2) {
            String name = parser.getName();
            if ("role".equals(name)) {
                role = PlexusXmlScanner.TEXT((XmlPullParser)parser).intern();
                continue;
            }
            if ("role-hint".equals(name)) {
                hintList.add(PlexusXmlScanner.TEXT((XmlPullParser)parser));
                continue;
            }
            if ("role-hints".equals(name)) {
                while (parser.nextTag() == 2) {
                    hintList.add(PlexusXmlScanner.TEXT((XmlPullParser)parser));
                }
                continue;
            }
            if ("field-name".equals(name)) {
                fieldName = PlexusXmlScanner.TEXT((XmlPullParser)parser);
                continue;
            }
            if ("optional".equals(name)) {
                optional = Boolean.parseBoolean(PlexusXmlScanner.TEXT((XmlPullParser)parser));
                continue;
            }
            parser.skipSubTree();
        }
        if (role == null) {
            throw new XmlPullParserException("Missing <role> element.", (XmlPullParser)parser, null);
        }
        if (fieldName == null) {
            fieldName = role;
        }
        requirementMap.put(fieldName, new RequirementImpl(space.deferLoadClass(role), optional, Hints.canonicalHints(hintList)));
    }

    private static void parseConfiguration(MXParser parser, Map<String, Configuration> configurationMap) throws XmlPullParserException, IOException {
        String name = parser.getName();
        String fieldName = Roles.camelizeName(name);
        StringBuilder buf = new StringBuilder();
        String header2 = parser.getText().trim();
        int depth = parser.getDepth();
        while (parser.next() != 3 || parser.getDepth() > depth) {
            buf.append(parser.getText().trim());
        }
        if (buf.indexOf("<") == 0 || header2.indexOf(61) > 0) {
            buf.insert(0, header2);
            if (!header2.endsWith("/>")) {
                buf.append("</" + name + '>');
            }
        }
        configurationMap.put(fieldName, new ConfigurationImpl(fieldName, buf.toString()));
    }

    private static String TEXT(XmlPullParser parser) throws XmlPullParserException, IOException {
        return parser.nextText().trim();
    }
}

