/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.api.dom.java;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaDomUtils;

public class Parameter {
    private String name;
    private FullyQualifiedJavaType type;
    private boolean isVarargs;
    private List<String> annotations;

    public Parameter(FullyQualifiedJavaType type, String name, boolean isVarargs) {
        this.name = name;
        this.type = type;
        this.isVarargs = isVarargs;
        this.annotations = new ArrayList<String>();
    }

    public Parameter(FullyQualifiedJavaType type, String name) {
        this(type, name, false);
    }

    public Parameter(FullyQualifiedJavaType type, String name, String annotation) {
        this(type, name, false);
        this.addAnnotation(annotation);
    }

    public Parameter(FullyQualifiedJavaType type, String name, String annotation, boolean isVarargs) {
        this(type, name, isVarargs);
        this.addAnnotation(annotation);
    }

    public String getName() {
        return this.name;
    }

    public FullyQualifiedJavaType getType() {
        return this.type;
    }

    public List<String> getAnnotations() {
        return this.annotations;
    }

    public void addAnnotation(String annotation) {
        this.annotations.add(annotation);
    }

    public String getFormattedContent(CompilationUnit compilationUnit) {
        StringBuilder sb = new StringBuilder();
        for (String annotation : this.annotations) {
            sb.append(annotation);
            sb.append(' ');
        }
        sb.append(JavaDomUtils.calculateTypeName(compilationUnit, this.type));
        sb.append(' ');
        if (this.isVarargs) {
            sb.append("... ");
        }
        sb.append(this.name);
        return sb.toString();
    }

    public String toString() {
        return this.getFormattedContent(null);
    }

    public boolean isVarargs() {
        return this.isVarargs;
    }
}

