/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.maven;

import java.io.File;
import java.util.StringTokenizer;
import org.mybatis.generator.exception.ShellException;
import org.mybatis.generator.internal.DefaultShellCallback;
import org.mybatis.generator.internal.util.messages.Messages;
import org.mybatis.generator.maven.MyBatisGeneratorMojo;

public class MavenShellCallback
extends DefaultShellCallback {
    private MyBatisGeneratorMojo mybatisGeneratorMojo;

    public MavenShellCallback(MyBatisGeneratorMojo mybatisGeneratorMojo, boolean overwrite) {
        super(overwrite);
        this.mybatisGeneratorMojo = mybatisGeneratorMojo;
    }

    @Override
    public File getDirectory(String targetProject, String targetPackage) throws ShellException {
        boolean rc;
        if (!"MAVEN".equals(targetProject)) {
            return super.getDirectory(targetProject, targetPackage);
        }
        File project = this.mybatisGeneratorMojo.getOutputDirectory();
        if (!project.exists()) {
            project.mkdirs();
        }
        if (!project.isDirectory()) {
            throw new ShellException(Messages.getString("Warning.9", project.getAbsolutePath()));
        }
        StringBuilder sb = new StringBuilder();
        StringTokenizer st = new StringTokenizer(targetPackage, ".");
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            sb.append(File.separatorChar);
        }
        File directory = new File(project, sb.toString());
        if (!directory.isDirectory() && !(rc = directory.mkdirs())) {
            throw new ShellException(Messages.getString("Warning.10", directory.getAbsolutePath()));
        }
        return directory;
    }
}

