/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.maven;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.exception.InvalidConfigurationException;
import org.mybatis.generator.exception.XMLParserException;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.util.ClassloaderUtility;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;
import org.mybatis.generator.logging.LogFactory;
import org.mybatis.generator.maven.MavenLogFactory;
import org.mybatis.generator.maven.MavenProgressCallback;
import org.mybatis.generator.maven.MavenShellCallback;
import org.mybatis.generator.maven.SqlScriptRunner;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class MyBatisGeneratorMojo
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="mybatis.generator.outputDirectory", defaultValue="${project.build.directory}/generated-sources/mybatis-generator", required=true)
    private File outputDirectory;
    @Parameter(property="mybatis.generator.configurationFile", defaultValue="${project.basedir}/src/main/resources/generatorConfig.xml", required=true)
    private File configurationFile;
    @Parameter(property="mybatis.generator.verbose", defaultValue="false")
    private boolean verbose;
    @Parameter(property="mybatis.generator.overwrite", defaultValue="false")
    private boolean overwrite;
    @Parameter(property="mybatis.generator.sqlScript")
    private String sqlScript;
    @Parameter(property="mybatis.generator.jdbcDriver")
    private String jdbcDriver;
    @Parameter(property="mybatis.generator.jdbcURL")
    private String jdbcURL;
    @Parameter(property="mybatis.generator.jdbcUserId")
    private String jdbcUserId;
    @Parameter(property="mybatis.generator.jdbcPassword")
    private String jdbcPassword;
    @Parameter(property="mybatis.generator.tableNames")
    private String tableNames;
    @Parameter(property="mybatis.generator.contexts")
    private String contexts;
    @Parameter(property="mybatis.generator.skip", defaultValue="false")
    private boolean skip;

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info("MyBatis generator is skipped.");
            return;
        }
        LogFactory.setLogFactory(new MavenLogFactory(this));
        List resources2 = this.project.getResources();
        ArrayList<String> resourceDirectories = new ArrayList<String>();
        for (Resource resource : resources2) {
            resourceDirectories.add(resource.getDirectory());
        }
        ClassLoader cl = ClassloaderUtility.getCustomClassloader(resourceDirectories);
        ObjectFactory.addResourceClassLoader(cl);
        if (this.configurationFile == null) {
            throw new MojoExecutionException(Messages.getString("RuntimeError.0"));
        }
        ArrayList<String> warnings = new ArrayList<String>();
        if (!this.configurationFile.exists()) {
            throw new MojoExecutionException(Messages.getString("RuntimeError.1", this.configurationFile.toString()));
        }
        this.runScriptIfNecessary();
        HashSet<String> fullyqualifiedTables = new HashSet<String>();
        if (StringUtility.stringHasValue(this.tableNames)) {
            StringTokenizer st = new StringTokenizer(this.tableNames, ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.length() <= 0) continue;
                fullyqualifiedTables.add(s);
            }
        }
        HashSet<String> contextsToRun = new HashSet<String>();
        if (StringUtility.stringHasValue(this.contexts)) {
            StringTokenizer st = new StringTokenizer(this.contexts, ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.length() <= 0) continue;
                contextsToRun.add(s);
            }
        }
        try {
            ConfigurationParser cp = new ConfigurationParser(this.project.getProperties(), warnings);
            Configuration config = cp.parseConfiguration(this.configurationFile);
            MavenShellCallback callback = new MavenShellCallback(this, this.overwrite);
            MyBatisGenerator myBatisGenerator = new MyBatisGenerator(config, callback, warnings);
            myBatisGenerator.generate(new MavenProgressCallback(this.getLog(), this.verbose), contextsToRun, fullyqualifiedTables);
        }
        catch (XMLParserException e) {
            for (String error : e.getErrors()) {
                this.getLog().error(error);
            }
            throw new MojoExecutionException(e.getMessage());
        }
        catch (SQLException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        catch (InvalidConfigurationException e) {
            for (String error : e.getErrors()) {
                this.getLog().error(error);
            }
            throw new MojoExecutionException(e.getMessage());
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        for (String error : warnings) {
            this.getLog().warn(error);
        }
        if (this.project != null && this.outputDirectory != null && this.outputDirectory.exists()) {
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
            Resource resource = new Resource();
            resource.setDirectory(this.outputDirectory.getAbsolutePath());
            resource.addInclude("**/*.xml");
            this.project.addResource(resource);
        }
    }

    private void runScriptIfNecessary() throws MojoExecutionException {
        if (this.sqlScript == null) {
            return;
        }
        SqlScriptRunner scriptRunner = new SqlScriptRunner(this.sqlScript, this.jdbcDriver, this.jdbcURL, this.jdbcUserId, this.jdbcPassword);
        scriptRunner.setLog(this.getLog());
        scriptRunner.executeScript();
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }
}

