/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client.reactive;

import java.net.HttpCookie;
import java.net.URI;
import java.util.Collection;
import java.util.function.Function;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.reactive.client.internal.PublisherContentProvider;
import org.eclipse.jetty.util.Callback;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.core.io.buffer.PooledDataBuffer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.AbstractClientHttpRequest;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class JettyClientHttpRequest
extends AbstractClientHttpRequest {
    private final Request jettyRequest;
    private final DataBufferFactory bufferFactory;

    public JettyClientHttpRequest(Request jettyRequest, DataBufferFactory bufferFactory) {
        this.jettyRequest = jettyRequest;
        this.bufferFactory = bufferFactory;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.valueOf(this.jettyRequest.getMethod());
    }

    @Override
    public URI getURI() {
        return this.jettyRequest.getURI();
    }

    @Override
    public Mono<Void> setComplete() {
        return this.doCommit(this::completes);
    }

    @Override
    public DataBufferFactory bufferFactory() {
        return this.bufferFactory;
    }

    @Override
    public Mono<Void> writeWith(Publisher<? extends DataBuffer> body2) {
        ReactiveRequest.Content content = (ReactiveRequest.Content)Flux.from(body2).map(this::toContentChunk).as(chunks -> ReactiveRequest.Content.fromPublisher((Publisher)chunks, (String)this.getContentType()));
        this.jettyRequest.content((ContentProvider)new PublisherContentProvider(content));
        return this.doCommit(this::completes);
    }

    @Override
    public Mono<Void> writeAndFlushWith(Publisher<? extends Publisher<? extends DataBuffer>> body2) {
        ReactiveRequest.Content content = (ReactiveRequest.Content)Flux.from(body2).flatMap(Function.identity()).doOnDiscard(PooledDataBuffer.class, DataBufferUtils::release).map(this::toContentChunk).as(chunks -> ReactiveRequest.Content.fromPublisher((Publisher)chunks, (String)this.getContentType()));
        this.jettyRequest.content((ContentProvider)new PublisherContentProvider(content));
        return this.doCommit(this::completes);
    }

    private String getContentType() {
        MediaType contentType = this.getHeaders().getContentType();
        return contentType != null ? contentType.toString() : "application/octet-stream";
    }

    private Mono<Void> completes() {
        return Mono.empty();
    }

    private ContentChunk toContentChunk(final DataBuffer buffer) {
        return new ContentChunk(buffer.asByteBuffer(), new Callback(){

            public void succeeded() {
                DataBufferUtils.release(buffer);
            }

            public void failed(Throwable x) {
                DataBufferUtils.release(buffer);
                throw Exceptions.propagate((Throwable)x);
            }
        });
    }

    @Override
    protected void applyCookies() {
        this.getCookies().values().stream().flatMap(Collection::stream).map(cookie -> new HttpCookie(cookie.getName(), cookie.getValue())).forEach(arg_0 -> ((Request)this.jettyRequest).cookie(arg_0));
    }

    @Override
    protected void applyHeaders() {
        HttpHeaders headers = this.getHeaders();
        headers.forEach((key, value) -> value.forEach(v -> this.jettyRequest.header(key, v)));
        if (!headers.containsKey("Accept")) {
            this.jettyRequest.header("Accept", "*/*");
        }
    }
}

