/*
 * Decompiled with CFR 0.152.
 */
package run.wj.commons.plugin.generator.codegen.mybatis.model;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.IntrospectedColumn;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.AbstractJavaGenerator;
import run.wj.commons.plugin.generator.util.IntrospectUtil;
import run.wj.commons.utils.ObjectUtils;
import run.wj.commons.utils.StringUtils;

public class JavaRepositoryGenerator
extends AbstractJavaGenerator {
    private FullyQualifiedJavaType repositoryType;
    private FullyQualifiedJavaType dao;
    private FullyQualifiedJavaType model;
    private FullyQualifiedJavaType inModel;
    private FullyQualifiedJavaType listModel;
    private IntrospectedColumn createTime;
    private IntrospectedColumn updateTime;
    private IntrospectedColumn wasDel;
    private IntrospectedColumn id;

    private void init() {
        this.repositoryType = new FullyQualifiedJavaType(this.context.getProperty("repositoryFullyQualifiedJavaType"));
        this.inModel = ObjectUtils.isEmpty(this.context.getProperty("inModelFullyQualifiedJavaType")) ? new FullyQualifiedJavaType(this.introspectedTable.getBaseRecordType()) : new FullyQualifiedJavaType(this.context.getProperty("inModelFullyQualifiedJavaType"));
        this.dao = new FullyQualifiedJavaType(this.introspectedTable.getMyBatis3JavaMapperType());
        this.model = new FullyQualifiedJavaType(this.introspectedTable.getBaseRecordType());
        this.createTime = IntrospectUtil.getIntrospectedColumnByColumnName(this.introspectedTable.getAllColumns(), "create_time", "created_time");
        this.updateTime = IntrospectUtil.getIntrospectedColumnByColumnName(this.introspectedTable.getAllColumns(), "update_time", "updated_time");
        this.wasDel = IntrospectUtil.getIntrospectedColumnByColumnName(this.introspectedTable.getAllColumns(), "is_del", "was_del", "is_delete");
        this.id = IntrospectUtil.getIntrospectedColumnByColumnName(this.introspectedTable.getAllColumns(), new String[]{"id"});
    }

    @Override
    public List<CompilationUnit> getCompilationUnits() {
        this.init();
        this.introspectedTable.getBaseColumns();
        TopLevelClass clazz = new TopLevelClass(this.repositoryType);
        clazz.addImportedType(this.inModel);
        clazz.addImportedType(this.model);
        clazz.addImportedType("java.util.List");
        clazz.addImportedType("java.util.ArrayList");
        clazz.setVisibility(JavaVisibility.PUBLIC);
        clazz.addImportedType(this.model);
        clazz.addImportedType(this.dao);
        clazz.addImportedType("org.springframework.beans.factory.annotation.Autowired");
        clazz.addImportedType("org.springframework.stereotype.Repository");
        clazz.addAnnotation("@Repository");
        Field dao = new Field();
        dao.setVisibility(JavaVisibility.PRIVATE);
        dao.setType(this.dao);
        String name = this.dao.getShortName();
        String replaceName = org.apache.commons.lang3.StringUtils.replaceOnce(name, this.context.getProperty("contextPluginDaoNamePrefix"), "");
        String caseName = StringUtils.getLowerCaseFirstCharacterCase(replaceName);
        dao.setName(caseName);
        dao.addAnnotation("@Autowired");
        clazz.addField(dao);
        this.addMethodAddOrUpd(clazz, dao);
        this.addSelectByPrimaryKey(clazz, dao);
        this.addSelectByCondition(clazz, dao);
        ArrayList<CompilationUnit> answer = new ArrayList<CompilationUnit>();
        answer.add(clazz);
        return answer;
    }

    private void addSelectByCondition(TopLevelClass clazz, Field dao) {
        Method method = new Method();
        method.addAnnotation("@ChooseDataSource(DataSources.?)");
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("selectByCondition");
        String parameterName = "condition";
        FullyQualifiedJavaType listType = new FullyQualifiedJavaType("List<" + this.introspectedTable.getBaseRecordType() + ">");
        method.setReturnType(listType);
        method.addParameter(new Parameter(this.inModel, parameterName));
        method.addBodyLine("if (" + parameterName + " == null){");
        method.addBodyLine("  return new ArrayList();");
        method.addBodyLine("}");
        method.addBodyLine("  return " + dao.getName() + ".selectByCondition(" + parameterName + ");");
        clazz.addMethod(method);
    }

    private void addSelectByPrimaryKey(TopLevelClass clazz, Field dao) {
        Method method = new Method();
        method.addAnnotation("@ChooseDataSource(DataSources.?)");
        method.setReturnType(this.model);
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("selectByPrimaryKey");
        String parameterName = "id";
        method.addParameter(new Parameter(this.id.getFullyQualifiedJavaType(), parameterName));
        method.addBodyLine("if (id == null ){");
        method.addBodyLine("  return null;");
        method.addBodyLine("}");
        method.addBodyLine("  return " + dao.getName() + ".selectByPrimaryKey(" + parameterName + ");");
        clazz.addMethod(method);
    }

    private void addMethodAddOrUpd(TopLevelClass clazz, Field dao) {
        Method method = new Method();
        method.addAnnotation("@ChooseDataSource(DataSources.?)");
        method.setReturnType(FullyQualifiedJavaType.getIntInstance());
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("addOrUpdate");
        String parameterName = "record";
        method.addParameter(new Parameter(this.model, parameterName));
        method.addBodyLine("if (" + parameterName + "==null){");
        method.addBodyLine("return 0;");
        method.addBodyLine("}");
        method.addBodyLine("");
        method.addBodyLine("if(" + parameterName + ".getId()==null ){");
        if (!ObjectUtils.isEmpty(IntrospectUtil.putSetMethod(parameterName, this.createTime))) {
            method.addBodyLine("" + IntrospectUtil.putSetMethod(parameterName, this.createTime));
        }
        if (!ObjectUtils.isEmpty(IntrospectUtil.putSetMethod(parameterName, this.updateTime))) {
            method.addBodyLine("" + IntrospectUtil.putSetMethod(parameterName, this.updateTime));
        }
        if (!ObjectUtils.isEmpty(IntrospectUtil.putSetMethod(parameterName, this.wasDel, IntrospectUtil.getZeroValue(this.wasDel)))) {
            method.addBodyLine("" + IntrospectUtil.putSetMethod(parameterName, this.wasDel, IntrospectUtil.getZeroValue(this.wasDel)));
        }
        method.addBodyLine("return " + dao.getName() + ".insert(" + parameterName + ");");
        method.addBodyLine("}else{");
        if (!ObjectUtils.isEmpty(IntrospectUtil.putSetMethod(parameterName, this.updateTime))) {
            method.addBodyLine("  " + IntrospectUtil.putSetMethod(parameterName, this.updateTime));
        }
        method.addBodyLine("return " + dao.getName() + ".updateByPrimaryKeySelective(" + parameterName + ");");
        method.addBodyLine("}");
        clazz.addMethod(method);
    }
}

