/*
 * Decompiled with CFR 0.152.
 */
package run.wj.commons.plugin.generator.codegen.mybatis.model;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.dom.java.CompilationUnit;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.codegen.AbstractJavaGenerator;
import run.wj.commons.utils.StringUtils;

public class JavaServiceImplGenerator
extends AbstractJavaGenerator {
    private FullyQualifiedJavaType serviceType;
    private FullyQualifiedJavaType fieldRepositoryType;
    private FullyQualifiedJavaType implInterfaceType;
    private FullyQualifiedJavaType repositoryType;

    private void calculateFullyQualifiedJavaType() {
        this.serviceType = new FullyQualifiedJavaType(this.context.getProperty("serviceImplFullyQualifiedJavaType"));
        this.implInterfaceType = new FullyQualifiedJavaType(this.context.getProperty("serviceFullyQualifiedJavaType"));
        this.fieldRepositoryType = new FullyQualifiedJavaType(this.context.getProperty("repositoryFullyQualifiedJavaType"));
        this.repositoryType = new FullyQualifiedJavaType(this.context.getProperty("repositoryFullyQualifiedJavaType"));
    }

    @Override
    public List<CompilationUnit> getCompilationUnits() {
        this.calculateFullyQualifiedJavaType();
        TopLevelClass clazz = new TopLevelClass(this.serviceType);
        clazz.addSuperInterface(this.implInterfaceType);
        clazz.setVisibility(JavaVisibility.PUBLIC);
        clazz.addImportedType(this.introspectedTable.getBaseRecordType());
        clazz.addImportedType(this.fieldRepositoryType);
        clazz.addImportedType("org.springframework.beans.factory.annotation.Autowired");
        clazz.addImportedType("org.springframework.stereotype.Service");
        clazz.addImportedType(this.implInterfaceType);
        clazz.addAnnotation("@Service");
        Field field = new Field();
        field.setVisibility(JavaVisibility.PRIVATE);
        field.setType(this.fieldRepositoryType);
        field.setName(StringUtils.getLowerCaseFirstCharacterCase(this.fieldRepositoryType.getShortName()));
        field.addAnnotation("@Autowired");
        clazz.addField(field);
        Method method = new Method();
        method.addAnnotation("@Override");
        method.setReturnType(FullyQualifiedJavaType.getIntInstance());
        method.setVisibility(JavaVisibility.PUBLIC);
        method.setName("addOrUpdate");
        FullyQualifiedJavaType parameterType = new FullyQualifiedJavaType(this.introspectedTable.getFullyQualifiedTable().getDomainObjectName());
        method.addParameter(new Parameter(parameterType, "record"));
        String parameterName = "record";
        Field repository = new Field();
        repository.setVisibility(JavaVisibility.PRIVATE);
        repository.setType(this.repositoryType);
        String name = this.repositoryType.getShortName();
        String replaceName = org.apache.commons.lang3.StringUtils.replaceOnce(name, this.context.getProperty("contextPluginDaoNamePrefix"), "");
        String caseName = StringUtils.getLowerCaseFirstCharacterCase(replaceName);
        repository.setName(caseName);
        repository.addAnnotation("@Autowired");
        clazz.addField(repository);
        method.addBodyLine("return " + repository.getName() + ".addOrUpdate(" + parameterName + ");");
        clazz.addMethod(method);
        ArrayList<CompilationUnit> answer = new ArrayList<CompilationUnit>();
        answer.add(clazz);
        return answer;
    }
}

