/*
 * Decompiled with CFR 0.152.
 */
package run.wj.commons.service.permissionload;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.RestController;
import run.wj.commons.service.permissionload.Permission;
import run.wj.commons.utils.AnnotationUtils;

public abstract class InterfaceScanService {
    protected List<String> skipUri = new ArrayList<String>();
    protected List<String> skipRegulars = new ArrayList<String>();
    protected List<String> pickByStartWith = new ArrayList<String>();
    protected List<String> skipContains = new ArrayList<String>();

    protected void addSkipRegular() {
        this.skipRegulars.add("^/skip/.*");
    }

    protected void addSkipUri() {
        this.skipUri.add("/system/reset");
        this.skipUri.add("/permission/savePermission");
        this.skipUri.add("/permission/reload");
    }

    protected abstract String getClazzDescribeName(Class var1);

    private String getMark(String systemUniqueMark, String methodMapping) {
        StringBuffer sb = new StringBuffer();
        sb.append(systemUniqueMark);
        if (!systemUniqueMark.endsWith("/") && !methodMapping.startsWith("/")) {
            sb.append("/");
        }
        sb.append(methodMapping);
        return sb.toString();
    }

    protected abstract String getMethodDescribeName(Method var1);

    private String getRequestMapping(String clsMapping, String methodMapping) {
        StringBuffer sb = new StringBuffer();
        if (!ObjectUtils.isEmpty(clsMapping) && !clsMapping.startsWith("/")) {
            sb.append("/");
        }
        sb.append(clsMapping);
        if (!clsMapping.endsWith("/") && !methodMapping.startsWith("/")) {
            sb.append("/");
        }
        sb.append(methodMapping);
        return sb.toString();
    }

    public List<Permission> loadPermission(String systemUniqueMark, ApplicationContext context) {
        return this.scanInterfaceGetPermission(systemUniqueMark, context);
    }

    protected boolean pickUri(String systemRequestMapping) {
        if (ObjectUtils.isEmpty(this.pickByStartWith)) {
            return true;
        }
        for (String startWith : this.pickByStartWith) {
            if (!systemRequestMapping.startsWith(startWith)) continue;
            return true;
        }
        return false;
    }

    private List<Permission> scanInterfaceGetPermission(String systemUniqueMark, ApplicationContext context) {
        if (context == null) {
            return new ArrayList<Permission>();
        }
        this.addSkipUri();
        this.addSkipRegular();
        String[] rest = context.getBeanNamesForAnnotation(RestController.class);
        String[] base = context.getBeanNamesForAnnotation(Controller.class);
        HashSet<String> all = Sets.newHashSet(ArrayUtils.addAll(rest, base));
        all.remove("basicErrorController");
        ArrayList<Permission> permissions = Lists.newArrayList();
        if (ObjectUtils.isEmpty(all)) {
            return new ArrayList<Permission>();
        }
        for (Object e : all) {
            String s = String.valueOf(e);
            Object o = context.getBean(s);
            Class<?> cla = o.getClass();
            if (AopUtils.isAopProxy(o)) {
                cla = AopUtils.getTargetClass(o);
                if (AopUtils.isJdkDynamicProxy(o)) {
                    cla = cla.getSuperclass();
                }
                while (cla.getName().contains("$$")) {
                    cla = cla.getSuperclass();
                }
            }
            String clsMapping = AnnotationUtils.getClassMappingValue(cla);
            String clazzDescribeName = "";
            clazzDescribeName = this.getClazzDescribeName(cla);
            for (Method method : cla.getMethods()) {
                String methodMapping = AnnotationUtils.getMethodMappingValue(method);
                if (ObjectUtils.isEmpty(methodMapping)) continue;
                Permission permission = new Permission();
                String systemRequestMapping = this.getRequestMapping(clsMapping, methodMapping);
                if (this.skipUri(systemRequestMapping) || !this.pickUri(systemRequestMapping)) continue;
                String methodDescribeName = this.getMethodDescribeName(method);
                permission.setUri(systemRequestMapping);
                permission.setName(clazzDescribeName + "-" + methodDescribeName);
                permission.setType(0);
                permission.setSystemMark(systemUniqueMark);
                permission.setMark(this.getMark(systemUniqueMark, permission.getUri()));
                permissions.add(permission);
            }
        }
        return permissions;
    }

    protected boolean skipUri(String systemRequestMapping) {
        if (this.skipUri.contains(systemRequestMapping)) {
            return true;
        }
        for (String skipRegular : this.skipRegulars) {
            if (!systemRequestMapping.matches(skipRegular)) continue;
            return true;
        }
        for (String skipContain : this.skipContains) {
            if (!systemRequestMapping.contains(skipContain)) continue;
            return true;
        }
        return false;
    }
}

