/*
 * Decompiled with CFR 0.152.
 */
package run.wj.commons.spring;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.mvc.method.annotation.RequestResponseBodyMethodProcessor;
import run.wj.commons.spring.annotation.RequestBodyExt;
import run.wj.commons.utils.ObjectUtils;

public class RequestResponseBodyMethodExtProcessor
implements HandlerMethodArgumentResolver {
    private final Logger log = LoggerFactory.getLogger(RequestResponseBodyMethodExtProcessor.class);
    private RequestResponseBodyMethodProcessor requestResponseBodyMethodProcessor;

    @Override
    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        ArrayList<HttpMessageConverter<?>> list = Lists.newArrayList();
        list.add(new MappingJackson2HttpMessageConverter());
        this.requestResponseBodyMethodProcessor = new RequestResponseBodyMethodProcessor(list);
        LinkedHashMap object = this.requestResponseBodyMethodProcessor.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        if (object == null) {
            try {
                object = parameter.getParameterType().newInstance();
            }
            catch (Exception e) {
                object = Maps.newLinkedHashMap();
            }
        }
        if (object instanceof LinkedHashMap) {
            Iterator<String> names = webRequest.getParameterNames();
            while (names.hasNext()) {
                String key = names.next();
                String s = webRequest.getParameter(key);
                if (StringUtils.isBlank(s)) continue;
                ((Map)object).put(key, s);
            }
        } else {
            Iterator<String> names = webRequest.getParameterNames();
            while (names.hasNext()) {
                String key = names.next();
                String value = webRequest.getParameter(key);
                if (StringUtils.isBlank(value) || !PropertyUtils.isWriteable(object, key)) continue;
                try {
                    Class<?> type = PropertyUtils.getPropertyType(object, key);
                    PropertyUtils.setProperty(object, key, ObjectUtils.objectOfString(type, value));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return object;
    }

    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        return parameter.hasParameterAnnotation(RequestBodyExt.class);
    }
}

