/*
 * Decompiled with CFR 0.152.
 */
package run.wj.commons.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.time.Instant;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import run.wj.commons.utils.ObjectUtils;
import run.wj.commons.utils.RequestUtils;

public class JwtUtil {
    public static final long EXPIRATION_TIME = 43200000L;
    public static final String SECRET = "secret";
    public static final String TOKEN_PREFIX = "bearer";
    public static final String TOKEN_PREFIX_UPPERCASE = "Bearer";
    public static final String TOKEN_HEADER = "Authorization";
    public static final String KEY_OF_USER_ID = "userId";
    public static final String KEY_OF_NICK_NAME = "nickName";
    public static final String KEY_OF_USER_NAME = "userName";
    public static final String KEY_OF_SYSTEM_VERSION = "systemVersion";
    private final Logger log = LoggerFactory.getLogger(JwtUtil.class);

    public static String createAuthentication(String subject, String userId, String roles) {
        return JwtUtil.createAuthentication(subject, userId, roles, 43200000L, SECRET);
    }

    public static String createAuthentication(String username, String userId, String roles, long expirationTime, String secret) {
        if (ObjectUtils.isEmpty(username) || ObjectUtils.isEmpty(userId) || ObjectUtils.isEmpty(roles) || expirationTime < 0L || ObjectUtils.isEmpty(secret)) {
            return null;
        }
        return Jwts.builder().claim(KEY_OF_USER_ID, userId).claim("roles", roles).setSubject(username).setExpiration(new Date(Instant.now().plusSeconds(expirationTime).toEpochMilli())).signWith(SignatureAlgorithm.HS512, secret.getBytes()).compact();
    }

    public static String get(String key) {
        return (String)JwtUtil.get(key, null, null);
    }

    public static String get(String key, String signer) {
        return (String)JwtUtil.get(key, signer, null);
    }

    public static <T> T get(String key, String signer, Class<T> tClass) {
        Claims claims = JwtUtil.getClaims(signer);
        if (ObjectUtils.isEmpty(key)) {
            return (T)claims.getSubject();
        }
        if (claims == null) {
            return null;
        }
        if (tClass == null) {
            return (T)String.valueOf(claims.get(key));
        }
        return (T)String.valueOf(claims.get(key, tClass));
    }

    private static Claims getClaims(String signer) {
        HttpServletRequest request;
        if (StringUtils.isBlank(signer)) {
            signer = SECRET;
        }
        if ((request = RequestUtils.getRequest()) == null) {
            return null;
        }
        String token = request.getHeader(TOKEN_HEADER);
        if (token == null) {
            return null;
        }
        token = token.replace(TOKEN_PREFIX, "");
        token = token.replace(TOKEN_PREFIX_UPPERCASE, "");
        Claims claims = (Claims)Jwts.parser().setSigningKey(signer.getBytes()).parseClaimsJws(token).getBody();
        return claims;
    }

    public static String getRequestToken() {
        HttpServletRequest request = RequestUtils.getRequest();
        return request.getHeader(TOKEN_HEADER);
    }

    public static String getUserId() {
        return JwtUtil.get(KEY_OF_USER_ID);
    }

    @Deprecated
    public static Long getUserId8ParseAuthentication() {
        Claims claims = JwtUtil.parseAuthenticationByKey(TOKEN_HEADER);
        if (ObjectUtils.isEmpty(claims) || claims.get(KEY_OF_USER_ID) == null) {
            return null;
        }
        return ObjectUtils.toLong(claims.get(KEY_OF_USER_ID));
    }

    @Deprecated
    public static Long getUserId8ParseAuthentication(String secret) {
        Claims claims = JwtUtil.parseAuthenticationByKey(TOKEN_HEADER, secret);
        if (ObjectUtils.isEmpty(claims) || claims.get(KEY_OF_USER_ID) == null) {
            return null;
        }
        return ObjectUtils.toLong(claims.get(KEY_OF_USER_ID));
    }

    public static String getUserName() {
        return JwtUtil.get(null);
    }

    public static void main(String[] args) {
        String authentication = JwtUtil.createAuthentication("826964420", "826964420", "user");
        System.out.println(authentication);
        System.out.println(JwtUtil.getUserId());
    }

    @Deprecated
    public static Claims parseAuthentication() {
        return JwtUtil.parseAuthenticationByKey(TOKEN_HEADER);
    }

    @Deprecated
    public static Claims parseAuthentication(String token) {
        return JwtUtil.parseAuthentication(token, SECRET, TOKEN_PREFIX);
    }

    @Deprecated
    public static Claims parseAuthentication(String token, String secret) {
        return JwtUtil.parseAuthentication(token, secret, TOKEN_PREFIX);
    }

    @Deprecated
    public static Claims parseAuthentication(String token, String secret, String tokenPrefix) {
        if (ObjectUtils.isEmpty(token) || ObjectUtils.isEmpty(secret) || ObjectUtils.isEmpty(tokenPrefix)) {
            return null;
        }
        return (Claims)Jwts.parser().setSigningKey(secret.getBytes()).parseClaimsJws(token.replace(tokenPrefix, "")).getBody();
    }

    public static Claims parseAuthentication(String token, byte[] secret, String tokenPrefix) {
        if (ObjectUtils.isEmpty(token) || ObjectUtils.isEmpty(secret) || ObjectUtils.isEmpty(tokenPrefix)) {
            return null;
        }
        return (Claims)Jwts.parser().setSigningKey(secret).parseClaimsJws(token.replace(tokenPrefix, "")).getBody();
    }

    @Deprecated
    public static Claims parseAuthenticationByKey(String headerKey) {
        String authorization = RequestUtils.getRequest().getHeader(headerKey);
        return JwtUtil.parseAuthentication(authorization);
    }

    @Deprecated
    public static Claims parseAuthenticationByKey(String headerKey, String secret) {
        String authorization = RequestUtils.getRequest().getHeader(headerKey);
        return JwtUtil.parseAuthentication(authorization, secret);
    }
}

