/*
 * Decompiled with CFR 0.152.
 */
package run.wj.commons.utils;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class LogUtil {
    public static String getTrace(Throwable e, Class clazz) {
        if (e == null || e.getLocalizedMessage() == null) {
            return "";
        }
        StringBuilder reason = new StringBuilder();
        Throwable error = LogUtil.getError(e);
        String s1 = StringUtils.join((Object[])ArrayUtils.subarray(StringUtils.split(clazz.getPackage().getName(), "."), 0, 2), ".");
        for (StackTraceElement element : error.getStackTrace()) {
            String className = element.getClassName();
            if (!className.contains(s1) || className.contains("$$")) continue;
            reason.append(element.getClassName());
            reason.append(".");
            reason.append(element.getMethodName());
            reason.append(".");
            reason.append(element.getLineNumber());
            break;
        }
        reason.append(e.getLocalizedMessage());
        String result = reason.toString();
        if (StringUtils.isEmpty(reason)) {
            result = e.getCause().toString();
        }
        return result;
    }

    private static Throwable getError(Throwable e) {
        Throwable cause = e.getCause();
        if (cause != null) {
            LogUtil.getError(cause);
        }
        return e;
    }
}

