/*
 * Decompiled with CFR 0.152.
 */
package run.wj.commons.utils;

import com.lowagie.text.DocumentException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;
import run.wj.commons.utils.ObjectUtils;

public class PDFUtil {
    public static void main(String[] args) throws IOException, DocumentException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("name", "\u9c81\u5bb6\u5b81");
        data.put("fileUrl", "https://xcx-sdzp-1255861069.cos.ap-shanghai.myqcloud.com/public/DNxKfETbAz1534399328729.jpg");
        String fontPath = "E:\\PingFang Regular_1.ttf";
        String outPdfPath = "E:\\HelloWorld.pdf";
        String htmlTmpPath = "E:\\";
        String htmlTmpName = "template_freemarker_fs.html";
        PDFUtil.getPdf(data, htmlTmpPath, htmlTmpName, fontPath, outPdfPath);
    }

    public static byte[] getPdf(Map<String, Object> htmlTmpData, String htmlTmpPath, String htmlTmpName, String fontPath) {
        String content = PDFUtil.freeMarkerRender(htmlTmpData, htmlTmpPath, htmlTmpName);
        try {
            return PDFUtil.createPdf(fontPath, content);
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void getPdf(Map<String, Object> htmlTmpData, String htmlTmpPath, String htmlTmpName, String fontPath, String dest) {
        String content = PDFUtil.freeMarkerRender(htmlTmpData, htmlTmpPath, htmlTmpName);
        try {
            PDFUtil.createPdf(fontPath, content, dest);
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String freeMarkerRender(Map<String, Object> data, String htmlTmpPath, String htmlTmpName) {
        StringWriter out = new StringWriter();
        try {
            Configuration freemarkerCfg = new Configuration();
            freemarkerCfg.setDirectoryForTemplateLoading(new File(htmlTmpPath));
            Template template = freemarkerCfg.getTemplate(htmlTmpName);
            template.setEncoding("UTF-8");
            template.process(data, out);
            ((Writer)out).flush();
            String string = ((Object)out).toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                ((Writer)out).close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    private static void createPdf(String fontPath, String content, String dest) throws IOException, DocumentException {
        ITextRenderer render = new ITextRenderer();
        ITextFontResolver fontResolver = render.getFontResolver();
        fontResolver.addFont(fontPath, "Identity-H", false);
        render.setDocumentFromString(content);
        render.layout();
        render.createPDF(new FileOutputStream(dest));
    }

    private static byte[] createPdf(String fontPath, String content) throws IOException, DocumentException {
        ITextRenderer render = new ITextRenderer();
        ITextFontResolver fontResolver = render.getFontResolver();
        if (!ObjectUtils.isEmpty(fontPath)) {
            fontResolver.addFont(fontPath, "Identity-H", false);
        }
        render.setDocumentFromString(content);
        render.layout();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        render.createPDF(byteArrayOutputStream, true);
        return byteArrayOutputStream.toByteArray();
    }
}

