/*
 * Decompiled with CFR 0.152.
 */
package run.wj.commons.utils;

import eu.bitwalker.useragentutils.DeviceType;
import eu.bitwalker.useragentutils.UserAgent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestUtils {
    static final Logger log = Logger.getLogger(RequestUtils.class);

    public static String getUri() {
        return RequestUtils.getRequest().getRequestURI();
    }

    public static HttpServletRequest getRequest() {
        HttpServletRequest request = null;
        try {
            request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        }
        catch (Exception var2) {
            log.warn("\u4f1a\u8bdd\u5df2\u7ed3\u675f\uff01");
        }
        return request;
    }

    public static HttpServletResponse getResponse() {
        HttpServletResponse response = null;
        try {
            response = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getResponse();
        }
        catch (Exception var2) {
            log.warn("\u4f1a\u8bdd\u5df2\u7ed3\u675f\uff01");
        }
        return response;
    }

    public static String getIp() {
        HttpServletRequest request = RequestUtils.getRequest();
        if (request == null) {
            return "";
        }
        String ip = request.getHeader("x-forwarded-for");
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("PRoxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip;
    }

    public static boolean isMobile() {
        if (RequestUtils.getRequest() == null) {
            return false;
        }
        UserAgent userAgent = UserAgent.parseUserAgentString(RequestUtils.getRequest().getHeader("user-agent"));
        return userAgent.getOperatingSystem().getDeviceType().equals((Object)DeviceType.MOBILE);
    }

    public static String getDevice() {
        if (RequestUtils.getRequest() == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        UserAgent userAgent = UserAgent.parseUserAgentString(RequestUtils.getRequest().getHeader("user-agent"));
        userAgent.getBrowser().getBrowserType().getName();
        userAgent.getOperatingSystem().getDeviceType();
        sb.append(userAgent.getOperatingSystem().getDeviceType().getName());
        sb.append("-");
        sb.append(userAgent.getOperatingSystem().getManufacturer().getName());
        sb.append("-");
        sb.append(userAgent.getBrowser().getBrowserType().getName());
        sb.append("-");
        sb.append(userAgent.getBrowserVersion());
        sb.append("-");
        sb.append(userAgent.getBrowser().getRenderingEngine().name());
        return sb.toString();
    }
}

